/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.util.graph.impl;

import com.ibm.wala.util.graph.EdgeManager;
import java.util.Iterator;
import org.jspecify.annotations.NullUnmarked;
import org.jspecify.annotations.Nullable;

public class SelfLoopAddedEdgeManager<T>
implements EdgeManager<T> {
    private final EdgeManager<T> original;

    public SelfLoopAddedEdgeManager(EdgeManager<T> original) {
        if (original == null) {
            throw new IllegalArgumentException("original is null");
        }
        this.original = original;
    }

    @Override
    public Iterator<T> getPredNodes(@Nullable T n) {
        if (this.original.hasEdge(n, n)) {
            return this.original.getPredNodes(n);
        }
        return new PrependItterator(this.original.getPredNodes(n), n);
    }

    @Override
    public int getPredNodeCount(T n) {
        if (this.original.hasEdge(n, n)) {
            return this.original.getPredNodeCount(n);
        }
        return this.original.getPredNodeCount(n) + 1;
    }

    @Override
    public Iterator<T> getSuccNodes(@Nullable T n) {
        if (this.original.hasEdge(n, n)) {
            return this.original.getSuccNodes(n);
        }
        return new PrependItterator(this.original.getSuccNodes(n), n);
    }

    @Override
    public int getSuccNodeCount(T n) {
        if (this.original.hasEdge(n, n)) {
            return this.original.getSuccNodeCount(n);
        }
        return this.original.getSuccNodeCount(n) + 1;
    }

    @Override
    public void addEdge(T src, T dst) {
        this.original.addEdge(src, dst);
    }

    @Override
    public void removeEdge(T src, T dst) throws UnsupportedOperationException {
        this.original.removeEdge(src, dst);
    }

    @Override
    public void removeAllIncidentEdges(T node) throws UnsupportedOperationException {
        this.original.removeAllIncidentEdges(node);
    }

    @Override
    public void removeIncomingEdges(T node) throws UnsupportedOperationException {
        this.original.removeIncomingEdges(node);
    }

    @Override
    public void removeOutgoingEdges(T node) throws UnsupportedOperationException {
        this.original.removeOutgoingEdges(node);
    }

    @Override
    @NullUnmarked
    public boolean hasEdge(@Nullable T src, @Nullable T dst) {
        if (src.equals(dst)) {
            return true;
        }
        return this.original.hasEdge(src, dst);
    }

    private class PrependItterator
    implements Iterator<T> {
        private boolean usedFirst = false;
        private final Iterator<T> original;
        private @Nullable T first;

        public PrependItterator(@Nullable Iterator<T> original, T first) {
            this.original = original;
            this.first = first;
        }

        @Override
        public boolean hasNext() {
            if (!this.usedFirst) {
                return true;
            }
            return this.original.hasNext();
        }

        @Override
        public @Nullable T next() {
            if (!this.usedFirst) {
                Object tmp = this.first;
                this.first = null;
                this.usedFirst = true;
                return tmp;
            }
            return this.original.next();
        }

        @Override
        public void remove() {
            assert (false);
        }
    }
}

