/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.util.graph.impl;

import com.ibm.wala.util.collections.HashMapFactory;
import com.ibm.wala.util.collections.SimpleVector;
import com.ibm.wala.util.debug.Assertions;
import com.ibm.wala.util.debug.UnimplementedError;
import com.ibm.wala.util.graph.Graph;
import com.ibm.wala.util.graph.OrderedMultiGraph;
import com.ibm.wala.util.graph.impl.SlowSparseNumberedGraph;
import java.util.Iterator;
import java.util.Map;
import java.util.stream.Stream;
import org.jspecify.annotations.Nullable;

public class BasicOrderedMultiGraph<T>
implements OrderedMultiGraph<T> {
    final Map<T, SimpleVector<T>> successorEdges = HashMapFactory.make();
    private final Graph<T> delegate = SlowSparseNumberedGraph.make();

    @Override
    public void addEdge(T src, T dst) throws IllegalArgumentException {
        this.delegate.addEdge(src, dst);
        SimpleVector<T> s = this.successorEdges.get(src);
        if (s == null) {
            s = new SimpleVector();
            this.successorEdges.put(src, s);
        }
        s.set(s.getMaxIndex() + 1, dst);
    }

    @Override
    public void addEdge(int i, T src, T dst) throws IllegalArgumentException {
        this.delegate.addEdge(src, dst);
        SimpleVector<T> s = this.successorEdges.get(src);
        if (s == null) {
            s = new SimpleVector();
            this.successorEdges.put(src, s);
        }
        s.set(i, dst);
    }

    @Override
    public void addNode(T n) {
        this.delegate.addNode(n);
    }

    @Override
    public boolean containsNode(@Nullable T N) {
        return this.delegate.containsNode(N);
    }

    @Override
    public int getNumberOfNodes() {
        return this.delegate.getNumberOfNodes();
    }

    @Override
    public int getPredNodeCount(T N) throws IllegalArgumentException {
        return this.delegate.getPredNodeCount(N);
    }

    @Override
    public Iterator<T> getPredNodes(@Nullable T N) throws IllegalArgumentException {
        return this.delegate.getPredNodes(N);
    }

    @Override
    public int getSuccNodeCount(T N) throws IllegalArgumentException {
        return this.delegate.getSuccNodeCount(N);
    }

    @Override
    public Iterator<T> getSuccNodes(@Nullable T N) throws IllegalArgumentException {
        return this.delegate.getSuccNodes(N);
    }

    @Override
    public boolean hasEdge(@Nullable T src, @Nullable T dst) {
        return this.delegate.hasEdge(src, dst);
    }

    @Override
    public Iterator<T> iterator() {
        return this.delegate.iterator();
    }

    @Override
    public Stream<T> stream() {
        return this.delegate.stream();
    }

    @Override
    public void removeAllIncidentEdges(T node) throws UnimplementedError {
        Assertions.UNREACHABLE();
        this.delegate.removeAllIncidentEdges(node);
    }

    @Override
    public void removeEdge(T src, T dst) throws UnimplementedError {
        Assertions.UNREACHABLE();
        this.delegate.removeEdge(src, dst);
    }

    @Override
    public void removeIncomingEdges(T node) throws UnimplementedError {
        Assertions.UNREACHABLE();
        this.delegate.removeIncomingEdges(node);
    }

    @Override
    public void removeNode(T n) throws UnimplementedError {
        Assertions.UNREACHABLE();
        this.delegate.removeNode(n);
    }

    @Override
    public void removeNodeAndEdges(T N) throws UnimplementedError {
        Assertions.UNREACHABLE();
        this.delegate.removeNodeAndEdges(N);
    }

    @Override
    public void removeOutgoingEdges(T node) throws UnimplementedError {
        Assertions.UNREACHABLE();
        this.delegate.removeOutgoingEdges(node);
    }

    @Override
    public T getSuccessor(T node, int i) throws IllegalArgumentException {
        SimpleVector<T> s = this.successorEdges.get(node);
        if (s == null) {
            throw new IllegalArgumentException("no successors for node " + node);
        }
        if (i > s.getMaxIndex()) {
            throw new IllegalArgumentException("no successor number " + i + " for " + node);
        }
        return s.get(i);
    }
}

