/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.util.graph;

import com.ibm.wala.util.collections.FilterIterator;
import com.ibm.wala.util.collections.HashSetFactory;
import com.ibm.wala.util.collections.Iterator2Collection;
import com.ibm.wala.util.collections.IteratorUtil;
import com.ibm.wala.util.debug.Assertions;
import com.ibm.wala.util.graph.AbstractGraph;
import com.ibm.wala.util.graph.EdgeManager;
import com.ibm.wala.util.graph.Graph;
import com.ibm.wala.util.graph.NodeManager;
import com.ibm.wala.util.graph.impl.GraphInverter;
import com.ibm.wala.util.graph.traverse.DFS;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.jspecify.annotations.NullUnmarked;
import org.jspecify.annotations.Nullable;

public class GraphSlicer {
    public static <T> Set<T> slice(Graph<T> g, Predicate<T> p) {
        if (g == null) {
            throw new IllegalArgumentException("g is null");
        }
        HashSet roots = HashSetFactory.make();
        for (Object o : g) {
            if (!p.test(o)) continue;
            roots.add(o);
        }
        Set<T> result = DFS.getReachableNodes(GraphInverter.invert(g), roots);
        return result;
    }

    public static <T> Graph<T> prune(final Graph<T> g, final Predicate<T> p) {
        if (g == null) {
            throw new IllegalArgumentException("g is null");
        }
        final NodeManager n = new NodeManager<T>(){
            int nodeCount = -1;

            @Override
            public Iterator<T> iterator() {
                return new FilterIterator(g.iterator(), p);
            }

            @Override
            public Stream<T> stream() {
                return g.stream().filter(p);
            }

            @Override
            public int getNumberOfNodes() {
                if (this.nodeCount == -1) {
                    this.nodeCount = IteratorUtil.count(this.iterator());
                }
                return this.nodeCount;
            }

            @Override
            public void addNode(T n) {
                Assertions.UNREACHABLE();
            }

            @Override
            public void removeNode(T n) {
                Assertions.UNREACHABLE();
            }

            @Override
            public boolean containsNode(@Nullable T n) {
                return p.test(n) && g.containsNode(n);
            }
        };
        final EdgeManager e = new EdgeManager<T>(){

            @Override
            public Iterator<T> getPredNodes(@Nullable T n) {
                return new FilterIterator(g.getPredNodes(n), p);
            }

            @Override
            public int getPredNodeCount(T n) {
                return IteratorUtil.count(this.getPredNodes(n));
            }

            @Override
            public Iterator<T> getSuccNodes(@Nullable T n) {
                return new FilterIterator(g.getSuccNodes(n), p);
            }

            @Override
            public int getSuccNodeCount(T N) {
                return IteratorUtil.count(this.getSuccNodes(N));
            }

            @Override
            public void addEdge(T src, T dst) {
                Assertions.UNREACHABLE();
            }

            @Override
            public void removeEdge(T src, T dst) {
                Assertions.UNREACHABLE();
            }

            @Override
            public void removeAllIncidentEdges(T node) {
                Assertions.UNREACHABLE();
            }

            @Override
            public void removeIncomingEdges(T node) {
                Assertions.UNREACHABLE();
            }

            @Override
            public void removeOutgoingEdges(T node) {
                Assertions.UNREACHABLE();
            }

            @Override
            public boolean hasEdge(@Nullable T src, @Nullable T dst) {
                return g.hasEdge(src, dst) && p.test(src) && p.test(dst);
            }
        };
        AbstractGraph output = new AbstractGraph<T>(){

            @Override
            protected String nodeString(T n2, boolean forEdge) {
                if (g instanceof AbstractGraph) {
                    return ((AbstractGraph)g).nodeString(n2, forEdge);
                }
                return super.nodeString(n2, forEdge);
            }

            @Override
            protected NodeManager<T> getNodeManager() {
                return n;
            }

            @Override
            protected EdgeManager<T> getEdgeManager() {
                return e;
            }
        };
        return output;
    }

    public static <E> AbstractGraph<E> project(final Graph<E> G, final Predicate<E> fmember) {
        final NodeManager nodeManager = new NodeManager<E>(){
            private int count = -1;

            @Override
            public void addNode(E n) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean containsNode(@Nullable E N) {
                return G.containsNode(N) && fmember.test(N);
            }

            @Override
            public int getNumberOfNodes() {
                if (this.count == -1) {
                    this.count = IteratorUtil.count(this.iterator());
                }
                return this.count;
            }

            @Override
            public Iterator<E> iterator() {
                return new FilterIterator(G.iterator(), fmember);
            }

            @Override
            public Stream<E> stream() {
                return G.stream().filter(fmember);
            }

            @Override
            public void removeNode(E n) {
                throw new UnsupportedOperationException();
            }
        };
        final EdgeManager edgeManager = new EdgeManager<E>(){
            private final Map<E, Collection<E>> succs = new HashMap();
            private final Map<E, Collection<E>> preds = new HashMap();

            private Set<E> getConnected(@Nullable E inst, Function<E, Iterator<? extends E>> fconnected) {
                LinkedHashSet result = new LinkedHashSet();
                HashSet seenInsts = new HashSet();
                Set newInsts = Iterator2Collection.toSet(fconnected.apply(inst));
                while (!newInsts.isEmpty()) {
                    HashSet nextInsts = new HashSet();
                    for (Object s : newInsts) {
                        if (!seenInsts.add(s)) continue;
                        if (nodeManager.containsNode(s)) {
                            result.add(s);
                            continue;
                        }
                        Iterator ss = fconnected.apply(s);
                        while (ss.hasNext()) {
                            Object n = ss.next();
                            if (seenInsts.contains(n)) continue;
                            nextInsts.add(n);
                        }
                    }
                    newInsts = nextInsts;
                }
                return result;
            }

            private void setPredNodes(@Nullable E N) {
                this.preds.put(N, this.getConnected(N, G::getPredNodes));
            }

            private void setSuccNodes(@Nullable E N) {
                this.succs.put(N, this.getConnected(N, G::getSuccNodes));
            }

            @Override
            @NullUnmarked
            public int getPredNodeCount(E N) {
                if (!this.preds.containsKey(N)) {
                    this.setPredNodes(N);
                }
                return this.preds.get(N).size();
            }

            @Override
            @NullUnmarked
            public Iterator<E> getPredNodes(@Nullable E N) {
                if (!this.preds.containsKey(N)) {
                    this.setPredNodes(N);
                }
                return this.preds.get(N).iterator();
            }

            @Override
            @NullUnmarked
            public int getSuccNodeCount(E N) {
                if (!this.succs.containsKey(N)) {
                    this.setSuccNodes(N);
                }
                return this.succs.get(N).size();
            }

            @Override
            @NullUnmarked
            public Iterator<E> getSuccNodes(@Nullable E N) {
                if (!this.succs.containsKey(N)) {
                    this.setSuccNodes(N);
                }
                return this.succs.get(N).iterator();
            }

            @Override
            @NullUnmarked
            public boolean hasEdge(@Nullable E src, @Nullable E dst) {
                if (!this.preds.containsKey(dst)) {
                    this.setPredNodes(dst);
                }
                return this.preds.get(dst).contains(src);
            }

            @Override
            public void addEdge(E src, E dst) {
                throw new UnsupportedOperationException();
            }

            @Override
            public void removeAllIncidentEdges(E node) throws UnsupportedOperationException {
                throw new UnsupportedOperationException();
            }

            @Override
            public void removeEdge(E src, E dst) throws UnsupportedOperationException {
                throw new UnsupportedOperationException();
            }

            @Override
            public void removeIncomingEdges(E node) throws UnsupportedOperationException {
                throw new UnsupportedOperationException();
            }

            @Override
            public void removeOutgoingEdges(E node) throws UnsupportedOperationException {
                throw new UnsupportedOperationException();
            }
        };
        return new AbstractGraph<E>(){

            @Override
            protected String nodeString(E n, boolean forEdge) {
                if (G instanceof AbstractGraph) {
                    return ((AbstractGraph)G).nodeString(n, forEdge);
                }
                return super.nodeString(n, forEdge);
            }

            @Override
            protected EdgeManager<E> getEdgeManager() {
                return edgeManager;
            }

            @Override
            protected NodeManager<E> getNodeManager() {
                return nodeManager;
            }
        };
    }
}

