/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.util.graph;

import com.ibm.wala.util.graph.AbstractGraph;
import com.ibm.wala.util.graph.NumberedEdgeManager;
import com.ibm.wala.util.graph.NumberedGraph;
import com.ibm.wala.util.graph.NumberedNodeManager;
import com.ibm.wala.util.graph.impl.NumberedNodeIterator;
import com.ibm.wala.util.intset.IntSet;
import java.util.Iterator;
import org.jspecify.annotations.Nullable;

public abstract class AbstractNumberedGraph<T>
extends AbstractGraph<T>
implements NumberedGraph<T> {
    @Override
    protected abstract NumberedNodeManager<T> getNodeManager();

    @Override
    protected abstract NumberedEdgeManager<T> getEdgeManager();

    @Override
    public int getMaxNumber() {
        return this.getNodeManager().getMaxNumber();
    }

    @Override
    public T getNode(int number) {
        return this.getNodeManager().getNode(number);
    }

    @Override
    public int getNumber(@Nullable T N) {
        if (N == null) {
            throw new IllegalArgumentException("N cannot be null");
        }
        return this.getNodeManager().getNumber(N);
    }

    @Override
    public Iterator<T> iterateNodes(IntSet s) {
        return new NumberedNodeIterator(s, this);
    }

    @Override
    public IntSet getPredNodeNumbers(@Nullable T node) throws IllegalArgumentException {
        assert (this.getEdgeManager() != null);
        return this.getEdgeManager().getPredNodeNumbers(node);
    }

    @Override
    public IntSet getSuccNodeNumbers(@Nullable T node) throws IllegalArgumentException {
        return this.getEdgeManager().getSuccNodeNumbers(node);
    }
}

