/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.util.collections;

import com.ibm.wala.util.collections.ArrayIterator;
import com.ibm.wala.util.collections.EmptyIterator;
import java.util.Arrays;
import java.util.EmptyStackException;
import java.util.Iterator;

public class ImmutableStack<T>
implements Iterable<T> {
    private static final ImmutableStack<Object> EMPTY = new ImmutableStack<Object>(new Object[0]);
    private static final int MAX_SIZE = Integer.MAX_VALUE;
    private final T[] entries;
    private final int cachedHashCode;

    public static int getMaxSize() {
        return Integer.MAX_VALUE;
    }

    public static final <T> ImmutableStack<T> emptyStack() {
        return EMPTY;
    }

    protected ImmutableStack(T[] entries) {
        this.entries = entries;
        this.cachedHashCode = Arrays.hashCode(entries);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o != null && o instanceof ImmutableStack) {
            ImmutableStack other = (ImmutableStack)o;
            return Arrays.equals(this.entries, other.entries);
        }
        return false;
    }

    public int hashCode() {
        return this.cachedHashCode;
    }

    public ImmutableStack<T> push(T entry) {
        if (entry == null) {
            throw new IllegalArgumentException("null entry");
        }
        int size = this.entries.length + 1;
        T[] tmpEntries = null;
        if (size <= Integer.MAX_VALUE) {
            tmpEntries = this.makeInternalArray(size);
            System.arraycopy(this.entries, 0, tmpEntries, 0, this.entries.length);
            tmpEntries[size - 1] = entry;
        } else {
            tmpEntries = this.makeInternalArray(Integer.MAX_VALUE);
            System.arraycopy(this.entries, 1, tmpEntries, 0, this.entries.length - 1);
            tmpEntries[0x7FFFFFFE] = entry;
        }
        return this.makeStack(tmpEntries);
    }

    protected T[] makeInternalArray(int size) {
        return new Object[size];
    }

    protected ImmutableStack<T> makeStack(T[] tmpEntries) {
        return new ImmutableStack<T>(tmpEntries);
    }

    public T peek() {
        if (this.entries.length == 0) {
            throw new EmptyStackException();
        }
        return this.entries[this.entries.length - 1];
    }

    public ImmutableStack<T> pop() {
        if (this.entries.length == 0) {
            throw new EmptyStackException();
        }
        int size = this.entries.length - 1;
        T[] tmpEntries = this.makeInternalArray(size);
        System.arraycopy(this.entries, 0, tmpEntries, 0, size);
        return this.makeStack(tmpEntries);
    }

    public boolean isEmpty() {
        return this.entries.length == 0;
    }

    public int size() {
        return this.entries.length;
    }

    public T get(int i) {
        try {
            return this.entries[i];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new IllegalArgumentException("invalid i: " + i, e);
        }
    }

    public String toString() {
        String objArrayToString = Arrays.toString(this.entries);
        assert (this.entries.length <= Integer.MAX_VALUE) : objArrayToString;
        return objArrayToString;
    }

    public boolean contains(T entry) {
        if (entry == null) {
            return false;
        }
        for (T entrie : this.entries) {
            if (entrie == null || !entrie.equals(entry)) continue;
            return true;
        }
        return false;
    }

    public boolean topMatches(ImmutableStack<T> other) throws IllegalArgumentException {
        if (other == null) {
            throw new IllegalArgumentException("other == null");
        }
        if (other.size() > this.size()) {
            return false;
        }
        int i = other.size() - 1;
        int j = this.size() - 1;
        while (i >= 0) {
            if (!other.get(i).equals(this.get(j))) {
                return false;
            }
            --i;
            --j;
        }
        return true;
    }

    public ImmutableStack<T> reverse() {
        Object[] tmpEntries = new Object[this.entries.length];
        int i = this.entries.length - 1;
        int j = 0;
        while (i >= 0) {
            tmpEntries[j] = this.entries[i];
            --i;
            ++j;
        }
        return new ImmutableStack<Object>(tmpEntries);
    }

    public ImmutableStack<T> popAll(ImmutableStack<T> other) {
        if (!this.topMatches(other)) {
            throw new IllegalArgumentException("top does not match");
        }
        int size = this.entries.length - other.entries.length;
        Object[] tmpEntries = new Object[size];
        System.arraycopy(this.entries, 0, tmpEntries, 0, size);
        return new ImmutableStack<Object>(tmpEntries);
    }

    public ImmutableStack<T> pushAll(ImmutableStack<T> other) {
        if (other == null) {
            throw new IllegalArgumentException("null other");
        }
        int size = this.entries.length + other.entries.length;
        Object[] tmpEntries = null;
        if (size <= Integer.MAX_VALUE) {
            tmpEntries = new Object[size];
            System.arraycopy(this.entries, 0, tmpEntries, 0, this.entries.length);
            System.arraycopy(other.entries, 0, tmpEntries, this.entries.length, other.entries.length);
        } else {
            tmpEntries = new Object[Integer.MAX_VALUE];
            int numFromThis = Integer.MAX_VALUE - other.entries.length;
            System.arraycopy(this.entries, this.entries.length - numFromThis, tmpEntries, 0, numFromThis);
            System.arraycopy(other.entries, 0, tmpEntries, numFromThis, other.entries.length);
        }
        return new ImmutableStack<Object>(tmpEntries);
    }

    @Override
    public Iterator<T> iterator() {
        if (this.entries.length == 0) {
            return EmptyIterator.instance();
        }
        return new ArrayIterator<T>(this.entries);
    }

    public ImmutableStack<T> replaceTop(T t) {
        if (this.isEmpty()) {
            throw new EmptyStackException();
        }
        int size = this.entries.length;
        T[] tmpEntries = this.makeInternalArray(size);
        System.arraycopy(this.entries, 0, tmpEntries, 0, this.entries.length - 1);
        tmpEntries[size - 1] = t;
        return this.makeStack(tmpEntries);
    }
}

