/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.util;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class PlatformUtil {
    public static boolean onMacOSX() {
        String osname = System.getProperty("os.name");
        return osname.toLowerCase().contains("mac");
    }

    public static boolean onLinux() {
        String osname = System.getProperty("os.name");
        return osname.equalsIgnoreCase("linux");
    }

    public static boolean onWindows() {
        String osname = System.getProperty("os.name");
        return osname.toLowerCase().contains("windows");
    }

    public static boolean onIKVM() {
        return "IKVM.NET".equals(System.getProperty("java.runtime.name"));
    }

    public static String[] getJDKModules(boolean justBase) {
        List<Object> jmods;
        if (justBase) {
            Path basePath = Paths.get(System.getProperty("java.home"), "jmods", "java.base.jmod");
            if (!Files.exists(basePath, new LinkOption[0])) {
                throw new IllegalStateException("could not find java.base.jmod");
            }
            jmods = List.of(basePath.toString());
        } else {
            try (Stream<Path> stream = Files.list(Paths.get(System.getProperty("java.home"), "jmods"));){
                jmods = stream.map(Path::toString).filter(p -> p.endsWith(".jmod")).collect(Collectors.toList());
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }
        return jmods.toArray(new String[0]);
    }

    public static Path getPathForJDKModule(String moduleName) {
        return Paths.get(System.getProperty("java.home"), "jmods", moduleName + ".jmod");
    }

    public static int getJavaRuntimeVersion() {
        String version = System.getProperty("java.version");
        if (version.startsWith("1.")) {
            version = version.substring(2, 3);
        } else {
            int dot = version.indexOf(".");
            if (dot != -1) {
                version = version.substring(0, dot);
            }
        }
        return Integer.parseInt(version);
    }
}

