/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.dataflow.graph;

import com.ibm.wala.dataflow.graph.AbstractMeetOperator;
import com.ibm.wala.dataflow.graph.IKilldallFramework;
import com.ibm.wala.dataflow.graph.ITransferFunctionProvider;
import com.ibm.wala.fixedpoint.impl.DefaultFixedPointSolver;
import com.ibm.wala.fixpoint.IVariable;
import com.ibm.wala.fixpoint.UnaryOperator;
import com.ibm.wala.util.collections.HashMapFactory;
import com.ibm.wala.util.collections.Iterator2Iterable;
import com.ibm.wala.util.collections.ObjectArrayMapping;
import com.ibm.wala.util.collections.Pair;
import com.ibm.wala.util.graph.Graph;
import com.ibm.wala.util.intset.IntegerUnionFind;
import java.util.Iterator;
import java.util.Map;
import org.jspecify.annotations.NullUnmarked;
import org.jspecify.annotations.Nullable;

public abstract class DataflowSolver<T, V extends IVariable<V>>
extends DefaultFixedPointSolver<V> {
    private final IKilldallFramework<T, V> problem;
    private final Map<Object, V> node2In = HashMapFactory.make();
    private final Map<Object, V> node2Out = HashMapFactory.make();
    private final Map<Object, V> edge2Var = HashMapFactory.make();

    public DataflowSolver(IKilldallFramework<T, V> problem) {
        super(2);
        this.problem = problem;
    }

    protected abstract V makeNodeVariable(T var1, boolean var2);

    protected abstract V makeEdgeVariable(T var1, T var2);

    @Override
    protected void initializeVariables() {
        Graph G = this.problem.getFlowGraph();
        ITransferFunctionProvider<T, V> functions = this.problem.getTransferFunctionProvider();
        for (Object N : G) {
            assert (N != null);
            V v = this.makeNodeVariable(N, true);
            this.node2In.put(N, v);
            if (functions.hasNodeTransferFunctions()) {
                v = this.makeNodeVariable(N, false);
                this.node2Out.put(N, v);
            }
            if (!functions.hasEdgeTransferFunctions()) continue;
            for (Object S : Iterator2Iterable.make(G.getSuccNodes(N))) {
                v = this.makeEdgeVariable(N, S);
                this.edge2Var.put(Pair.make(N, S), v);
            }
        }
    }

    @Override
    protected void initializeWorkList() {
        this.buildEquations(true, false);
    }

    @NullUnmarked
    public V getOut(Object node) {
        assert (node != null);
        IVariable v = (IVariable)this.node2Out.get(node);
        assert (v != null) : "no out set for " + node;
        return (V)v;
    }

    @NullUnmarked
    public V getIn(Object node) {
        return (V)((IVariable)this.node2In.get(node));
    }

    public @Nullable V getEdge(Object key) {
        return (V)((IVariable)this.edge2Var.get(key));
    }

    public @Nullable V getEdge(Object src, Object dst) {
        assert (src != null);
        assert (dst != null);
        V v = this.getEdge(Pair.make(src, dst));
        assert (v != null);
        return v;
    }

    protected void buildEquations(boolean toWorkList, boolean eager) {
        ITransferFunctionProvider functions = this.problem.getTransferFunctionProvider();
        Graph G = this.problem.getFlowGraph();
        AbstractMeetOperator<V> meet = functions.getMeetOperator();
        UnionFind uf = new UnionFind();
        if (meet.isUnaryNoOp()) {
            this.shortCircuitUnaryMeets(G, functions, uf);
        }
        this.shortCircuitIdentities(G, functions, uf);
        this.fixShortCircuits(uf);
        int meetThreshold = meet.isUnaryNoOp() ? 2 : 1;
        for (Object node : G) {
            int nPred = G.getPredNodeCount(node);
            if (nPred < meetThreshold) continue;
            IVariable[] rhs = this.makeStmtRHS(nPred);
            int i = 0;
            for (Object o : Iterator2Iterable.make(G.getPredNodes(node))) {
                rhs[i++] = functions.hasEdgeTransferFunctions() ? this.getEdge(o, node) : this.getOut(o);
            }
            this.newStatement((IVariable)this.getIn(node), meet, rhs, toWorkList, eager);
        }
        if (functions.hasNodeTransferFunctions()) {
            for (Object node : G) {
                UnaryOperator<V> f = functions.getNodeTransferFunction(node);
                if (f.isIdentity()) continue;
                this.newStatement(this.getOut(node), f, this.getIn(node), toWorkList, eager);
            }
        }
        if (functions.hasEdgeTransferFunctions()) {
            for (Object node : G) {
                for (Object succ : Iterator2Iterable.make(G.getSuccNodes(node))) {
                    UnaryOperator<V> f = functions.getEdgeTransferFunction(node, succ);
                    if (f.isIdentity()) continue;
                    this.newStatement(this.getEdge(node, succ), f, functions.hasNodeTransferFunctions() ? this.getOut(node) : this.getIn(node), toWorkList, eager);
                }
            }
        }
    }

    private void shortCircuitIdentities(Graph<T> G, ITransferFunctionProvider<T, V> functions, UnionFind uf) {
        if (functions.hasNodeTransferFunctions()) {
            for (Object node : G) {
                UnaryOperator<V> f = functions.getNodeTransferFunction(node);
                if (!f.isIdentity()) continue;
                uf.union(this.getIn(node), this.getOut(node));
            }
        }
        if (functions.hasEdgeTransferFunctions()) {
            for (Object node : G) {
                for (Object succ : Iterator2Iterable.make(G.getSuccNodes(node))) {
                    UnaryOperator<V> f = functions.getEdgeTransferFunction(node, succ);
                    if (!f.isIdentity()) continue;
                    uf.union(this.getEdge(node, succ), functions.hasNodeTransferFunctions() ? this.getOut(node) : this.getIn(node));
                }
            }
        }
    }

    private void fixShortCircuits(UnionFind uf) {
        if (uf.didSomething) {
            for (int i = 0; i < uf.size(); ++i) {
                int rep = uf.find(i);
                if (i == rep) continue;
                Object x = uf.getKey(i);
                Object y = uf.getKey(rep);
                if (uf.isIn(i)) {
                    if (uf.isIn(rep)) {
                        this.node2In.put(x, this.getIn(y));
                        continue;
                    }
                    if (uf.isOut(rep)) {
                        this.node2In.put(x, this.getOut(y));
                        continue;
                    }
                    this.node2In.put(x, this.getEdge(y));
                    continue;
                }
                if (uf.isOut(i)) {
                    if (uf.isIn(rep)) {
                        this.node2Out.put(x, this.getIn(y));
                        continue;
                    }
                    if (uf.isOut(rep)) {
                        this.node2Out.put(x, this.getOut(y));
                        continue;
                    }
                    this.node2Out.put(x, this.getEdge(y));
                    continue;
                }
                if (uf.isIn(rep)) {
                    this.edge2Var.put(x, this.getIn(y));
                    continue;
                }
                if (uf.isOut(rep)) {
                    this.edge2Var.put(x, this.getOut(y));
                    continue;
                }
                this.edge2Var.put(x, this.getEdge(y));
            }
        }
    }

    private void shortCircuitUnaryMeets(Graph<T> G, ITransferFunctionProvider<T, V> functions, UnionFind uf) {
        for (Object node : G) {
            assert (node != null);
            int nPred = G.getPredNodeCount(node);
            if (nPred != 1) continue;
            Object p = G.getPredNodes(node).next();
            assert (p != null);
            uf.union(this.getIn(node), functions.hasEdgeTransferFunctions() ? this.getEdge(p, node) : this.getOut(p));
        }
    }

    public IKilldallFramework<T, V> getProblem() {
        return this.problem;
    }

    private class UnionFind {
        final IntegerUnionFind uf;
        final ObjectArrayMapping<Object> map;
        boolean didSomething = false;
        private final Object[] allKeys;

        private int mapIt(int i, Object[] allVars, Map<Object, V> varMap) {
            Iterator<Object> iterator = varMap.keySet().iterator();
            while (iterator.hasNext()) {
                Object key;
                this.allKeys[i] = key = iterator.next();
                allVars[i++] = varMap.get(key);
            }
            return i;
        }

        UnionFind() {
            this.allKeys = new Object[DataflowSolver.this.node2In.size() + DataflowSolver.this.node2Out.size() + DataflowSolver.this.edge2Var.size()];
            Object[] allVars = new Object[DataflowSolver.this.node2In.size() + DataflowSolver.this.node2Out.size() + DataflowSolver.this.edge2Var.size()];
            int i = this.mapIt(0, allVars, DataflowSolver.this.node2In);
            i = this.mapIt(i, allVars, DataflowSolver.this.node2Out);
            this.mapIt(i, allVars, DataflowSolver.this.edge2Var);
            this.uf = new IntegerUnionFind(allVars.length);
            this.map = new ObjectArrayMapping<Object>(allVars);
        }

        public void union(@Nullable Object n1, @Nullable Object n2) {
            assert (n1 != null);
            assert (n2 != null);
            int x = this.map.getMappedIndex(n1);
            int y = this.map.getMappedIndex(n2);
            this.uf.union(x, y);
            this.didSomething = true;
        }

        public int size() {
            return this.map.getSize();
        }

        public int find(int i) {
            return this.uf.find(i);
        }

        public boolean isIn(int i) {
            return i < DataflowSolver.this.node2In.size();
        }

        public boolean isOut(int i) {
            return !this.isIn(i) && i < DataflowSolver.this.node2In.size() + DataflowSolver.this.node2Out.size();
        }

        public Object getKey(int i) {
            return this.allKeys[i];
        }
    }
}

