/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.commons.util.profiler;

import com.ibm.commons.Platform;
import com.ibm.commons.util.StringUtil;
import com.ibm.commons.util.TDiag;
import com.ibm.commons.util.profiler.ProfilerType;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;

public final class ProfilerAggregator {
    private static int idCounter = 0;
    private int id;
    private ProfilerAggregator parent;
    private List<ProfilerAggregator> children;
    private ProfilerType type;
    private String param;
    private int detailLevel;
    private int count;
    private long minTime = 0L;
    private long maxTime = 0L;
    private long totalTime;
    private long childrenTime;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProfilerAggregator(ProfilerAggregator parent, ProfilerType type, String param, int detailLevel) {
        Class<?> clazz = this.getClass();
        synchronized (clazz) {
            this.id = idCounter++;
        }
        this.parent = parent;
        this.children = new ArrayList<ProfilerAggregator>();
        this.type = type;
        this.param = param;
        this.detailLevel = detailLevel;
    }

    public int getDetailLevel() {
        return this.detailLevel;
    }

    ProfilerAggregator get(ProfilerType type, String param) {
        int childCount = this.children.size();
        int i = 0;
        while (i < childCount) {
            ProfilerAggregator pa = this.children.get(i);
            if (pa.type == type && StringUtil.equals(param, pa.getParam())) {
                return pa;
            }
            ++i;
        }
        return null;
    }

    void add(ProfilerAggregator child) {
        this.children.add(child);
    }

    ProfilerAggregator getParent() {
        return this.parent;
    }

    void reinit() {
        this.children.clear();
    }

    synchronized void addInfo(long time) {
        if (this.count > 0) {
            if (time < this.minTime) {
                this.minTime = time;
            }
            if (time > this.maxTime) {
                this.maxTime = time;
            }
        } else {
            this.minTime = time;
            this.maxTime = time;
        }
        ++this.count;
        this.totalTime += time;
        this.parent.childrenTime += time;
    }

    public void merge(ProfilerAggregator aggregator) {
        if (aggregator != null && aggregator.count > 0) {
            if (this.count > 0) {
                if (aggregator.minTime < this.minTime) {
                    this.minTime = aggregator.minTime;
                }
                if (aggregator.maxTime > this.maxTime) {
                    this.maxTime = aggregator.maxTime;
                }
            } else {
                this.minTime = aggregator.minTime;
                this.maxTime = aggregator.maxTime;
            }
            this.count += aggregator.count;
            this.totalTime += aggregator.totalTime;
            this.childrenTime += aggregator.childrenTime;
        }
    }

    public boolean isRootAggregator() {
        return this.parent == null;
    }

    public int getId() {
        return this.id;
    }

    public ProfilerType getType() {
        return this.type;
    }

    public String getParam() {
        return this.param;
    }

    public int getChildCount() {
        return this.children.size();
    }

    public ProfilerAggregator getChild(int index) {
        return this.children.get(index);
    }

    public int getCount() {
        return this.count;
    }

    public long getMinTime() {
        return this.minTime;
    }

    public long getMaxTime() {
        return this.maxTime;
    }

    public long getTotalTime() {
        return this.totalTime;
    }

    public long getChildrenTime() {
        return this.childrenTime;
    }

    public long getAvgTime() {
        return this.count > 0 ? this.totalTime / (long)this.count : 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dump() {
        PrintStream printStream = TDiag.getSyncObject();
        synchronized (printStream) {
            ProfilerAggregator.dump(this, 0);
        }
    }

    private static void dump(ProfilerAggregator a, int level) {
        int i = 0;
        while (i < level) {
            Platform.getInstance().getOutputStream().print("    ");
            ++i;
        }
        if (a.getParam() != null) {
            String str = a.getParam();
            if (str.length() > 128) {
                str = String.valueOf(str.substring(0, 128)) + "...";
            }
            Platform.getInstance().getOutputStream().print(a.getType() + "[" + str + "], ");
        } else {
            Platform.getInstance().getOutputStream().print(a.getType() + ", ");
        }
        if (a.getCount() > 0) {
            Platform.getInstance().getOutputStream().println("Count=" + a.getCount() + ", total=" + a.getTotalTime() + ", average=" + a.getAvgTime() + ", minimum=" + a.getMinTime() + ", maximum=" + a.getMaxTime());
        } else {
            Platform.getInstance().getOutputStream().println("Count=" + a.getCount());
        }
        i = 0;
        while (i < a.getChildCount()) {
            ProfilerAggregator.dump(a.getChild(i), level + 1);
            ++i;
        }
    }
}

