/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.commons.util.profiler;

import com.ibm.commons.util.TDiag;
import com.ibm.commons.util.ThreadMap;
import com.ibm.commons.util.profiler.HighResolutionTimer;
import com.ibm.commons.util.profiler.ProfilerAggregator;
import com.ibm.commons.util.profiler.ProfilerType;

public class Profiler {
    private static ProfilerAggregator mainAggregator = new ProfilerAggregator(null, new ProfilerType("Root"), null, 0);
    private static ThreadMap threadMap = null;
    private static boolean enabled = false;
    private static HighResolutionTimer _timer = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void enableProfiler(HighResolutionTimer timer) {
        Class<Profiler> clazz = Profiler.class;
        synchronized (Profiler.class) {
            if (enabled) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
            _timer = timer;
            switch (_timer.getTimerMode()) {
                case 1: {
                    TDiag.console("Profiler is measuring CPU time", new Object[0]);
                    break;
                }
                case 0: {
                    TDiag.console("Profiler is measuring wall time", new Object[0]);
                }
            }
            enabled = true;
            threadMap = new ThreadMap();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void disableProfiler() {
        Class<Profiler> clazz = Profiler.class;
        synchronized (Profiler.class) {
            if (enabled) {
                TDiag.console("Profiler is disabled", new Object[0]);
                enabled = false;
                threadMap = null;
                _timer = null;
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    public static boolean startProfiler() {
        Thread t;
        if (enabled && threadMap.get(t = Thread.currentThread()) == null) {
            threadMap.put(t, mainAggregator);
            return true;
        }
        return false;
    }

    public static void endProfiler(boolean started) {
        if (started && threadMap.hasItems()) {
            threadMap.remove(Thread.currentThread());
        }
    }

    public static void endProfiler() {
        Profiler.endProfiler(true);
    }

    public static boolean isStarted() {
        return enabled && threadMap.get(Thread.currentThread()) != null;
    }

    public static boolean isEnabled() {
        return enabled;
    }

    public static HighResolutionTimer getCurrentTimer() {
        return _timer;
    }

    public static ProfilerAggregator startProfileBlock(ProfilerType type, String param) {
        return Profiler.startProfileBlock(type, param, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ProfilerAggregator startProfileBlock(ProfilerType type, String param, int detailLevel) {
        ProfilerAggregator parent = (ProfilerAggregator)threadMap.get(Thread.currentThread());
        if (parent != null) {
            ProfilerAggregator child = parent.get(type, param);
            if (child == null) {
                ProfilerAggregator profilerAggregator = parent;
                synchronized (profilerAggregator) {
                    child = parent.get(type, param);
                    if (child == null) {
                        child = new ProfilerAggregator(parent, type, param, detailLevel);
                        parent.add(child);
                    }
                }
            }
            threadMap.put(Thread.currentThread(), child);
            return child;
        }
        return null;
    }

    public static ProfilerAggregator startProfileBlock(String type, String param) {
        ProfilerType t = ProfilerType.get(type);
        return Profiler.startProfileBlock(t, param, 0);
    }

    public static void endProfileBlock(ProfilerAggregator aggregator, long startTime) {
        if (aggregator != null && enabled) {
            aggregator.addInfo(Profiler.getCurrentTime() - startTime);
            if (enabled) {
                threadMap.put(Thread.currentThread(), aggregator.getParent());
            }
        }
    }

    public static void resetProfiler() {
        mainAggregator.reinit();
    }

    public static ProfilerAggregator getMainAggregator() {
        return mainAggregator;
    }

    public static void dump() {
        mainAggregator.dump();
    }

    public static void profileRunnable(ProfilerType type, String id, Runnable runnable) {
        if (Profiler.isEnabled()) {
            ProfilerAggregator agg = Profiler.startProfileBlock(type, id);
            long ts = Profiler.getCurrentTime();
            try {
                runnable.run();
            }
            finally {
                Profiler.endProfileBlock(agg, ts);
            }
        } else {
            runnable.run();
        }
    }

    public static long getCurrentTime() {
        return _timer.getTime();
    }
}

