/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.commons.util.profiler;

import com.ibm.commons.util.StringUtil;
import com.ibm.commons.util.TextUtil;
import com.ibm.commons.util.profiler.JVMPIInterface;
import java.io.PrintStream;
import java.lang.instrument.Instrumentation;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class MemoryInspector {
    private static final String ENTRY_TAG = "Object";
    private Instrumentation instrumentation;
    private Map<Object, Integer> visited = new IdentityHashMap<Object, Integer>();
    private IdentityHashMap<Class<?>, Field[]> fieldsCache = new IdentityHashMap();

    public MemoryInspector() {
        this(new IdentityHashMap<Object, Integer>(), new IdentityHashMap());
    }

    public MemoryInspector(Map<Object, Integer> visited, IdentityHashMap<Class<?>, Field[]> classCache) {
        this.instrumentation = JVMPIInterface.getInstrumentation();
        this.fieldsCache = classCache;
    }

    public Instrumentation getInstrumentation() {
        return this.instrumentation;
    }

    public Map<Object, Integer> getVisited() {
        return this.visited;
    }

    public long inspect(Object object, Callback cb) throws IllegalAccessException {
        StackImpl<Object> params = new StackImpl<Object>();
        long size = 0L;
        cb.begin();
        params.push(object);
        try {
            long l = size = this.inspect(params, null, null, object, cb);
            return l;
        }
        finally {
            cb.end(size);
            params.pop();
        }
    }

    /*
     * Unable to fully structure code
     */
    protected long inspect(Stack<Object> params, Object parent, Field parentField, Object object, Callback cb) throws IllegalAccessException {
        if (object == null) {
            return 0L;
        }
        if (this.visited.containsKey(object)) {
            this.visited.put(object, this.visited.get(object) + 1);
            return 0L;
        }
        if (this.isIntern(object) && this.skipInterns(object)) {
            return 0L;
        }
        objectSize = 0L;
        childrenSize = 0L;
        if (this.isStoreAsVisited(object)) {
            this.visited.put(object, 1);
        }
        if (this.instrumentation != null) {
            objectSize = this.instrumentation.getObjectSize(object);
        }
        current = cb.startObject(params, parent, parentField, object);
        params.push(object);
        try {
            block16: {
                clazz = object.getClass();
                if (!clazz.isArray()) ** GOTO lbl42
                arrayClazz = clazz.getComponentType();
                if (arrayClazz.isPrimitive()) break block16;
                length = Array.getLength(object);
                i = 0;
                while (i < length) {
                    value = Array.get(object, i);
                    if (value != null && this.isFieldValid(params, clazz, null, object, value)) {
                        childrenSize += this.inspect(params, current, null, value, cb);
                    }
                    ++i;
                }
                break block16;
lbl-1000:
                // 1 sources

                {
                    fields = this.getFields(clazz);
                    i = 0;
                    while (i < fields.length) {
                        field = fields[i];
                        value = field.get(object);
                        if (value != null && this.isFieldValid(params, clazz, field, object, value)) {
                            childrenSize += this.inspect(params, current, field, value, cb);
                        }
                        ++i;
                    }
                    clazz = clazz.getSuperclass();
lbl42:
                    // 2 sources

                    ** while (clazz != null)
                }
            }
            var17_18 = objectSize + childrenSize;
            return var17_18;
        }
        finally {
            cb.endObject(params, object, objectSize, childrenSize);
            params.pop();
        }
    }

    private Field[] getFields(Class<?> clazz) {
        Field[] f = this.fieldsCache.get(clazz);
        if (f != null) {
            return f;
        }
        ArrayList<Field> ff = new ArrayList<Field>();
        Field[] fields = clazz.getDeclaredFields();
        int i = 0;
        while (i < fields.length) {
            Field field = fields[i];
            if (!Modifier.isStatic(field.getModifiers()) && !field.getType().isPrimitive()) {
                if (!field.isAccessible()) {
                    field.setAccessible(true);
                }
                ff.add(field);
            }
            ++i;
        }
        f = ff.toArray(new Field[ff.size()]);
        this.fieldsCache.put(clazz, f);
        return f;
    }

    protected boolean isStoreAsVisited(Object obj) {
        return true;
    }

    protected boolean isIntern(Object obj) {
        if (obj instanceof Comparable) {
            if (obj instanceof Enum) {
                return true;
            }
            if (obj == "" || obj == StringUtil.EMPTY_STRING_ARRAY) {
                return true;
            }
            if (obj instanceof String) {
                return obj == ((String)obj).intern();
            }
            if (obj instanceof Boolean) {
                return obj == Boolean.TRUE || obj == Boolean.FALSE;
            }
            if (obj instanceof Integer) {
                return obj == Integer.valueOf((Integer)obj);
            }
            if (obj instanceof Short) {
                return obj == Short.valueOf((Short)obj);
            }
            if (obj instanceof Byte) {
                return obj == Byte.valueOf((Byte)obj);
            }
            if (obj instanceof Long) {
                return obj == Long.valueOf((Long)obj);
            }
            if (obj instanceof Character) {
                return obj == Character.valueOf(((Character)obj).charValue());
            }
        }
        return obj == Collections.EMPTY_LIST || obj == Collections.EMPTY_MAP || obj == Collections.EMPTY_SET;
    }

    protected boolean skipInterns(Object object) {
        return true;
    }

    protected boolean isFieldValid(Stack<Object> params, Class<?> fieldClass, Field field, Object obj, Object value) {
        return true;
    }

    public static interface Callback {
        public void begin();

        public void end(long var1);

        public Object startObject(Stack<Object> var1, Object var2, Field var3, Object var4);

        public void endObject(Stack<Object> var1, Object var2, long var3, long var5);
    }

    public static class CollectEntryCallBack
    implements Callback {
        private Entry rootEntry;
        private Stack<Entry> stack = new StackImpl<Entry>();

        public Entry getRootEntry() {
            return this.rootEntry;
        }

        public Stack<Entry> getEntryStack() {
            return this.stack;
        }

        @Override
        public void begin() {
            this.rootEntry = this.createRootEntry();
            this.stack.push(this.rootEntry);
        }

        protected Entry createRootEntry() {
            return new Entry(null, null, "<root>");
        }

        @Override
        public void end(long size) {
            this.rootEntry.childrenSize = size;
        }

        @Override
        public Object startObject(Stack<Object> params, Object parent, Field parentField, Object object) {
            Entry e = this.createEntry(params, parent, parentField, object);
            if (this.isPersistent(params, parentField, object)) {
                this.stack.get().add(e);
                this.stack.push(e);
            }
            return e;
        }

        @Override
        public void endObject(Stack<Object> params, Object object, long objectSize, long childrenSize) {
            Entry e = this.stack.get();
            if (e.object == object) {
                e.objectSize = objectSize;
                e.childrenSize = childrenSize;
                this.stack.pop();
            }
        }

        public Entry createEntry(Stack<Object> params, Object parent, Field parentField, Object object) {
            Entry e = new Entry((Entry)parent, parentField, object);
            return e;
        }

        public boolean isPersistent(Stack<Object> params, Field parentField, Object object) {
            return true;
        }

        public static class Entry {
            Entry parent;
            Entry next;
            Entry firstChild;
            Field parentField;
            Object object;
            long objectSize;
            long childrenSize;

            public Entry(Entry parent, Field parentField, Object object) {
                this.parent = parent;
                this.parentField = parentField;
                this.object = object;
            }

            public Entry getParent() {
                return this.parent;
            }

            public boolean isRoot() {
                return this.parent == null;
            }

            public Field getParentField() {
                return this.parentField;
            }

            public Object getObject() {
                return this.object;
            }

            public long getObjectSize() {
                return this.objectSize;
            }

            public long getChildrenSize() {
                return this.childrenSize;
            }

            public Entry getNext() {
                return this.next;
            }

            public Entry getFirstChild() {
                return this.firstChild;
            }

            void add(Entry child) {
                child.next = this.firstChild;
                this.firstChild = child;
            }
        }
    }

    public static class CollectEntryDump {
        private CollectEntryCallBack callBack;
        private int initialLevel;
        private Format format;

        public CollectEntryDump(CollectEntryCallBack callBack, Format format) {
            this.callBack = callBack;
            this.format = format;
        }

        public int getInitialLevel() {
            return this.initialLevel;
        }

        public void setInitialLevel(int initialLevel) {
            this.initialLevel = initialLevel;
        }

        public CollectEntryCallBack getCallBack() {
            return this.callBack;
        }

        public void dump(PrintStream ps) {
            this.dump(ps, this.callBack.getRootEntry(), this.initialLevel);
        }

        protected void dump(PrintStream ps, CollectEntryCallBack.Entry entry, int level) {
            boolean p = this.shouldDump(ps, entry, level);
            if (p) {
                this.printEntryStart(ps, entry, level);
                ++level;
            }
            CollectEntryCallBack.Entry c = entry.getFirstChild();
            while (c != null) {
                this.dump(ps, c, level);
                c = c.getNext();
            }
            if (p) {
                this.printEntryEnd(ps, entry, --level);
            }
        }

        protected boolean shouldDump(PrintStream ps, CollectEntryCallBack.Entry entry, int level) {
            return true;
        }

        protected void printEntryStart(PrintStream ps, CollectEntryCallBack.Entry entry, int level) {
            this.printIndent(ps, level);
            StringBuilder b = new StringBuilder();
            Object o = entry.getObject();
            if (this.format == Format.FORMAT_TEXT) {
                String fn = this.getFieldName(entry);
                if (fn != null) {
                    b.append(fn);
                    b.append(':');
                }
                b.append(o.getClass().getSimpleName());
                if (o.getClass().isArray()) {
                    b.append('[');
                    b.append(Integer.toString(Array.getLength(o)));
                    b.append(']');
                }
                b.append(", Size=");
                b.append(Long.toString(entry.getObjectSize()));
                b.append(", Total Size=");
                b.append(Long.toString(entry.getObjectSize() + entry.getChildrenSize()));
                this.appendObjectString(b, o);
                ps.println(b.toString());
            } else if (this.format == Format.FORMAT_XML) {
                ps.print("<");
                ps.print(MemoryInspector.ENTRY_TAG);
                if (!entry.isRoot()) {
                    this.printXmlAttr(ps, "fieldName", this.getFieldName(entry));
                    String className = o.getClass().getSimpleName();
                    if (o.getClass().isArray()) {
                        className = String.valueOf(className) + '[' + Integer.toString(Array.getLength(o)) + ']';
                    }
                    this.printXmlAttr(ps, "class", className);
                    this.printXmlAttr(ps, "size", Long.toString(entry.getObjectSize()));
                }
                this.printXmlAttr(ps, "totalSize", Long.toString(entry.getObjectSize() + entry.getChildrenSize()));
                this.appendObjectString(b, o);
                if (b.length() > 0) {
                    this.printXmlAttr(ps, "value", b.toString());
                    b.setLength(0);
                }
                if (entry.getFirstChild() == null) {
                    ps.println("/>");
                } else {
                    ps.println(">");
                }
            }
        }

        protected void printXmlAttr(PrintStream ps, String attrName, String attrValue) {
            if (StringUtil.isNotEmpty(attrValue)) {
                ps.print(" ");
                ps.print(attrName);
                ps.print("='");
                ps.print(TextUtil.toXMLString(attrValue));
                ps.print("'");
            }
        }

        protected void printEntryEnd(PrintStream ps, CollectEntryCallBack.Entry entry, int level) {
            if (this.format == Format.FORMAT_XML && entry.getFirstChild() != null) {
                this.printIndent(ps, level);
                ps.print("</");
                ps.print(MemoryInspector.ENTRY_TAG);
                ps.println(">");
            }
        }

        protected String getFieldName(CollectEntryCallBack.Entry entry) {
            if (entry.getParentField() != null) {
                return entry.getParentField().getName();
            }
            return null;
        }

        protected void appendObjectString(StringBuilder b, Object o) {
            if (o instanceof String) {
                String s = this.format(o.toString());
                if (b.length() > 0) {
                    b.append(", ");
                }
                b.append(s);
                return;
            }
            if (o instanceof Number) {
                String s = o.toString();
                if (b.length() > 0) {
                    b.append(", ");
                }
                b.append(s);
                b.append("");
                return;
            }
            if (o instanceof Map) {
                if (b.length() > 0) {
                    b.append(", ");
                }
                b.append("count=");
                b.append(((Map)o).size());
                return;
            }
            if (o instanceof Map.Entry) {
                if (b.length() > 0) {
                    b.append(", ");
                }
                b.append("key=");
                b.append(this.format(((Map.Entry)o).getKey().toString()));
                return;
            }
            if (o instanceof List) {
                if (b.length() > 0) {
                    b.append(", ");
                }
                b.append("count=");
                b.append(((List)o).size());
                return;
            }
            if (o instanceof Set) {
                if (b.length() > 0) {
                    b.append(", ");
                }
                b.append("count=");
                b.append(((Set)o).size());
                return;
            }
            if (o.getClass().isPrimitive()) {
                if (b.length() > 0) {
                    b.append(", ");
                }
                b.append(o.toString());
                return;
            }
        }

        protected void printIndent(PrintStream ps, int level) {
            int i = 0;
            while (i < level) {
                ps.print("  ");
                ++i;
            }
        }

        protected String format(String s) {
            if ((s = TextUtil.toJavaString(s, false)).length() > 96) {
                s = String.valueOf(s.substring(0, 96)) + "...";
            }
            return s;
        }

        public static enum Format {
            FORMAT_TEXT,
            FORMAT_XML;

        }
    }

    public static interface Stack<T> {
        public boolean isEmpty();

        public int size();

        public T pop();

        public void push(T var1);

        public T get();

        public T get(int var1);
    }

    private static final class StackImpl<T>
    implements Stack<T> {
        private int count;
        private Object[] data = new Object[128];

        StackImpl() {
        }

        @Override
        public boolean isEmpty() {
            return this.count == 0;
        }

        @Override
        public int size() {
            return this.count;
        }

        @Override
        public T pop() {
            return (T)this.data[--this.count];
        }

        @Override
        public void push(T o) {
            if (this.count == this.data.length) {
                Object[] nd = new Object[this.count + 32];
                System.arraycopy(this.data, 0, nd, 0, this.count);
                this.data = nd;
            }
            this.data[this.count++] = o;
        }

        @Override
        public T get() {
            return (T)this.data[this.count - 1];
        }

        @Override
        public T get(int idx) {
            return (T)this.data[this.count - idx - 1];
        }
    }
}

