/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.commons.util.print;

import com.ibm.commons.util.EmptyIterator;
import com.ibm.commons.util.FastStringBuffer;
import com.ibm.commons.util.StringUtil;
import com.ibm.commons.util.TDiag;
import java.io.PrintStream;
import java.util.Iterator;

public class TablePrinter {
    private PrintStream ps;
    private ITable table;

    public TablePrinter() {
    }

    public TablePrinter(ITable table) {
        this.table = table;
    }

    public void println(String s) {
        this.getOutputStream().println(s);
    }

    public PrintStream getPrintStream() {
        return this.ps;
    }

    public void setPrintStream(PrintStream ps) {
        this.ps = ps;
    }

    public PrintStream getOutputStream() {
        return this.ps != null ? this.ps : System.out;
    }

    public int getMaxColSize() {
        return 128;
    }

    public ITable getTable() {
        return this.table;
    }

    public void setTable(ITable table) {
        this.table = table;
    }

    public int print() {
        return this.print(0, Integer.MAX_VALUE);
    }

    public int print(int start, int c) {
        boolean printIfEmpty = true;
        try {
            EmptyIterator it;
            Iterator iterator = it = this.table != null ? this.table.getRows(start, c) : EmptyIterator.getInstance();
            if (it.hasNext() || printIfEmpty) {
                this.prtSeparator();
                this.prtHeader();
                this.prtSeparator();
            }
            int rowCount = 0;
            while (rowCount < c && it.hasNext()) {
                IRow row = (IRow)it.next();
                this.prtRow(row);
                ++rowCount;
            }
            if (rowCount > 0 || printIfEmpty) {
                this.prtSeparator();
            }
            return rowCount;
        }
        catch (Exception e) {
            TDiag.exception(e);
            return 0;
        }
    }

    private void prtSeparator() throws Exception {
        FastStringBuffer b = new FastStringBuffer();
        int colCount = this.table.getColumnCount();
        int i = 0;
        while (i < colCount) {
            int sz = Math.min(this.table.getColumnSize(i), this.getMaxColSize());
            b.append('+');
            b.repeat('-', sz);
            ++i;
        }
        b.append('+');
        this.println(b.toString());
    }

    private void prtHeader() throws Exception {
        FastStringBuffer b = new FastStringBuffer();
        int colCount = this.table.getColumnCount();
        int i = 0;
        while (i < colCount) {
            int sz = Math.min(this.table.getColumnSize(i), this.getMaxColSize());
            b.append('|');
            b.append(TablePrinter.pad(this.table.getColumnTitle(i), sz));
            ++i;
        }
        b.append('|');
        this.println(b.toString());
    }

    private void prtRow(IRow row) throws Exception {
        FastStringBuffer b = new FastStringBuffer();
        int colCount = this.table.getColumnCount();
        int i = 0;
        while (i < colCount) {
            int sz = Math.min(this.table.getColumnSize(i), this.getMaxColSize());
            b.append('|');
            b.append(TablePrinter.pad(this.colString(row, i), sz));
            ++i;
        }
        b.append('|');
        this.println(b.toString());
    }

    private String colString(IRow row, int col) throws Exception {
        return row.getRowValue(col);
    }

    private static String pad(String s, int sz) {
        if (s != null) {
            int strLen = s.length();
            if (strLen == sz) {
                return s;
            }
            if (strLen > sz) {
                return s.substring(0, sz);
            }
            return String.valueOf(s) + StringUtil.repeat(' ', sz - strLen);
        }
        return StringUtil.repeat(' ', sz);
    }

    public static interface IRow {
        public String getRowValue(int var1) throws Exception;
    }

    public static interface ITable {
        public int getColumnCount() throws Exception;

        public String getColumnTitle(int var1) throws Exception;

        public int getColumnSize(int var1) throws Exception;

        public Iterator getRows(int var1, int var2) throws Exception;
    }
}

