/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.commons.util.print;

import com.ibm.commons.util.print.TablePrinter;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Iterator;

public class ResultSetPrinter
extends TablePrinter {
    public ResultSetPrinter(ResultSet rs) {
        this.setTable(new ViewTable(rs));
    }

    private class ViewRow
    implements TablePrinter.IRow {
        ResultSet rs;

        public ViewRow(ResultSet rs) {
            this.rs = rs;
        }

        @Override
        public String getRowValue(int col) {
            try {
                return this.rs.getString(col + 1);
            }
            catch (SQLException ex) {
                ex.printStackTrace();
                return "<????>";
            }
        }
    }

    private class ViewRowIterator
    implements Iterator {
        ResultSet rs;
        Boolean next;

        ViewRowIterator(ResultSet rs) {
            this.rs = rs;
        }

        @Override
        public boolean hasNext() {
            if (this.next == null) {
                try {
                    this.next = this.rs.next();
                }
                catch (SQLException ex) {
                    ex.printStackTrace();
                    this.next = Boolean.FALSE;
                }
            }
            return this.next;
        }

        public Object next() {
            if (this.next != null && this.next.booleanValue()) {
                this.next = null;
                return new ViewRow(this.rs);
            }
            return null;
        }

        @Override
        public void remove() {
        }
    }

    private class ViewTable
    implements TablePrinter.ITable {
        ResultSet rs;
        ResultSetMetaData meta;

        ViewTable(ResultSet rs) {
            this.rs = rs;
            try {
                this.meta = rs.getMetaData();
            }
            catch (SQLException ex) {
                ex.printStackTrace();
            }
        }

        @Override
        public int getColumnCount() throws Exception {
            return this.meta != null ? this.meta.getColumnCount() : 0;
        }

        @Override
        public String getColumnTitle(int col) throws Exception {
            return this.meta.getColumnLabel(col + 1);
        }

        @Override
        public int getColumnSize(int col) throws Exception {
            int sz = this.meta.getColumnDisplaySize(col + 1);
            int type = this.meta.getColumnType(col + 1);
            switch (type) {
                case -1: 
                case 1: 
                case 12: {
                    sz = Math.min(Math.max(sz, 20), 64);
                    break;
                }
                case 1111: {
                    sz = 32;
                }
            }
            if (sz <= 10) {
                sz = 10;
            }
            return sz;
        }

        @Override
        public Iterator getRows(int start, int count) throws Exception {
            if (start > 0) {
                this.rs.relative(start);
            }
            return new ViewRowIterator(this.rs);
        }
    }
}

