/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.commons.util.print;

import com.ibm.commons.Platform;
import com.ibm.commons.util.QuickSort;
import com.ibm.commons.util.StringUtil;
import com.ibm.commons.util.io.TextOutputStream;
import com.ibm.commons.util.print.TablePrinter;
import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.StringWriter;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class DumpObject
extends TablePrinter {
    public static DefaultAdapterFactory defaultFactory = new DefaultAdapterFactory();
    public static DefaultFilter defaultFilter = new DefaultFilter();
    private AdapterFactory adapterFactory = defaultFactory;
    private TextOutputStream ps = new TextOutputStream(Platform.getInstance().getOutputStream());
    private int depth = 10;
    private int indent = 2;
    private boolean printType;
    private IFilter filter = defaultFilter;

    public DumpObject() {
    }

    public DumpObject(AdapterFactory adapterFactory) {
        this.adapterFactory = adapterFactory;
    }

    public AdapterFactory getAdapterFactory() {
        return this.adapterFactory;
    }

    public void setAdapterFactory(AdapterFactory adapterFactory) {
        this.adapterFactory = adapterFactory;
    }

    public int getDepth() {
        return this.depth;
    }

    public void setDepth(int depth) {
        this.depth = depth;
    }

    public TextOutputStream getTextOutputStream() {
        return this.ps;
    }

    public void setTextOutputStream(TextOutputStream ps) {
        this.ps = ps;
    }

    public IFilter getFilter() {
        return this.filter;
    }

    public void setFilter(IFilter propertyFilter) {
        this.filter = propertyFilter;
    }

    public boolean isPrintType() {
        return this.printType;
    }

    public void setPrintType(boolean printType) {
        this.printType = printType;
    }

    public int getIndent() {
        return this.indent;
    }

    public void setIndent(int indent) {
        this.indent = indent;
    }

    public void dump(Object o) throws IOException {
        if (o != null) {
            this.dump(new HashMap(), new ArrayList(), null, o, this.depth);
        } else {
            this.ps.println("<null>");
        }
        this.ps.flush();
    }

    private void dump(HashMap map, ArrayList hierarchy, String propertyName, Object v, int depth) throws IOException {
        Adapter adapter = this.adapterFactory.createAdapter(v);
        if (depth <= 0) {
            return;
        }
        int i = 0;
        while (i < hierarchy.size()) {
            switch (this.indent) {
                case 0: {
                    break;
                }
                case 1: {
                    this.ps.print(" ");
                    break;
                }
                case 2: {
                    this.ps.print("  ");
                    break;
                }
                case 3: {
                    this.ps.print("   ");
                    break;
                }
                case 4: {
                    this.ps.print("    ");
                    break;
                }
                default: {
                    int id = 0;
                    while (id < this.indent) {
                        this.ps.print(' ');
                        ++id;
                    }
                    break block1;
                }
            }
            ++i;
        }
        hierarchy.add(v);
        try {
            if (hierarchy.size() > 1) {
                this.ps.print("+- ");
            }
            if (StringUtil.isNotEmpty(propertyName)) {
                this.ps.print(propertyName);
                this.ps.print(": ");
            }
            if (adapter.isValue()) {
                String vs = this.valueAndType(adapter.getValue(), adapter.getTypeAsString());
                if (!StringUtil.isEmpty(vs)) {
                    this.ps.print(vs);
                }
                String type = adapter.getTypeAsString();
                if (this.printType && StringUtil.isNotEmpty(type)) {
                    this.ps.print(" (");
                    this.ps.print(type);
                    this.ps.print(")");
                }
                this.ps.print("\n");
            }
            if (adapter.isObject()) {
                if (!this.inHierarchy(hierarchy, v)) {
                    this.ps.print(StringUtil.format("{0}\n", this.valueAndType(adapter.getValue(), adapter.getTypeAsString())));
                    Map pMap = adapter.getPropertyMap(this.filter);
                    ArrayList<String> names = new ArrayList<String>();
                    for (String name : pMap.keySet()) {
                        names.add(name);
                    }
                    new QuickSort.JavaList(names).sort();
                    int count = names.size();
                    int i2 = 0;
                    while (i2 < count) {
                        String pName = (String)names.get(i2);
                        Object pValue = pMap.get(pName);
                        this.dump(map, hierarchy, pName, pValue, depth - 1);
                        ++i2;
                    }
                } else {
                    this.ps.print(" Object already in hierarchy\n");
                }
            }
            if (adapter.isArray()) {
                if (!this.inHierarchy(hierarchy, v)) {
                    this.ps.print(" Array [" + adapter.arrayCount() + "]\n");
                    i = 0;
                    Iterator it = adapter.arrayIterator();
                    while (it.hasNext()) {
                        Object value = it.next();
                        this.dump(map, hierarchy, "[" + i + "]", value, depth - 1);
                        ++i;
                    }
                } else {
                    this.ps.print(" Array already in hierarchy\n");
                }
            }
        }
        finally {
            hierarchy.remove(hierarchy.size() - 1);
        }
    }

    private boolean inHierarchy(ArrayList hierarchy, Object instance) {
        int count = hierarchy.size() - 1;
        int i = 0;
        while (i < count) {
            if (hierarchy.get(i) == instance) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private String valueAndType(String value, String typeAsString) {
        StringBuilder b = new StringBuilder();
        if (StringUtil.isNotEmpty(value)) {
            b.append(value);
        } else {
            b.append("<empty>");
        }
        if (StringUtil.isNotEmpty(typeAsString) && !typeAsString.equals("java.lang.String")) {
            b.append(" (");
            b.append(typeAsString);
            b.append(")");
        }
        return b.toString();
    }

    public void dump(DataInputStream ios) {
        this.dump(ios, Integer.MAX_VALUE);
    }

    public void dump(DataInputStream ios, int length) {
        try {
            String a = "";
            int i = 0;
            int j = 0;
            while (i < length) {
                String s;
                int val = ios.read();
                if (val < 0) {
                    this.ps.flush();
                    return;
                }
                if (j == 0) {
                    this.ps.println("  " + a);
                    a = "";
                    s = Integer.toHexString(i);
                    s = String.valueOf(s) + "      ".substring(s.length());
                    this.ps.print(String.valueOf(s) + "  ");
                }
                if (j == 8) {
                    this.ps.print("  ");
                }
                if ((s = Integer.toHexString(val)).length() < 2) {
                    s = "0" + s;
                }
                this.ps.print(String.valueOf(s) + " ");
                a = val > 32 && val < 128 ? String.valueOf(a) + (char)val : String.valueOf(a) + ' ';
                if (++j == 16) {
                    j = 0;
                }
                ++i;
            }
            this.ps.println("");
            this.ps.flush();
            return;
        }
        catch (IOException e) {
            Platform.getInstance().log(e);
            return;
        }
    }

    public static abstract class Adapter {
        public String getTypeAsString() {
            return "";
        }

        public boolean isValue() {
            return false;
        }

        public String getValue() {
            return null;
        }

        public boolean isArray() {
            return false;
        }

        public Iterator arrayIterator() {
            return null;
        }

        public int arrayCount() {
            return 0;
        }

        public boolean isObject() {
            return false;
        }

        public Map getPropertyMap(IFilter filter) {
            return null;
        }
    }

    public static interface AdapterFactory {
        public Adapter createAdapter(Object var1);
    }

    public static class AdapterWrapper
    extends Adapter {
        private Adapter wrapped;

        public AdapterWrapper(Adapter wrapped) {
            this.wrapped = wrapped;
        }

        @Override
        public String getTypeAsString() {
            return this.wrapped.getTypeAsString();
        }

        @Override
        public boolean isValue() {
            return this.wrapped.isValue();
        }

        @Override
        public String getValue() {
            return this.wrapped.getValue();
        }

        @Override
        public boolean isArray() {
            return this.wrapped.isArray();
        }

        @Override
        public Iterator arrayIterator() {
            return this.wrapped.arrayIterator();
        }

        @Override
        public int arrayCount() {
            return this.wrapped.arrayCount();
        }

        @Override
        public boolean isObject() {
            return this.wrapped.isObject();
        }

        @Override
        public Map getPropertyMap(IFilter filter) {
            return this.wrapped.getPropertyMap(filter);
        }
    }

    public static class ArrayAdapter
    extends Adapter {
        Object instance;

        public ArrayAdapter(Object instance) {
            this.instance = instance;
        }

        @Override
        public boolean isArray() {
            return true;
        }

        @Override
        public Iterator arrayIterator() {
            return new Iterator(){
                int current = 0;
                int length;
                {
                    this.length = Array.getLength(ArrayAdapter.this.instance);
                }

                @Override
                public boolean hasNext() {
                    return this.current < this.length;
                }

                public Object next() {
                    if (this.current < this.length) {
                        return Array.get(ArrayAdapter.this.instance, this.current++);
                    }
                    return null;
                }

                @Override
                public void remove() {
                }
            };
        }

        @Override
        public int arrayCount() {
            return Array.getLength(this.instance);
        }
    }

    public static class CollectionAdapter
    extends Adapter {
        Object instance;

        public CollectionAdapter(Object instance) {
            this.instance = instance;
        }

        @Override
        public boolean isArray() {
            return true;
        }

        @Override
        public Iterator arrayIterator() {
            return ((Collection)this.instance).iterator();
        }

        @Override
        public int arrayCount() {
            return ((Collection)this.instance).size();
        }
    }

    public static class DefaultAdapterFactory
    implements AdapterFactory {
        private boolean beans;

        public DefaultAdapterFactory() {
            this.beans = true;
        }

        public DefaultAdapterFactory(boolean beans) {
            this.beans = beans;
        }

        @Override
        public Adapter createAdapter(Object o) {
            if (o == null) {
                return new NullAdapter();
            }
            Class<?> c = o.getClass();
            if (o instanceof String) {
                return new PrimitiveAdapter(o);
            }
            if (o instanceof Number) {
                return new PrimitiveAdapter(o);
            }
            if (o instanceof Boolean) {
                return new PrimitiveAdapter(o);
            }
            if (o instanceof Character) {
                return new PrimitiveAdapter(o);
            }
            if (o instanceof Date) {
                return new PrimitiveAdapter(o);
            }
            if (o instanceof Calendar) {
                return new PrimitiveAdapter(new Date(((Calendar)o).getTimeInMillis()));
            }
            if (c.isArray()) {
                return new ArrayAdapter(o);
            }
            if (o instanceof Collection) {
                return new CollectionAdapter(o);
            }
            if (o instanceof Map) {
                return new MapAdapter(o);
            }
            if (o instanceof Document) {
                Node node = (Node)o;
                return new XmlAdapter(node);
            }
            if (this.beans) {
                try {
                    BeanInfo bi = Introspector.getBeanInfo(c);
                    PropertyDescriptor[] desc = bi.getPropertyDescriptors();
                    return new JavaBeanAdapter(desc, o);
                }
                catch (Exception exception) {}
            }
            return new JavaObjectAdapter(o);
        }
    }

    public static class DefaultFilter
    implements IFilter {
        @Override
        public boolean acceptField(Field field) {
            return true;
        }

        @Override
        public boolean acceptProperty(String name, Object property) {
            if (property instanceof PropertyDescriptor) {
                return !name.equals("class");
            }
            return true;
        }
    }

    public static class FactoryWrapper
    implements AdapterFactory {
        private AdapterFactory wrapped;

        public FactoryWrapper(AdapterFactory wrapped) {
            this.wrapped = wrapped;
        }

        @Override
        public Adapter createAdapter(Object o) {
            return this.wrapped.createAdapter(o);
        }
    }

    public static interface IFilter {
        public boolean acceptField(Field var1);

        public boolean acceptProperty(String var1, Object var2);
    }

    public static class JavaBeanAdapter
    extends Adapter {
        PropertyDescriptor[] desc;
        Object instance;

        public JavaBeanAdapter(PropertyDescriptor[] desc, Object instance) {
            this.desc = desc;
            this.instance = instance;
        }

        @Override
        public boolean isObject() {
            return true;
        }

        @Override
        public Map getPropertyMap(IFilter filter) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            int i = 0;
            while (i < this.desc.length) {
                if (filter == null || filter.acceptProperty(this.desc[i].getName(), this.desc[i])) {
                    Object value;
                    String name = this.desc[i].getName();
                    try {
                        Method read = this.desc[i].getReadMethod();
                        value = read == null ? StringUtil.format("<error: No bean read method>", new Object[0]) : read.invoke(this.instance, null);
                    }
                    catch (Exception e) {
                        value = StringUtil.format("<error: {0}>", e.getMessage());
                    }
                    map.put(name, value);
                }
                ++i;
            }
            return map;
        }
    }

    public static class JavaObjectAdapter
    extends Adapter {
        Field[] fields;
        Object instance;

        public JavaObjectAdapter(Object instance) {
            this.fields = instance.getClass().getFields();
            this.instance = instance;
        }

        @Override
        public boolean isObject() {
            return true;
        }

        @Override
        public Map getPropertyMap(IFilter filter) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            int i = 0;
            while (i < this.fields.length) {
                if (filter == null || filter.acceptProperty(this.fields[i].getName(), this.fields[i])) {
                    Object value;
                    String name = this.fields[i].getName();
                    try {
                        value = this.fields[i].get(this.instance);
                    }
                    catch (Exception e) {
                        value = StringUtil.format("<error: {0}>", e.getMessage());
                    }
                    map.put(name, value);
                }
                ++i;
            }
            return map;
        }
    }

    public static class MapAdapter
    extends Adapter {
        Object instance;

        public MapAdapter(Object instance) {
            this.instance = instance;
        }

        @Override
        public boolean isArray() {
            return true;
        }

        @Override
        public Iterator arrayIterator() {
            return ((Map)this.instance).entrySet().iterator();
        }

        @Override
        public int arrayCount() {
            return ((Map)this.instance).size();
        }
    }

    public static class NullAdapter
    extends Adapter {
        @Override
        public boolean isValue() {
            return true;
        }

        @Override
        public String getValue() {
            return "<null>";
        }
    }

    public static class PrimitiveAdapter
    extends Adapter {
        Object value;

        public PrimitiveAdapter(Object value) {
            this.value = value;
        }

        @Override
        public String getTypeAsString() {
            String cName = this.value.getClass().getName();
            return cName;
        }

        @Override
        public boolean isValue() {
            return true;
        }

        @Override
        public String getValue() {
            return this.value.toString();
        }
    }

    public static class XmlAdapter
    extends Adapter {
        Node instance;

        public XmlAdapter(Node instance) {
            this.instance = instance;
        }

        @Override
        public String getTypeAsString() {
            return "XML Node";
        }

        @Override
        public boolean isValue() {
            return true;
        }

        @Override
        public String getValue() {
            try {
                return this.writeToString(this.instance);
            }
            catch (Exception e) {
                return StringUtil.format("<XML error: {0}>", e.getMessage());
            }
        }

        private String writeToString(Node node) {
            try {
                Transformer serializer = TransformerFactory.newInstance().newTransformer();
                StringWriter writer = new StringWriter();
                serializer.transform(new DOMSource(node), new StreamResult(writer));
                return writer.toString();
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }
    }
}

