/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.commons.util.print;

import com.ibm.commons.util.StringUtil;
import com.ibm.commons.util.print.TablePrinter;
import java.util.ArrayList;
import java.util.Iterator;

public class DataPrinter
extends TablePrinter {
    private Column[] columns;
    private ArrayList rows;

    public DataPrinter(Column[] columns) {
        this.columns = columns;
        this.rows = new ArrayList();
        this.setTable(new DataTable());
    }

    public DataPrinter(String[] columns) {
        this.columns = new Column[columns.length];
        int i = 0;
        while (i < columns.length) {
            this.columns[i] = new Column(columns[i]);
            ++i;
        }
        this.rows = new ArrayList();
        this.setTable(new DataTable());
    }

    public void addRow(Object[] row) {
        if (row != null) {
            int i = 0;
            while (i < row.length) {
                String s;
                if (row[i] != null && StringUtil.isNotEmpty(s = row[i].toString())) {
                    int sz = Math.min(s.length(), 200);
                    this.columns[i].size = Math.max(this.columns[i].size, sz);
                }
                ++i;
            }
        }
        this.rows.add(row);
    }

    public void addRow(Object v1) {
        Object[] v = new Object[]{v1};
        this.addRow(v);
    }

    public void addRow(Object v1, Object v2) {
        Object[] v = new Object[]{v1, v2};
        this.addRow(v);
    }

    public void addRow(Object v1, Object v2, Object v3) {
        Object[] v = new Object[]{v1, v2, v3};
        this.addRow(v);
    }

    public void addRow(Object v1, Object v2, Object v3, Object v4) {
        Object[] v = new Object[]{v1, v2, v3, v4};
        this.addRow(v);
    }

    public void addRow(Object v1, Object v2, Object v3, Object v4, Object v5) {
        Object[] v = new Object[]{v1, v2, v3, v4, v5};
        this.addRow(v);
    }

    public static class Column {
        String name;
        int size;

        public Column(String name, int size) {
            this.name = name;
            this.size = size;
        }

        public Column(String name) {
            this(name, 16);
        }
    }

    private class DataRow
    implements TablePrinter.IRow {
        Object instance;

        public DataRow(Object instance) {
            this.instance = instance;
        }

        @Override
        public String getRowValue(int col) {
            Object o;
            if (this.instance != null && (o = ((Object[])this.instance)[col]) != null) {
                return o.toString();
            }
            return "<null>";
        }
    }

    private class DataRowIterator
    implements Iterator {
        Iterator it;

        DataRowIterator(Iterator it) {
            this.it = it;
        }

        @Override
        public boolean hasNext() {
            return this.it.hasNext();
        }

        public Object next() {
            return new DataRow(this.it.next());
        }

        @Override
        public void remove() {
        }
    }

    private class DataTable
    implements TablePrinter.ITable {
        DataTable() {
        }

        @Override
        public int getColumnCount() throws Exception {
            return DataPrinter.this.columns.length;
        }

        @Override
        public String getColumnTitle(int col) throws Exception {
            return ((DataPrinter)DataPrinter.this).columns[col].name;
        }

        @Override
        public int getColumnSize(int col) throws Exception {
            return ((DataPrinter)DataPrinter.this).columns[col].size;
        }

        @Override
        public Iterator getRows(int start, int count) throws Exception {
            Iterator it = DataPrinter.this.rows.iterator();
            if (start > 0) {
                while (it.hasNext() && start > 0) {
                    it.next();
                }
            }
            return new DataRowIterator(it);
        }
    }
}

