/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.commons.util.io.json.util;

import com.ibm.commons.util.io.json.JsonException;
import com.ibm.commons.util.io.json.JsonFactory;
import com.ibm.commons.util.io.json.JsonGenerator;
import com.ibm.commons.util.io.json.JsonJavaFactory;
import java.io.IOException;
import java.io.Writer;

public class JsonWriter
extends JsonGenerator.WriterGenerator {
    private int objectLevels = 0;
    private boolean[] first = new boolean[32];

    public JsonWriter(Writer writer, boolean compact) {
        super(JsonJavaFactory.instanceEx, writer, compact);
    }

    public JsonWriter(JsonFactory factory, Writer writer, boolean compact) {
        super(factory, writer, compact);
    }

    public void startObject() throws IOException {
        this.nl();
        this.indent();
        this.out('{');
        if (this.objectLevels == this.first.length - 1) {
            boolean[] b = new boolean[this.first.length * 2];
            System.arraycopy(this.first, 0, b, 0, this.first.length);
            this.first = b;
        }
        this.first[++this.objectLevels] = true;
        this.incIndent();
    }

    public void endObject() throws IOException {
        this.nl();
        this.decIndent();
        this.indent();
        this.out('}');
        this.first[--this.objectLevels] = false;
    }

    public void startArray() throws IOException {
        this.nl();
        this.indent();
        this.out('[');
        if (this.objectLevels == this.first.length - 1) {
            boolean[] b = new boolean[this.first.length * 2];
            System.arraycopy(this.first, 0, b, 0, this.first.length);
            this.first = b;
        }
        this.first[++this.objectLevels] = true;
        this.incIndent();
    }

    public void endArray() throws IOException {
        this.nl();
        this.decIndent();
        this.indent();
        this.out(']');
        this.first[--this.objectLevels] = false;
    }

    public void startArrayItem() throws IOException {
        if (!this.first[this.objectLevels]) {
            this.out(',');
        }
        this.nl();
        this.indent();
    }

    public void endArrayItem() throws IOException {
        this.first[this.objectLevels] = false;
    }

    public void startProperty(String propertyName) throws IOException {
        if (!this.first[this.objectLevels]) {
            this.out(',');
        } else {
            this.first[this.objectLevels] = false;
        }
        this.nl();
        this.incIndent();
        this.indent();
        this.outPropertyName(propertyName);
        this.out(':');
    }

    public void endProperty() throws IOException {
        this.decIndent();
    }

    public void outStringProperty(String prop, String value) throws IOException {
        if (value != null) {
            this.startProperty(prop);
            this.outStringLiteral(value);
            this.endProperty();
        }
    }

    public void outBooleanProperty(String prop, boolean value) throws IOException {
        this.startProperty(prop);
        this.outBooleanLiteral(value);
        this.endProperty();
    }

    public void outNumberProperty(String prop, double value) throws IOException {
        this.startProperty(prop);
        this.outNumberLiteral(value);
        this.endProperty();
    }

    public void outIntProperty(String prop, int value) throws IOException {
        this.startProperty(prop);
        this.outIntLiteral(value);
        this.endProperty();
    }

    public void outLongProperty(String prop, long value) throws IOException {
        this.startProperty(prop);
        this.outLongLiteral(value);
        this.endProperty();
    }

    public void outObjectProperty(String prop, Object value) throws IOException, JsonException {
        if (value != null) {
            this.startProperty(prop);
            this.outObject(value);
            this.endProperty();
        }
    }

    public void outArrayProperty(String prop, Object value) throws IOException, JsonException {
        if (value != null) {
            this.startProperty(prop);
            this.outArrayLiteral(value);
            this.endProperty();
        }
    }

    public void outProperty(String prop, Object value) throws IOException, JsonException {
        this.startProperty(prop);
        this.outLiteral(value);
        this.endProperty();
    }
}

