/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.commons.util.io.json.util;

import com.ibm.commons.util.EmptyIterator;
import com.ibm.commons.util.io.TextOutputStream;
import com.ibm.commons.util.io.json.JsonException;
import com.ibm.commons.util.io.json.JsonFactory;
import com.ibm.commons.util.print.DumpObject;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public final class JsonDump {
    public static void dumpObject(JsonFactory factory, Object object) throws IOException {
        DumpObject d = new DumpObject(new JsonAdapterFactory(factory));
        d.dump(object);
    }

    public static void dumpObject(TextOutputStream w, JsonFactory factory, Object object) throws IOException {
        DumpObject d = new DumpObject(new JsonAdapterFactory(factory));
        d.setTextOutputStream(w);
        d.dump(object);
    }

    public static class ArrayAdapter
    extends DumpObject.Adapter {
        JsonFactory factory;
        Object instance;

        public ArrayAdapter(JsonFactory factory, Object instance) {
            this.factory = factory;
            this.instance = instance;
        }

        @Override
        public boolean isArray() {
            return true;
        }

        @Override
        public int arrayCount() {
            try {
                return this.factory.getArrayCount(this.instance);
            }
            catch (JsonException e) {
                e.printStackTrace();
                return 0;
            }
        }

        @Override
        public Iterator arrayIterator() {
            try {
                return this.factory.iterateArrayValues(this.instance);
            }
            catch (JsonException e) {
                e.printStackTrace();
                return EmptyIterator.getInstance();
            }
        }
    }

    public static class JsonAdapterFactory
    implements DumpObject.AdapterFactory {
        private JsonFactory factory;

        public JsonAdapterFactory(JsonFactory factory) {
            this.factory = factory;
        }

        @Override
        public DumpObject.Adapter createAdapter(Object o) {
            try {
                if (this.factory.isNull(o)) {
                    return new DumpObject.NullAdapter();
                }
                if (this.factory.isArray(o)) {
                    return new ArrayAdapter(this.factory, o);
                }
                if (this.factory.isObject(o)) {
                    return new ObjectAdapter(this.factory, o);
                }
                if (this.factory.isBoolean(o)) {
                    return new DumpObject.PrimitiveAdapter(this.factory.getBoolean(o));
                }
                if (this.factory.isNumber(o)) {
                    return new DumpObject.PrimitiveAdapter(this.factory.getNumber(o));
                }
                if (this.factory.isString(o)) {
                    return new DumpObject.PrimitiveAdapter(this.factory.getString(o));
                }
            }
            catch (JsonException ex) {
                ex.printStackTrace();
            }
            return DumpObject.defaultFactory.createAdapter(o);
        }
    }

    public static class ObjectAdapter
    extends DumpObject.Adapter {
        JsonFactory factory;
        Object instance;

        public ObjectAdapter(JsonFactory factory, Object instance) {
            this.factory = factory;
            this.instance = instance;
        }

        @Override
        public String getValue() {
            return "Object";
        }

        @Override
        public boolean isObject() {
            return true;
        }

        @Override
        public Map getPropertyMap(DumpObject.IFilter filter) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            try {
                Iterator<String> it = this.factory.iterateObjectProperties(this.instance);
                while (it.hasNext()) {
                    String prop = it.next();
                    if (filter != null && !filter.acceptProperty(prop, null)) continue;
                    Object value = this.factory.getProperty(this.instance, prop);
                    map.put(prop, value);
                }
            }
            catch (JsonException ex) {
                ex.printStackTrace();
            }
            return map;
        }
    }
}

