/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.commons.util.io.json.util;

import com.ibm.commons.util.io.json.JsonException;
import com.ibm.commons.util.io.json.JsonFactory;
import com.ibm.commons.util.io.json.JsonGenerator;
import com.ibm.commons.util.io.json.JsonJavaFactory;
import java.io.IOException;
import java.util.Date;

public class JsonBuilder
extends JsonGenerator.StringBuilderGenerator {
    private int objectLevels = 0;
    private boolean[] first = new boolean[32];

    public JsonBuilder(boolean compact) {
        super(JsonJavaFactory.instanceEx, new StringBuilder(), compact);
    }

    public JsonBuilder(StringBuilder b, boolean compact) {
        super(JsonJavaFactory.instanceEx, b, compact);
    }

    public JsonBuilder(JsonFactory factory, StringBuilder b, boolean compact) {
        super(factory, b, compact);
    }

    public void startObject() throws IOException {
        this.nl();
        this.indent();
        this.out('{');
        this.first[++this.objectLevels] = true;
        this.incIndent();
    }

    public void endObject() throws IOException {
        this.nl();
        this.decIndent();
        this.indent();
        this.out('}');
        this.first[--this.objectLevels] = false;
    }

    public void startArray() throws IOException {
        this.nl();
        this.indent();
        this.out('[');
        this.first[++this.objectLevels] = true;
        this.incIndent();
    }

    public void endArray() throws IOException {
        this.nl();
        this.decIndent();
        this.indent();
        this.out(']');
        this.first[--this.objectLevels] = false;
    }

    public void startArrayItem() throws IOException {
        if (!this.first[this.objectLevels]) {
            this.out(',');
        }
    }

    public void endArrayItem() throws IOException {
        this.first[this.objectLevels] = false;
    }

    public void startProperty(String propertyName) throws IOException {
        if (!this.first[this.objectLevels]) {
            this.out(',');
        } else {
            this.first[this.objectLevels] = false;
        }
        this.nl();
        this.incIndent();
        this.indent();
        this.outPropertyName(propertyName);
        this.out(':');
    }

    public void endProperty() throws IOException {
        this.decIndent();
    }

    public void set(String propertyName, Object value) throws IOException, JsonException {
        this.startProperty(propertyName);
        this.outLiteral(value);
    }

    public void setBoolean(String propertyName, boolean value) throws IOException, JsonException {
        this.startProperty(propertyName);
        this.outBooleanLiteral(value);
    }

    public void setNumber(String propertyName, double value) throws IOException, JsonException {
        this.startProperty(propertyName);
        this.outNumberLiteral(value);
    }

    public void setString(String propertyName, String value) throws IOException, JsonException {
        this.startProperty(propertyName);
        this.outStringLiteral(value);
    }

    public void setDate(String propertyName, Date value) throws IOException, JsonException {
        this.startProperty(propertyName);
        this.outDateLiteral_(value);
    }
}

