/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.commons.util.io.json.parser;

import com.ibm.commons.util.io.json.JsonException;
import com.ibm.commons.util.io.json.JsonFactory;
import com.ibm.commons.util.io.json.JsonParser;
import com.ibm.commons.util.io.json.parser.JsonConstants;
import com.ibm.commons.util.io.json.parser.JsonTokenManager;
import com.ibm.commons.util.io.json.parser.ParseException;
import com.ibm.commons.util.io.json.parser.SimpleCharStream;
import com.ibm.commons.util.io.json.parser.Token;
import java.io.InputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;

public class Json
implements JsonConstants {
    public JsonFactory factory;
    public JsonTokenManager token_source;
    SimpleCharStream jj_input_stream;
    public Token token;
    public Token jj_nt;
    private int jj_ntk;
    private int jj_gen;
    private final int[] jj_la1 = new int[11];
    private static int[] jj_la1_0;
    private static int[] jj_la1_1;
    private List<int[]> jj_expentries = new ArrayList<int[]>();
    private int[] jj_expentry;
    private int jj_kind = -1;

    static {
        Json.jj_la1_init_0();
        Json.jj_la1_init_1();
    }

    public String getStringValue(String image) throws ParseException {
        int l = image.length() - 1;
        StringBuilder sb = new StringBuilder(l);
        int i = 1;
        while (i < l) {
            char c = image.charAt(i);
            if (c == '\\' && ++i < l) {
                c = image.charAt(i);
                if (c == 'n') {
                    c = '\n';
                } else if (c == 'b') {
                    c = '\b';
                } else if (c == 'f') {
                    c = '\f';
                } else if (c == 'r') {
                    c = '\r';
                } else if (c == 't') {
                    c = '\t';
                } else if (c == 'v') {
                    c = '\u000b';
                } else if (c == 'x' && i + 2 < l && Json.isHexaDigit(image.charAt(i + 1)) && Json.isHexaDigit(image.charAt(i + 2))) {
                    c = (char)(Json.hexval(image.charAt(i + 1)) << 4 | Json.hexval(image.charAt(i + 2)));
                    i += 2;
                } else if (c == 'u' && i + 4 < l && Json.isHexaDigit(image.charAt(i + 1)) && Json.isHexaDigit(image.charAt(i + 2)) && Json.isHexaDigit(image.charAt(i + 3)) && Json.isHexaDigit(image.charAt(i + 4))) {
                    c = (char)(Json.hexval(image.charAt(i + 1)) << 12 | Json.hexval(image.charAt(i + 2)) << 8 | Json.hexval(image.charAt(i + 3)) << 4 | Json.hexval(image.charAt(i + 4)));
                    i += 4;
                } else if (i + 1 < l && Json.isOctalDigit(c) && Json.isOctalDigit(image.charAt(i + 1))) {
                    c = (char)(Json.octval(c) << 3 | Json.octval(image.charAt(i + 1)));
                    ++i;
                }
            }
            sb.append(c);
            ++i;
        }
        return sb.toString();
    }

    private static boolean isOctalDigit(char c) {
        return c >= '0' && c <= '7';
    }

    private static boolean isHexaDigit(char c) {
        return c >= '0' && c <= '9' || c >= 'A' && c <= 'F' || c >= 'a' && c <= 'f';
    }

    private static int hexval(char c) throws ParseException {
        switch (c) {
            case '0': {
                return 0;
            }
            case '1': {
                return 1;
            }
            case '2': {
                return 2;
            }
            case '3': {
                return 3;
            }
            case '4': {
                return 4;
            }
            case '5': {
                return 5;
            }
            case '6': {
                return 6;
            }
            case '7': {
                return 7;
            }
            case '8': {
                return 8;
            }
            case '9': {
                return 9;
            }
            case 'A': 
            case 'a': {
                return 10;
            }
            case 'B': 
            case 'b': {
                return 11;
            }
            case 'C': 
            case 'c': {
                return 12;
            }
            case 'D': 
            case 'd': {
                return 13;
            }
            case 'E': 
            case 'e': {
                return 14;
            }
            case 'F': 
            case 'f': {
                return 15;
            }
        }
        throw new ParseException("Internal error when evaluating hexadecimal escape sequence");
    }

    private static int octval(char c) throws ParseException {
        switch (c) {
            case '0': {
                return 0;
            }
            case '1': {
                return 1;
            }
            case '2': {
                return 2;
            }
            case '3': {
                return 3;
            }
            case '4': {
                return 4;
            }
            case '5': {
                return 5;
            }
            case '6': {
                return 6;
            }
            case '7': {
                return 7;
            }
            case '8': {
                return 8;
            }
            case '9': {
                return 9;
            }
        }
        throw new ParseException("Internal error when evaluating octal escape sequence");
    }

    public final Object nullLiteral() throws ParseException, JsonException {
        this.jj_consume_token(14);
        return this.factory.createNull();
    }

    public final Object booleanLiteral() throws ParseException, JsonException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 15: {
                this.jj_consume_token(15);
                return this.factory.createBoolean(true);
            }
            case 13: {
                this.jj_consume_token(13);
                return this.factory.createBoolean(false);
            }
        }
        this.jj_la1[0] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final Object numericLiteral() throws ParseException, JsonException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 16: {
                Token t = this.jj_consume_token(16);
                String image = t.image;
                if (image.startsWith("0x") || image.startsWith("0X")) {
                    String imageWithout0x = image.substring(2);
                    return this.factory.createNumber(Long.parseLong(imageWithout0x, 16));
                }
                if (image.startsWith("0") && !image.equals("0") && !image.startsWith("0.")) {
                    String imageWithout0 = image.length() > 1 ? image.substring(1) : image;
                    return this.factory.createNumber(Long.parseLong(imageWithout0, 8));
                }
                return this.factory.createNumber(Double.parseDouble(image));
            }
            case 20: {
                Token t = this.jj_consume_token(20);
                return this.factory.createNumber(Double.parseDouble(t.image));
            }
        }
        this.jj_la1[1] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final Object stringLiteral() throws ParseException, JsonException {
        Token t = this.jj_consume_token(22);
        return this.factory.createString(this.getStringValue(t.image));
    }

    public final Object literal(Object parent, String property) throws ParseException, JsonException {
        Object value;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 14: {
                value = this.nullLiteral();
                break;
            }
            case 13: 
            case 15: {
                value = this.booleanLiteral();
                break;
            }
            case 16: 
            case 20: {
                value = this.numericLiteral();
                break;
            }
            case 22: {
                value = this.stringLiteral();
                break;
            }
            case 27: {
                value = this.objectLiteral(parent, property);
                break;
            }
            case 29: {
                value = this.arrayLiteral(parent, property);
                break;
            }
            default: {
                this.jj_la1[2] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return value;
    }

    public final Object objectLiteral(Object parent, String property) throws ParseException, JsonException {
        this.jj_consume_token(27);
        Object object = this.factory.createObject(parent, property);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 22: 
            case 24: {
                this.propertyNameAndValueList(object);
                break;
            }
            default: {
                this.jj_la1[3] = this.jj_gen;
            }
        }
        this.jj_consume_token(28);
        return object;
    }

    public final void propertyNameAndValueList(Object parent) throws ParseException, JsonException {
        String name = this.propertyName();
        this.jj_consume_token(31);
        Object value = this.literal(parent, name);
        this.factory.setProperty(parent, name, value);
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 32: {
                    break;
                }
                default: {
                    this.jj_la1[4] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(32);
            name = this.propertyName();
            this.jj_consume_token(31);
            value = this.literal(parent, name);
            this.factory.setProperty(parent, name, value);
        }
    }

    public final String propertyName() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 24: {
                Token t = this.jj_consume_token(24);
                return t.image;
            }
            case 22: {
                Token t = this.jj_consume_token(22);
                return this.getStringValue(t.image);
            }
        }
        this.jj_la1[5] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final Object arrayLiteral(Object parent, String property) throws ParseException, JsonException {
        int count = 0;
        this.jj_consume_token(29);
        List<Object> array = this.factory.createTemporaryArray(parent);
        count = this.elision();
        int i = 0;
        while (i < count) {
            array.add(this.factory.createNull());
            ++i;
        }
        this.elementList(parent, property, array);
        int cnt = array.size();
        if (cnt == count && count != 0) {
            array.add(this.factory.createNull());
        }
        this.jj_consume_token(30);
        return this.factory.createArray(parent, property, array);
    }

    /*
     * Unable to fully structure code
     */
    public final void elementList(Object parent, String property, List<Object> array) throws ParseException, JsonException {
        count = 0;
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 13: 
                case 14: 
                case 15: 
                case 16: 
                case 20: 
                case 22: 
                case 27: 
                case 29: {
                    break;
                }
                default: {
                    this.jj_la1[6] = this.jj_gen;
                    break block3;
                }
            }
            value = this.literal(parent, property);
            array.add(value);
            count = this.elision();
            if (count <= 0) continue;
            i = 0;
            while (true) {
                if (i < count - 1) ** break;
                continue block3;
                array.add(this.factory.createNull());
                ++i;
            }
            break;
        }
        if (count > 0) {
            array.add(this.factory.createNull());
        }
    }

    public final int elision() throws ParseException {
        int count = 0;
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 32: {
                    break;
                }
                default: {
                    this.jj_la1[7] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(32);
            ++count;
        }
        return count;
    }

    public final Object parseJsonLiteral() throws ParseException, JsonException {
        Object object = this.literal(null, null);
        return object;
    }

    public final Object parseJson() throws ParseException, JsonException {
        Object object;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 27: {
                object = this.objectLiteral(null, null);
                break;
            }
            case 29: {
                object = this.arrayLiteral(null, null);
                break;
            }
            case 14: {
                object = this.nullLiteral();
                break;
            }
            case 13: 
            case 15: {
                object = this.booleanLiteral();
                break;
            }
            case 16: 
            case 20: {
                object = this.numericLiteral();
                break;
            }
            case 22: {
                object = this.stringLiteral();
                break;
            }
            case 33: {
                this.jj_consume_token(33);
                object = this.parseJson();
                this.jj_consume_token(34);
                break;
            }
            default: {
                this.jj_la1[8] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return object;
    }

    public final void parseJsonList(List list) throws ParseException, JsonException {
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 13: 
                case 14: 
                case 15: 
                case 16: 
                case 20: 
                case 22: 
                case 27: 
                case 29: 
                case 33: {
                    break;
                }
                default: {
                    this.jj_la1[9] = this.jj_gen;
                    break block3;
                }
            }
            Object value = this.parseJson();
            if (list == null) continue;
            list.add(value);
        }
        this.jj_consume_token(0);
    }

    public final void parseJsonCallback(JsonParser.ParseCallback callback) throws ParseException, JsonException {
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 13: 
                case 14: 
                case 15: 
                case 16: 
                case 20: 
                case 22: 
                case 27: 
                case 29: 
                case 33: {
                    break;
                }
                default: {
                    this.jj_la1[10] = this.jj_gen;
                    break block3;
                }
            }
            Object value = this.parseJson();
            if (callback == null) continue;
            callback.jsonEntry(value);
        }
        this.jj_consume_token(0);
    }

    private static void jj_la1_init_0() {
        int[] nArray = new int[11];
        nArray[0] = 40960;
        nArray[1] = 0x110000;
        nArray[2] = 676454400;
        nArray[3] = 0x1400000;
        nArray[5] = 0x1400000;
        nArray[6] = 676454400;
        nArray[8] = 676454400;
        nArray[9] = 676454400;
        nArray[10] = 676454400;
        jj_la1_0 = nArray;
    }

    private static void jj_la1_init_1() {
        int[] nArray = new int[11];
        nArray[4] = 1;
        nArray[7] = 1;
        nArray[8] = 2;
        nArray[9] = 2;
        nArray[10] = 2;
        jj_la1_1 = nArray;
    }

    public Json(InputStream stream) {
        this(stream, null);
    }

    public Json(InputStream stream, String encoding) {
        try {
            this.jj_input_stream = new SimpleCharStream(stream, encoding, 1, 1);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        this.token_source = new JsonTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        int i = 0;
        while (i < 11) {
            this.jj_la1[i] = -1;
            ++i;
        }
    }

    public void ReInit(InputStream stream) {
        this.ReInit(stream, null);
    }

    public void ReInit(InputStream stream, String encoding) {
        try {
            this.jj_input_stream.ReInit(stream, encoding, 1, 1);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        int i = 0;
        while (i < 11) {
            this.jj_la1[i] = -1;
            ++i;
        }
    }

    public Json(Reader stream) {
        this.jj_input_stream = new SimpleCharStream(stream, 1, 1);
        this.token_source = new JsonTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        int i = 0;
        while (i < 11) {
            this.jj_la1[i] = -1;
            ++i;
        }
    }

    public void ReInit(Reader stream) {
        this.jj_input_stream.ReInit(stream, 1, 1);
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        int i = 0;
        while (i < 11) {
            this.jj_la1[i] = -1;
            ++i;
        }
    }

    public Json(JsonTokenManager tm) {
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        int i = 0;
        while (i < 11) {
            this.jj_la1[i] = -1;
            ++i;
        }
    }

    public void ReInit(JsonTokenManager tm) {
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        int i = 0;
        while (i < 11) {
            this.jj_la1[i] = -1;
            ++i;
        }
    }

    private Token jj_consume_token(int kind) throws ParseException {
        Token oldToken = this.token;
        this.token = oldToken.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        if (this.token.kind == kind) {
            ++this.jj_gen;
            return this.token;
        }
        this.token = oldToken;
        this.jj_kind = kind;
        throw this.generateParseException();
    }

    public final Token getNextToken() {
        this.token = this.token.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        ++this.jj_gen;
        return this.token;
    }

    public final Token getToken(int index) {
        Token t = this.token;
        int i = 0;
        while (i < index) {
            t = t.next != null ? t.next : (t.next = this.token_source.getNextToken());
            ++i;
        }
        return t;
    }

    private int jj_ntk() {
        this.jj_nt = this.token.next;
        if (this.jj_nt == null) {
            this.token.next = this.token_source.getNextToken();
            this.jj_ntk = this.token.next.kind;
            return this.jj_ntk;
        }
        this.jj_ntk = this.jj_nt.kind;
        return this.jj_ntk;
    }

    public ParseException generateParseException() {
        this.jj_expentries.clear();
        boolean[] la1tokens = new boolean[35];
        if (this.jj_kind >= 0) {
            la1tokens[this.jj_kind] = true;
            this.jj_kind = -1;
        }
        int i = 0;
        while (i < 11) {
            if (this.jj_la1[i] == this.jj_gen) {
                int j = 0;
                while (j < 32) {
                    if ((jj_la1_0[i] & 1 << j) != 0) {
                        la1tokens[j] = true;
                    }
                    if ((jj_la1_1[i] & 1 << j) != 0) {
                        la1tokens[32 + j] = true;
                    }
                    ++j;
                }
            }
            ++i;
        }
        i = 0;
        while (i < 35) {
            if (la1tokens[i]) {
                this.jj_expentry = new int[1];
                this.jj_expentry[0] = i;
                this.jj_expentries.add(this.jj_expentry);
            }
            ++i;
        }
        int[][] exptokseq = new int[this.jj_expentries.size()][];
        int i2 = 0;
        while (i2 < this.jj_expentries.size()) {
            exptokseq[i2] = this.jj_expentries.get(i2);
            ++i2;
        }
        return new ParseException(this.token, exptokseq, tokenImage);
    }

    public final void enable_tracing() {
    }

    public final void disable_tracing() {
    }
}

