/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.commons.util.io.json;

import com.ibm.commons.util.io.json.JsonEmptyFactory;
import com.ibm.commons.util.io.json.JsonException;
import com.ibm.commons.util.io.json.JsonFactory;
import com.ibm.commons.util.io.json.parser.Json;
import java.io.Reader;
import java.io.StringReader;
import java.util.List;

public class JsonParser {
    public static boolean isJson(String json) {
        try {
            Json parser = JsonParser.getParser(JsonEmptyFactory.instance, new StringReader(json));
            parser.parseJson();
            return true;
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    public static Object fromJson(JsonFactory factory, String json) throws JsonException {
        try {
            Json parser = JsonParser.getParser(factory, new StringReader(json));
            return parser.parseJson();
        }
        catch (Throwable ex) {
            throw new JsonException(ex, "Error when parsing JSON string", new Object[0]);
        }
    }

    public static Object fromJson(JsonFactory factory, Reader reader) throws JsonException {
        try {
            Json parser = JsonParser.getParser(factory, reader);
            return parser.parseJson();
        }
        catch (Throwable ex) {
            throw new JsonException(ex, "Error when parsing JSON stream", new Object[0]);
        }
    }

    public static void fromJson(JsonFactory factory, Reader reader, List<Object> list) throws JsonException {
        try {
            Json parser = JsonParser.getParser(factory, reader);
            parser.parseJsonList(list);
        }
        catch (Throwable ex) {
            throw new JsonException(ex, "Error when parsing JSON list", new Object[0]);
        }
    }

    public static void fromJson(JsonFactory factory, Reader reader, ParseCallback cb) throws JsonException {
        try {
            Json parser = JsonParser.getParser(factory, reader);
            parser.parseJsonCallback(cb);
        }
        catch (Throwable ex) {
            throw new JsonException(ex, "Error when parsing JSON stream", new Object[0]);
        }
    }

    private static Json getParser(JsonFactory factory, Reader r) {
        Json parser = new Json(r);
        parser.factory = factory;
        return parser;
    }

    public static interface ParseCallback {
        public void jsonEntry(Object var1) throws JsonException;
    }
}

