/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.commons.util.io.json;

import com.ibm.commons.Platform;
import com.ibm.commons.util.io.json.JsonGenerator;
import com.ibm.commons.util.io.json.JsonJavaArray;
import com.ibm.commons.util.io.json.JsonJavaFactory;
import com.ibm.commons.util.io.json.JsonObject;
import java.io.IOException;
import java.io.Serializable;
import java.text.ParseException;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class JsonJavaObject
extends HashMap<String, Object>
implements JsonObject,
Serializable {
    private static final long serialVersionUID = 1L;

    public JsonJavaObject() {
    }

    public JsonJavaObject(Map<String, Object> props) {
        super(props != null ? props : Collections.EMPTY_MAP);
    }

    public JsonJavaObject(Object ... properties) {
        if (properties != null) {
            int i = 0;
            while (i < properties.length) {
                String name = (String)properties[i];
                Object value = properties[i + 1];
                this.put(name, value);
                i += 2;
            }
        }
    }

    @Override
    public String toString() {
        try {
            return JsonGenerator.toJson(JsonJavaFactory.instanceEx, this);
        }
        catch (Exception ex) {
            Platform.getInstance().log(ex);
            return "";
        }
    }

    @Override
    public final Iterator<String> getJsonProperties() {
        return this.getProperties();
    }

    @Override
    public final Object getJsonProperty(String property) {
        return this.get(property);
    }

    @Override
    public final void putJsonProperty(String property, Object value) {
        this.put(property, value);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty();
    }

    public Iterator<String> getProperties() {
        return this.keySet().iterator();
    }

    public Object get(String property) {
        return super.get(property);
    }

    public String getString(String property) {
        Object o = this.get(property);
        if (o != null) {
            return o.toString();
        }
        return null;
    }

    public int getInt(String property) {
        Object o = this.get(property);
        if (o != null) {
            return ((Number)o).intValue();
        }
        return 0;
    }

    public long getLong(String property) {
        Object o = this.get(property);
        if (o != null) {
            return ((Number)o).longValue();
        }
        return 0L;
    }

    public double getDouble(String property) {
        Object o = this.get(property);
        if (o != null) {
            return ((Number)o).doubleValue();
        }
        return 0.0;
    }

    public boolean getBoolean(String property) {
        Object o = this.get(property);
        if (o != null) {
            return (Boolean)o;
        }
        return false;
    }

    public JsonJavaObject getJsonObject(String property) {
        Object o = this.get(property);
        return (JsonJavaObject)o;
    }

    public void remove(String property) {
        super.remove(property);
    }

    public void removeAll() {
        super.clear();
    }

    @Override
    public Object put(String property, Object value) {
        return super.put(property, value);
    }

    public void putString(String property, Object value) {
        this.putString(property, value != null ? value.toString() : null);
    }

    public void putString(String property, String value) {
        this.put(property, (Object)value);
    }

    public void putInt(String property, int value) {
        this.put(property, (Object)value);
    }

    public void putLong(String property, long value) {
        this.put(property, (Object)value);
    }

    public void putDouble(String property, double value) {
        this.put(property, (Object)value);
    }

    public void putBoolean(String property, boolean value) {
        this.put(property, (Object)value);
    }

    public void putObject(String property, Object value) {
        this.put(property, value);
    }

    public void putMap(String property, Map<String, Object> value) {
        this.put(property, (Object)value);
    }

    public void putArray(String property, JsonJavaArray value) {
        this.put(property, (Object)value);
    }

    public void putList(String property, List<Object> value) {
        this.put(property, (Object)value);
    }

    public String getAsString(String property) {
        Object v = this.get(property);
        if (v != null) {
            return v.toString();
        }
        return null;
    }

    public double getAsDouble(String property) {
        Object v = this.get(property);
        if (v instanceof Number) {
            return ((Number)v).doubleValue();
        }
        if (v instanceof String) {
            return Double.parseDouble((String)v);
        }
        if (v instanceof Boolean) {
            return (Boolean)v != false ? 1 : 0;
        }
        return 0.0;
    }

    public int getAsInt(String property) {
        Object v = this.get(property);
        if (v instanceof Number) {
            return ((Number)v).intValue();
        }
        if (v instanceof String) {
            return Integer.parseInt((String)v);
        }
        if (v instanceof Boolean) {
            return (Boolean)v != false ? 1 : 0;
        }
        return 0;
    }

    public long getAsLong(String property) {
        Object v = this.get(property);
        if (v instanceof Number) {
            return ((Number)v).longValue();
        }
        if (v instanceof String) {
            return Long.parseLong((String)v);
        }
        if (v instanceof Boolean) {
            return (Boolean)v != false ? 1 : 0;
        }
        return 0L;
    }

    public long getAsLong(JsonObject o, String property) {
        Object v = this.get(property);
        if (v instanceof Number) {
            return ((Number)v).longValue();
        }
        if (v instanceof String) {
            return Long.parseLong((String)v);
        }
        if (v instanceof Boolean) {
            return (Boolean)v != false ? 1 : 0;
        }
        return 0L;
    }

    public boolean getAsBoolean(String property) {
        Object v = this.get(property);
        if (v instanceof Boolean) {
            return (Boolean)v;
        }
        if (v instanceof String) {
            String s = (String)v;
            return !s.equalsIgnoreCase("false") && !s.equals("0");
        }
        if (v instanceof Number) {
            return ((Number)v).doubleValue() != 0.0;
        }
        return v != null;
    }

    public boolean getAsBoolean(JsonObject o, String property) {
        Object v = this.get(property);
        if (v instanceof Boolean) {
            return (Boolean)v;
        }
        if (v instanceof String) {
            String s = (String)v;
            return !s.equalsIgnoreCase("false") && !s.equals("0");
        }
        if (v instanceof Number) {
            return ((Number)((Object)o)).doubleValue() != 0.0;
        }
        return v != null;
    }

    public JsonJavaObject getAsObject(String property) {
        Object v = this.get(property);
        if (v instanceof JsonJavaObject) {
            return (JsonJavaObject)v;
        }
        if (v instanceof Map) {
            return new JsonJavaObject((Map)v);
        }
        return null;
    }

    public Map<String, Object> getAsMap(String property) {
        Object v = this.get(property);
        if (v instanceof Map) {
            return (Map)v;
        }
        return null;
    }

    public JsonJavaArray getAsArray(String property) {
        Object v = this.get(property);
        if (v instanceof JsonJavaArray) {
            return (JsonJavaArray)v;
        }
        if (v instanceof List) {
            return new JsonJavaArray((List)v);
        }
        return null;
    }

    public List<Object> getAsList(String property) {
        Object v = this.get(property);
        if (v instanceof List) {
            return (List)v;
        }
        return null;
    }

    public Date getJavaDate(String property) throws IOException, ParseException {
        String s = this.getString(property);
        if (s != null) {
            return JsonGenerator.stringToDate(s);
        }
        return null;
    }

    public void putJavaDate(String property, Date value) throws IOException {
        if (value != null) {
            String dt = JsonGenerator.dateToString(value);
            this.put(property, (Object)dt);
        }
    }
}

