/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.commons.util.io.json;

import com.ibm.commons.util.ArrayIterator;
import com.ibm.commons.util.StringUtil;
import com.ibm.commons.util.io.json.JsonArray;
import com.ibm.commons.util.io.json.JsonException;
import com.ibm.commons.util.io.json.JsonFactory;
import com.ibm.commons.util.io.json.JsonJavaArray;
import com.ibm.commons.util.io.json.JsonJavaObject;
import com.ibm.commons.util.io.json.JsonObject;
import com.ibm.commons.util.io.json.JsonReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class JsonJavaFactory
implements JsonFactory {
    public static final JsonJavaFactory instance = new JsonJavaFactory();
    public static final JsonJavaFactory instanceEx = new JsonJavaFactory(){

        @Override
        public Object createObject(Object parent, String propertyName) {
            return new JsonJavaObject();
        }
    };
    public static final JsonJavaFactory instanceEx2 = new JsonJavaFactory(){

        @Override
        public Object createObject(Object parent, String propertyName) {
            return new JsonJavaObject();
        }

        @Override
        public List<Object> createTemporaryArray(Object parent) throws JsonException {
            return new JsonJavaArray();
        }

        @Override
        public Object createArray(Object parent, String propertyName, List<Object> values) {
            if (values instanceof JsonJavaArray) {
                return values;
            }
            return new JsonJavaArray(values);
        }
    };

    @Override
    public boolean supportFeature(int feature) {
        return feature == 1;
    }

    @Override
    public boolean isValidValue(Object value) throws JsonException {
        return this.isNull(value) || this.isUndefined(value) || this.isBoolean(value) || this.isNumber(value) || this.isString(value) || this.isObject(value) || this.isArray(value) || this.isJavaScriptCode(value);
    }

    @Override
    public Object createNull() throws JsonException {
        return null;
    }

    @Override
    public Object createUndefined() throws JsonException {
        throw new JsonException(null, "Undefined does not exist in Java", new Object[0]);
    }

    @Override
    public Object createString(String value) throws JsonException {
        return value;
    }

    @Override
    public Object createNumber(double value) throws JsonException {
        return value;
    }

    @Override
    public Object createBoolean(boolean value) throws JsonException {
        return value;
    }

    @Override
    public Object createObject(Object parent, String propertyName) throws JsonException {
        return new HashMap();
    }

    @Override
    public Object createArray(Object parent, String propertyName, List<Object> values) throws JsonException {
        return values;
    }

    @Override
    public Object createJavaScriptCode(String code) throws JsonException {
        return new JsonReference(code);
    }

    @Override
    public void setProperty(Object parent, String propertyName, Object value) throws JsonException {
        if (parent instanceof Map) {
            ((Map)parent).put(propertyName, value);
        } else if (parent instanceof JsonObject) {
            ((JsonObject)parent).putJsonProperty(propertyName, value);
        } else {
            throw new IllegalArgumentException(StringUtil.format("Invalid Json object, class: {0}", parent != null ? parent.getClass().toString() : "null"));
        }
    }

    @Override
    public Object getProperty(Object parent, String propertyName) throws JsonException {
        if (parent instanceof Map) {
            return ((Map)parent).get(propertyName);
        }
        if (parent instanceof JsonObject) {
            return ((JsonObject)parent).getJsonProperty(propertyName);
        }
        throw new IllegalArgumentException(StringUtil.format("Invalid Json object, class: {0}", parent != null ? parent.getClass().toString() : "null"));
    }

    @Override
    public boolean isNull(Object value) throws JsonException {
        return value == null;
    }

    @Override
    public boolean isUndefined(Object value) {
        return false;
    }

    @Override
    public boolean isString(Object value) throws JsonException {
        return value instanceof String;
    }

    @Override
    public String getString(Object value) throws JsonException {
        return (String)value;
    }

    @Override
    public boolean isNumber(Object value) throws JsonException {
        return value instanceof Number;
    }

    @Override
    public double getNumber(Object value) throws JsonException {
        return ((Number)value).doubleValue();
    }

    @Override
    public boolean isBoolean(Object value) throws JsonException {
        return value instanceof Boolean;
    }

    @Override
    public boolean getBoolean(Object value) throws JsonException {
        return (Boolean)value;
    }

    @Override
    public boolean isObject(Object value) throws JsonException {
        return value instanceof Map || value instanceof JsonObject;
    }

    @Override
    public boolean isJavaScriptCode(Object value) throws JsonException {
        if (this.supportFeature(1)) {
            return value instanceof JsonReference;
        }
        return false;
    }

    @Override
    public String getJavaScriptCode(Object value) throws JsonException {
        if (this.supportFeature(1)) {
            return ((JsonReference)value).getRef();
        }
        return null;
    }

    @Override
    public Iterator<String> iterateObjectProperties(Object object) throws JsonException {
        if (object instanceof Map) {
            Map map = (Map)object;
            return map.keySet().iterator();
        }
        if (object instanceof JsonObject) {
            return ((JsonObject)object).getJsonProperties();
        }
        throw new IllegalArgumentException(StringUtil.format("Invalid Json object, class: {0}", object != null ? object.getClass().toString() : "null"));
    }

    @Override
    public boolean isArray(Object value) throws JsonException {
        if (value == null) {
            return false;
        }
        if (value instanceof JsonArray) {
            return true;
        }
        if (value instanceof List) {
            return true;
        }
        return value.getClass().isArray();
    }

    @Override
    public int getArrayCount(Object value) throws JsonException {
        if (value instanceof JsonArray) {
            return ((JsonArray)value).length();
        }
        if (value instanceof List) {
            return ((List)value).size();
        }
        return ((Object[])value).length;
    }

    public Object getArrayItem(Object value, int index) throws JsonException {
        if (value instanceof JsonArray) {
            return ((JsonArray)value).get(index);
        }
        if (value instanceof List) {
            return ((List)value).get(index);
        }
        return ((Object[])value)[index];
    }

    @Override
    public Iterator<Object> iterateArrayValues(Object array) throws JsonException {
        if (array instanceof JsonArray) {
            return ((JsonArray)array).iterator();
        }
        if (array instanceof List) {
            List list = (List)array;
            return list.iterator();
        }
        return new ArrayIterator<Object>(array);
    }

    @Override
    public List<Object> createTemporaryArray(Object parent) throws JsonException {
        return new ArrayList<Object>();
    }
}

