/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.commons.util.io.json;

import com.ibm.commons.Platform;
import com.ibm.commons.util.io.json.JsonArray;
import com.ibm.commons.util.io.json.JsonGenerator;
import com.ibm.commons.util.io.json.JsonJavaFactory;
import com.ibm.commons.util.io.json.JsonJavaObject;
import com.ibm.commons.util.io.json.JsonObject;
import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;

public class JsonJavaArray
extends ArrayList<Object>
implements JsonArray {
    private static final long serialVersionUID = 1L;

    public JsonJavaArray() {
    }

    public JsonJavaArray(int initialCapacity) {
        super(initialCapacity);
    }

    public JsonJavaArray(List<Object> list) {
        if (list != null) {
            this.addAll(list);
        }
    }

    @Override
    public String toString() {
        try {
            return JsonGenerator.toJson(JsonJavaFactory.instanceEx, this);
        }
        catch (Exception ex) {
            Platform.getInstance().log(ex);
            return "";
        }
    }

    @Override
    public int length() {
        return this.size();
    }

    @Override
    public String getString(int index) {
        Object o = this.get(index);
        if (o != null) {
            return (String)o;
        }
        return null;
    }

    @Override
    public double getNumber(int index) {
        Object o = this.get(index);
        if (o != null) {
            return ((Number)o).doubleValue();
        }
        return 0.0;
    }

    @Override
    public boolean getBoolean(int index) {
        Object o = this.get(index);
        if (o != null) {
            return (Boolean)o;
        }
        return false;
    }

    @Override
    public JsonObject getObject(int index) {
        Object o = this.get(index);
        if (o != null) {
            return (JsonObject)o;
        }
        return null;
    }

    @Override
    public JsonArray getArray(int index) {
        Object o = this.get(index);
        if (o != null) {
            return (JsonArray)o;
        }
        return null;
    }

    @Override
    public void put(int index, Object value) {
        while (this.size() <= index) {
            this.add(null);
        }
        this.set(index, value);
    }

    @Override
    public void putString(int index, String value) {
        this.put(index, value);
    }

    @Override
    public void putNumber(int index, double value) {
        this.put(index, value);
    }

    @Override
    public void putBoolean(int index, boolean value) {
        this.put(index, value);
    }

    @Override
    public void putObject(int index, JsonObject value) {
        this.put(index, value);
    }

    @Override
    public void putArray(int index, JsonArray value) {
        this.put(index, value);
    }

    public void add(Object[] values) {
        if (values != null) {
            int i = 0;
            while (i < values.length) {
                this.add(values[i]);
                ++i;
            }
        }
    }

    public String getAsString(int index) {
        Object v = this.get(index);
        if (v != null) {
            return v.toString();
        }
        return null;
    }

    public double getAsDouble(int index) {
        Object v = this.get(index);
        if (v instanceof Number) {
            return ((Number)v).doubleValue();
        }
        if (v instanceof String) {
            return Double.parseDouble((String)v);
        }
        if (v instanceof Boolean) {
            return (Boolean)v != false ? 1 : 0;
        }
        return 0.0;
    }

    public int getAsInt(int index) {
        Object v = this.get(index);
        if (v instanceof Number) {
            return ((Number)v).intValue();
        }
        if (v instanceof String) {
            return Integer.parseInt((String)v);
        }
        if (v instanceof Boolean) {
            return (Boolean)v != false ? 1 : 0;
        }
        return 0;
    }

    public long getAsLong(JsonObject o, int index) {
        Object v = this.get(index);
        if (v instanceof Number) {
            return ((Number)v).longValue();
        }
        if (v instanceof String) {
            return Long.parseLong((String)v);
        }
        if (v instanceof Boolean) {
            return (Boolean)v != false ? 1 : 0;
        }
        return 0L;
    }

    public boolean getAsBoolean(JsonObject o, int index) {
        Object v = this.get(index);
        if (v instanceof Boolean) {
            return (Boolean)v;
        }
        if (v instanceof String) {
            String s = (String)v;
            return !s.equalsIgnoreCase("false") && !s.equals("0");
        }
        if (v instanceof Number) {
            return ((Number)((Object)o)).doubleValue() != 0.0;
        }
        return v != null;
    }

    public JsonJavaObject getAsObject(int index) {
        Object v = this.get(index);
        if (v instanceof JsonJavaObject) {
            return (JsonJavaObject)v;
        }
        if (v instanceof Map) {
            return new JsonJavaObject((Map)v);
        }
        return null;
    }

    public Map<String, Object> getAsMap(int index) {
        Object v = this.get(index);
        if (v instanceof Map) {
            return (Map)v;
        }
        return null;
    }

    public JsonJavaArray getAsArray(int index) {
        Object v = this.get(index);
        if (v instanceof JsonJavaArray) {
            return (JsonJavaArray)v;
        }
        if (v instanceof List) {
            return new JsonJavaArray((List)v);
        }
        return null;
    }

    public List<Object> getAsList(int index) {
        Object v = this.get(index);
        if (v instanceof List) {
            return (List)v;
        }
        return null;
    }

    public Date getJavaDate(int index) throws IOException, ParseException {
        String s = this.getString(index);
        if (s != null) {
            return JsonGenerator.stringToDate(s);
        }
        return null;
    }

    public void putJavaDate(int index, Date value) throws IOException {
        if (value != null) {
            String dt = JsonGenerator.dateToString(value);
            this.put(index, dt);
        }
    }
}

