/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.commons.util.io.json;

import com.ibm.commons.util.StringUtil;
import com.ibm.commons.util.io.json.JsonException;
import com.ibm.commons.util.io.json.JsonFactory;
import com.ibm.commons.util.io.json.JsonReference;
import java.io.IOException;
import java.io.Writer;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;

public class JsonGenerator {
    public static final String TIME_FORMAT_B = "yyyy-MM-dd'T'HH:mm:ss";
    private static SimpleDateFormat ISO8601 = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");

    public static String toJson(JsonFactory factory, Object value) throws IOException, JsonException {
        return JsonGenerator.toJson(factory, value, true);
    }

    public static String toJson(JsonFactory factory, Object value, boolean compact) throws IOException, JsonException {
        StringGenerator gen = new StringGenerator(factory, compact);
        gen.toJson(value);
        return gen.b.toString();
    }

    public static StringBuilder toJson(JsonFactory factory, StringBuilder b, Object value, boolean compact) throws IOException, JsonException {
        StringBuilderGenerator gen = new StringBuilderGenerator(factory, b, compact);
        gen.toJson(value);
        return b;
    }

    public static void toJson(JsonFactory factory, Writer writer, Object value, boolean compact) throws IOException, JsonException {
        WriterGenerator gen = new WriterGenerator(factory, writer, compact);
        gen.toJson(value);
    }

    public static String dateToString(Date value) throws IOException {
        return ISO8601.format(value);
    }

    public static Date stringToDate(String value) throws IOException, ParseException {
        return ISO8601.parse(value);
    }

    public static abstract class Generator {
        private JsonFactory factory;
        private boolean compact;
        private int indentLevel;

        protected Generator(JsonFactory factory, boolean compact) {
            this.factory = factory;
            this.compact = compact;
        }

        public abstract void out(char var1) throws IOException;

        public abstract void out(String var1) throws IOException;

        public JsonFactory getFactory() {
            return this.factory;
        }

        public int getIndentLevel() {
            return this.indentLevel;
        }

        public void setIndentLevel(int indentLevel) {
            this.indentLevel = indentLevel;
        }

        public void incIndent() {
            ++this.indentLevel;
        }

        public void decIndent() {
            --this.indentLevel;
        }

        public boolean isCompact() {
            return this.compact;
        }

        public void toJson(Object value) throws IOException, JsonException {
            this.outLiteral(value);
        }

        public void outLiteral(Object value) throws IOException, JsonException {
            this.outLiteral(value, false);
        }

        protected void outLiteral(Object value, boolean named) throws IOException, JsonException {
            if (this.factory.isNull(value)) {
                this.outNull();
            } else if (this.factory.isString(value)) {
                this.outStringLiteral(this.factory.getString(value));
            } else if (this.factory.isNumber(value)) {
                this.outNumberLiteral(this.factory.getNumber(value));
            } else if (this.factory.isBoolean(value)) {
                this.outBooleanLiteral(this.factory.getBoolean(value));
            } else if (this.factory.isObject(value)) {
                this.outObject(value, named);
            } else if (this.factory.isArray(value)) {
                this.outArrayLiteral(value, named);
            } else if (value instanceof JsonReference) {
                this.outReference((JsonReference)value);
            } else {
                throw new JsonException(null, "Unknown literal of class {0}", value != null ? value.getClass().getName() : "<null>");
            }
        }

        public void outNull() throws IOException, JsonException {
            this.out("null");
        }

        public void outObject(Object object) throws IOException, JsonException {
            this.outObject(object, false);
        }

        protected void outObject(Object object, boolean named) throws IOException, JsonException {
            if (named) {
                this.out(' ');
            } else {
                this.indent();
            }
            this.startObject(object);
            boolean coma = false;
            Iterator<String> it = this.factory.iterateObjectProperties(object);
            while (it.hasNext()) {
                String propName = it.next();
                Object propValue = this.factory.getProperty(object, propName);
                if (coma) {
                    this.out(',');
                } else {
                    coma = true;
                }
                ++this.indentLevel;
                this.nl();
                this.indent();
                this.outPropertyName(propName);
                this.out(':');
                this.outLiteral(propValue, true);
                --this.indentLevel;
            }
            this.nl();
            this.indent();
            this.endObject(object);
        }

        protected void startObject(Object object) throws IOException, JsonException {
            this.out('{');
        }

        protected void endObject(Object object) throws IOException, JsonException {
            this.out('}');
        }

        public void outPropertyName(String s) throws IOException {
            this.outStringLiteral(s);
        }

        public void outStringLiteral(String s) throws IOException {
            this.out('\"');
            int len = s.length();
            int i = 0;
            while (i < len) {
                char c = s.charAt(i);
                switch (c) {
                    case '\"': {
                        this.out("\\\"");
                        break;
                    }
                    case '\\': {
                        this.out("\\\\");
                        break;
                    }
                    case '/': {
                        this.out("\\/");
                        break;
                    }
                    case '\b': {
                        this.out("\\b");
                        break;
                    }
                    case '\f': {
                        this.out("\\f");
                        break;
                    }
                    case '\n': {
                        this.out("\\n");
                        break;
                    }
                    case '\r': {
                        this.out("\\r");
                        break;
                    }
                    case '\t': {
                        this.out("\\t");
                        break;
                    }
                    default: {
                        if (c >= ' ' && c <= '\u0080') {
                            this.out(c);
                            break;
                        }
                        this.out("\\u");
                        this.out(StringUtil.toUnsignedHex(c, 4));
                    }
                }
                ++i;
            }
            this.out('\"');
        }

        public void outCharInString(char c) throws IOException {
            switch (c) {
                case '\"': {
                    this.out("\\\"");
                    break;
                }
                case '\'': {
                    this.out("\\'");
                    break;
                }
                case '\\': {
                    this.out("\\\\");
                    break;
                }
                case '/': {
                    this.out("\\/");
                    break;
                }
                case '\b': {
                    this.out("\\b");
                    break;
                }
                case '\f': {
                    this.out("\\f");
                    break;
                }
                case '\n': {
                    this.out("\\n");
                    break;
                }
                case '\r': {
                    this.out("\\r");
                    break;
                }
                case '\t': {
                    this.out("\\t");
                    break;
                }
                default: {
                    if (c >= ' ' && c <= '\u0080') {
                        this.out(c);
                        break;
                    }
                    this.out("\\u");
                    this.out(StringUtil.toUnsignedHex(c, 4));
                }
            }
        }

        public void outNumberLiteral(double d) throws IOException {
            long l = (long)d;
            if ((double)l == d) {
                String s = Long.toString(l);
                this.out(s);
            } else {
                String s = Double.toString(d);
                this.out(s);
            }
        }

        public void outDateLiteral_(Date value) throws IOException {
            String s = JsonGenerator.dateToString(value);
            this.outStringLiteral(s);
        }

        public void outIntLiteral(int d) throws IOException {
            String s = Integer.toString(d);
            this.out(s);
        }

        public void outLongLiteral(long d) throws IOException {
            String s = Long.toString(d);
            this.out(s);
        }

        public void outBooleanLiteral(boolean b) throws IOException {
            this.out(b ? "true" : "false");
        }

        public void outArrayLiteral(Object array) throws IOException, JsonException {
            this.outArrayLiteral(array, false);
        }

        protected void outArrayLiteral(Object array, boolean named) throws IOException, JsonException {
            if (named) {
                this.out(' ');
            } else {
                this.indent();
            }
            this.out('[');
            this.nl();
            boolean coma = false;
            Iterator<Object> it = this.factory.iterateArrayValues(array);
            while (it.hasNext()) {
                Object propValue = it.next();
                ++this.indentLevel;
                if (coma) {
                    this.out(',');
                    this.nl();
                } else {
                    coma = true;
                }
                this.indent();
                this.outLiteral(propValue);
                --this.indentLevel;
            }
            this.nl();
            this.indent();
            this.out(']');
        }

        public void outReference(JsonReference ref) throws IOException, JsonException {
            String s = ref.getRef();
            if (StringUtil.isNotEmpty(s)) {
                this.out(s);
            } else {
                this.out("null");
            }
        }

        public void indent() throws IOException {
            if (!this.compact && this.indentLevel > 0) {
                int i = 0;
                while (i < this.indentLevel) {
                    this.out("  ");
                    ++i;
                }
            }
        }

        public void nl() throws IOException {
            if (!this.compact) {
                this.out('\n');
            }
        }
    }

    public static class StringBuilderGenerator
    extends Generator {
        protected StringBuilder b;

        public StringBuilderGenerator(JsonFactory factory, StringBuilder b, boolean compact) {
            super(factory, compact);
            this.b = b;
        }

        public StringBuilder getStringBuilder() {
            return this.b;
        }

        @Override
        public void out(char c) throws IOException {
            this.b.append(c);
        }

        @Override
        public void out(String s) throws IOException {
            this.b.append(s);
        }
    }

    public static class StringGenerator
    extends Generator {
        protected StringBuilder b = new StringBuilder();

        public StringGenerator(JsonFactory factory, boolean compact) {
            super(factory, compact);
        }

        public StringBuilder getStringBuilder() {
            return this.b;
        }

        @Override
        public void out(char c) throws IOException {
            this.b.append(c);
        }

        @Override
        public void out(String s) throws IOException {
            this.b.append(s);
        }
    }

    public static class WriterGenerator
    extends Generator {
        private Writer writer;

        public WriterGenerator(JsonFactory factory, Writer writer, boolean compact) {
            super(factory, compact);
            this.writer = writer;
        }

        public void flush() throws IOException {
            this.writer.flush();
        }

        public void close() throws IOException {
            this.writer.close();
        }

        @Override
        public void out(char c) throws IOException {
            this.writer.write(c);
        }

        @Override
        public void out(String s) throws IOException {
            this.writer.write(s);
        }
    }
}

