/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.commons.util.io.base64;

import com.ibm.commons.util.io.base64.IoConstants;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class Base64OutputStream
extends FilterOutputStream {
    private byte[] _buffer = new byte[3];
    private int _buflen = 0;
    private int _count = 0;
    private int _lineLength;

    public Base64OutputStream(OutputStream out) {
        this(out, Integer.MAX_VALUE);
    }

    public Base64OutputStream(OutputStream out, int lineLength) {
        super(out);
        this._lineLength = lineLength;
    }

    @Override
    public void write(int ch) throws IOException {
        this._buffer[this._buflen++] = (byte)ch;
        if (this._buflen == 3) {
            this.encode();
            this._buflen = 0;
        }
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        int i = 0;
        while (i < len) {
            this.write(b[off + i]);
            ++i;
        }
    }

    @Override
    public void flush() throws IOException {
        if (this._buflen > 0) {
            this.encode();
            this._buflen = 0;
        }
        this.out.flush();
    }

    @Override
    public void close() throws IOException {
        this.flush();
        this.out.close();
    }

    private void encode() throws IOException {
        if (this._count + 4 > this._lineLength) {
            this.out.write(13);
            this.out.write(10);
            this._count = 0;
        }
        if (this._buflen == 1) {
            byte b = this._buffer[0];
            int i = 0;
            this.out.write(IoConstants.B64_SRC_MAP[b >>> 2 & 0x3F]);
            this.out.write(IoConstants.B64_SRC_MAP[(b << 4 & 0x30) + (i >>> 4 & 0xF)]);
            this.out.write(61);
            this.out.write(61);
        } else if (this._buflen == 2) {
            byte b1 = this._buffer[0];
            byte b2 = this._buffer[1];
            int i = 0;
            this.out.write(IoConstants.B64_SRC_MAP[b1 >>> 2 & 0x3F]);
            this.out.write(IoConstants.B64_SRC_MAP[(b1 << 4 & 0x30) + (b2 >>> 4 & 0xF)]);
            this.out.write(IoConstants.B64_SRC_MAP[(b2 << 2 & 0x3C) + (i >>> 6 & 3)]);
            this.out.write(61);
        } else {
            byte b1 = this._buffer[0];
            byte b2 = this._buffer[1];
            byte b3 = this._buffer[2];
            this.out.write(IoConstants.B64_SRC_MAP[b1 >>> 2 & 0x3F]);
            this.out.write(IoConstants.B64_SRC_MAP[(b1 << 4 & 0x30) + (b2 >>> 4 & 0xF)]);
            this.out.write(IoConstants.B64_SRC_MAP[(b2 << 2 & 0x3C) + (b3 >>> 6 & 3)]);
            this.out.write(IoConstants.B64_SRC_MAP[b3 & 0x3F]);
        }
        this._count += 4;
    }
}

