/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.commons.util.io.base64;

import com.ibm.commons.util.io.base64.IoConstants;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class Base64InputStream
extends FilterInputStream {
    private byte[] _buffer;
    private int _buflen = 0;
    private int _index = 0;
    private byte[] _decodeBuf = new byte[4];

    public Base64InputStream(InputStream in) {
        super(in);
        this._buffer = new byte[3];
    }

    @Override
    public int read() throws IOException {
        if (this._index >= this._buflen) {
            this.decode();
            if (this._buflen == 0) {
                return -1;
            }
            this._index = 0;
        }
        return this._buffer[this._index++] & 0xFF;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        try {
            int l = 0;
            while (l < len) {
                int ch = this.read();
                if (ch == -1) {
                    if (l != 0) break;
                    return -1;
                }
                b[off + l] = (byte)ch;
                ++l;
            }
            return l;
        }
        catch (IOException iOException) {
            return -1;
        }
    }

    @Override
    public int available() throws IOException {
        return this.in.available() * 3 / 4 + (this._buflen - this._index);
    }

    private void decode() throws IOException {
        int l;
        this._buflen = 0;
        int ch = 10;
        while (ch == 10 || ch == 13) {
            ch = this.in.read();
            if (ch != -1) continue;
            return;
        }
        this._decodeBuf[0] = (byte)ch;
        int j = 3;
        int k = 1;
        while ((l = this.in.read(this._decodeBuf, k, j)) != j) {
            if (l == -1) {
                throw new IOException("Base64 encoding error");
            }
            j -= l;
            k += l;
        }
        byte b0 = IoConstants.B64_DST_MAP[this._decodeBuf[0] & 0xFF];
        byte b2 = IoConstants.B64_DST_MAP[this._decodeBuf[1] & 0xFF];
        this._buffer[this._buflen++] = (byte)(b0 << 2 & 0xFC | b2 >>> 4 & 3);
        if (this._decodeBuf[2] != 61) {
            b0 = b2;
            b2 = IoConstants.B64_DST_MAP[this._decodeBuf[2] & 0xFF];
            this._buffer[this._buflen++] = (byte)(b0 << 4 & 0xF0 | b2 >>> 2 & 0xF);
            if (this._decodeBuf[3] != 61) {
                byte b1 = b2;
                b2 = IoConstants.B64_DST_MAP[this._decodeBuf[3] & 0xFF];
                this._buffer[this._buflen++] = (byte)(b1 << 6 & 0xC0 | b2 & 0x3F);
            }
        }
    }
}

