/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.commons.util.io.base64;

import com.ibm.commons.util.io.base64.Base64InputStream;
import com.ibm.commons.util.io.base64.Base64OutputStream;
import java.io.IOException;

public class Base64 {
    public static String decode(String base64str) {
        try {
            int byt;
            StringInputStream bais = new StringInputStream(base64str);
            InputStream b64 = new InputStream(bais);
            StringBuffer buf = new StringBuffer();
            while ((byt = b64.read()) >= 0) {
                buf.append((char)byt);
            }
            return buf.toString();
        }
        catch (IOException ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static String encode(String str) {
        try {
            StringBuidlerOutputStream baos = new StringBuidlerOutputStream(str.length() * 3 / 2);
            OutputStream b64 = new OutputStream(baos);
            int len = str.length();
            int i = 0;
            while (i < len) {
                int c = str.charAt(i) & 0xFF;
                b64.write(c);
                ++i;
            }
            b64.flushBuffer();
            return baos.builder.toString();
        }
        catch (IOException ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static class InputStream
    extends Base64InputStream {
        public InputStream(java.io.InputStream in) {
            super(in);
        }
    }

    public static class OutputStream
    extends Base64OutputStream {
        public OutputStream(java.io.OutputStream out) {
            super(out);
        }

        public void flushBuffer() throws IOException {
            this.flush();
        }
    }

    public static class StringBufferOutputStream
    extends java.io.OutputStream {
        private StringBuffer buffer;

        public StringBufferOutputStream(int size) {
            this.buffer = new StringBuffer(size);
        }

        public StringBuffer getStringBuffer() {
            return this.buffer;
        }

        @Override
        public void write(int b) throws IOException {
            this.buffer.append((char)b);
        }
    }

    public static class StringBuidlerOutputStream
    extends java.io.OutputStream {
        private StringBuilder builder;

        public StringBuidlerOutputStream(int size) {
            this.builder = new StringBuilder(size);
        }

        public StringBuilder getStringBuilder() {
            return this.builder;
        }

        @Override
        public void write(int b) throws IOException {
            this.builder.append((char)b);
        }
    }

    public static class StringInputStream
    extends java.io.InputStream {
        private String str;
        private int ptr;

        public StringInputStream(String str) {
            this.str = str;
        }

        @Override
        public int read() throws IOException {
            if (this.ptr < this.str.length()) {
                return this.str.charAt(this.ptr++);
            }
            return -1;
        }
    }
}

