/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.commons.util.io;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;

public class WriterOutputStream
extends OutputStream {
    private Writer writer;
    private String encoding;

    public WriterOutputStream(Writer writer, String encoding) {
        this.writer = writer;
        this.encoding = encoding;
    }

    public WriterOutputStream(Writer writer) {
        this(writer, null);
    }

    @Override
    public void write(int b) throws IOException {
        this.writer.write(b);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        if (this.encoding != null) {
            this.writer.write(new String(b, off, len, this.encoding));
        } else {
            this.writer.write(new String(b, off, len));
        }
    }

    @Override
    public void write(byte[] b) throws IOException {
        if (this.encoding != null) {
            this.writer.write(new String(b, this.encoding));
        } else {
            this.writer.write(new String(b));
        }
    }

    @Override
    public void close() throws IOException {
        this.writer.close();
    }

    @Override
    public void flush() throws IOException {
        this.writer.flush();
    }
}

