/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.commons.util.io;

import java.io.IOException;
import java.io.Reader;
import java.io.Writer;

public class TraceReader
extends Reader {
    private Reader reader;
    private Writer trace;

    public TraceReader(Reader reader, Writer trace) {
        this.reader = reader;
        this.trace = trace;
    }

    @Override
    public void close() throws IOException {
        this.reader.close();
        this.trace.flush();
    }

    @Override
    public int read() throws IOException {
        int c = this.reader.read();
        if (c >= 0) {
            this.trace.write((char)c);
        }
        return c;
    }

    @Override
    public int read(char[] cbuf, int off, int len) throws IOException {
        int n = this.reader.read(cbuf, off, len);
        if (n > 0) {
            this.trace.write(cbuf, off, n);
        }
        return n;
    }
}

