/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.commons.util.io;

import java.io.IOException;
import java.io.OutputStream;

public class TraceOutputStream
extends OutputStream {
    private OutputStream outputStream;
    private OutputStream trace;
    private boolean close;

    public TraceOutputStream(OutputStream outputStream, OutputStream trace, boolean close) {
        this.outputStream = outputStream;
        this.trace = trace;
        this.close = close;
    }

    @Override
    public void close() throws IOException {
        this.outputStream.close();
        if (this.close) {
            this.trace.close();
        } else {
            this.trace.flush();
        }
    }

    @Override
    public void flush() throws IOException {
        this.outputStream.flush();
    }

    @Override
    public void write(int b) throws IOException {
        this.outputStream.write(b);
        this.trace.write(b);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.outputStream.write(b, off, len);
        this.trace.write(b, off, len);
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.outputStream.write(b);
        this.trace.write(b);
    }
}

