/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.commons.util.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class TraceInputStream
extends InputStream {
    private InputStream inputStream;
    private OutputStream trace;
    private boolean close;

    public TraceInputStream(InputStream inputStream, OutputStream trace, boolean close) {
        this.inputStream = inputStream;
        this.trace = trace;
        this.close = close;
    }

    @Override
    public void close() throws IOException {
        this.inputStream.close();
        if (this.close) {
            this.trace.close();
        } else {
            this.trace.flush();
        }
    }

    @Override
    public int read() throws IOException {
        int b = this.inputStream.read();
        if (b >= 0) {
            this.trace.write(b);
        }
        return b;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int r = this.inputStream.read(b, off, len);
        if (r > 0) {
            this.trace.write(b, off, r);
        }
        return r;
    }
}

