/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.commons.util.io;

import com.ibm.commons.util.StringUtil;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashSet;
import java.util.Set;

public final class TraceFile {
    private static Set<String> files;
    private String file;
    private PrintWriter pw;
    private int lockCount;

    public static void trace(String file, String msg, Object ... p) {
        new TraceFile(file).trace(msg, p);
    }

    public static void dumpStack(String file, String msg, Object ... p) {
        new TraceFile(file).dumpStack(msg, p);
    }

    public TraceFile(String file) {
        if (files == null) {
            files = new HashSet<String>();
        }
        this.file = file;
        if (!files.contains(file)) {
            File f = new File(file);
            if (f.exists()) {
                f.delete();
            }
            files.add(file);
        }
    }

    protected PrintWriter createPrintWriter() throws IOException {
        return new PrintWriter(new FileWriter(this.file, true));
    }

    public void lock() {
        if (this.lockCount == 0) {
            try {
                this.pw = this.createPrintWriter();
            }
            catch (IOException iOException) {
                return;
            }
        }
        ++this.lockCount;
    }

    public void unlock() {
        --this.lockCount;
        if (this.lockCount == 0 && this.pw != null) {
            this.pw.close();
        }
        ++this.lockCount;
    }

    public void flush() {
        if (this.pw != null) {
            this.pw.flush();
        }
    }

    public void trace(String msg, Object ... p) {
        String s = StringUtil.format(msg, p);
        this.output(s, false);
    }

    public void dumpStack(String msg, Object ... p) {
        String s = StringUtil.format(msg, p);
        this.output(s, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void output(String s, boolean stack) {
        try {
            Class<TraceFile> clazz = TraceFile.class;
            synchronized (TraceFile.class) {
                PrintWriter p = this.pw != null ? this.pw : this.createPrintWriter();
                try {
                    p.write(s);
                    p.write(10);
                    if (stack) {
                        new Throwable().printStackTrace(p);
                        p.write(10);
                    }
                }
                finally {
                    if (this.pw == null) {
                        p.close();
                    }
                }
                // ** MonitorExit[var3_3] (shouldn't be in output)
            }
        }
        catch (IOException iOException) {}
        {
            return;
        }
    }
}

