/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.commons.util.io;

import com.ibm.commons.Platform;
import com.ibm.commons.util.StringUtil;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;

public class TextOutputStream
extends OutputStream {
    private boolean newLine;
    private int indentLevel;
    private int indentLength;
    private OutputStream os;
    private String lineSeparator;

    public TextOutputStream(OutputStream os) {
        this.os = os;
        this.newLine = true;
        this.indentLength = 2;
        this.lineSeparator = System.getProperty("line.separator");
    }

    public void incIndent() {
        ++this.indentLevel;
    }

    public void decIndent() {
        --this.indentLevel;
    }

    @Override
    public void flush() throws IOException {
        this.os.flush();
    }

    public void flushNoException() {
        try {
            this.os.flush();
        }
        catch (IOException ex) {
            Platform.getInstance().log(ex);
        }
    }

    @Override
    public void close() throws IOException {
        this.os.close();
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        int i = off;
        while (i < off + len) {
            this.outchar((char)b[i]);
            ++i;
        }
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    @Override
    public void write(int b) throws IOException {
        this.outchar((char)b);
    }

    public void write(char[] cbuf, int off, int len) throws IOException {
        int i = off;
        while (i < off + len) {
            this.outchar(cbuf[i]);
            ++i;
        }
    }

    public void println() throws IOException {
        this.outchar('\n');
    }

    public void println(char c) throws IOException {
        this.outchar(c);
        this.outchar('\n');
    }

    public void println(String msg) throws IOException {
        this.outstr(msg);
        this.outchar('\n');
    }

    public void println(String fmt, Object ... parameters) throws IOException {
        String msg = StringUtil.format(fmt, parameters);
        this.outstr(msg);
        this.outchar('\n');
    }

    public void print(char c) throws IOException {
        this.outchar(c);
    }

    public void print(String msg) throws IOException {
        this.outstr(msg);
    }

    public void print(String fmt, Object ... parameters) throws IOException {
        String msg = StringUtil.format(fmt, parameters);
        this.outstr(msg);
    }

    public void trace(String fmt, Object ... parameters) {
        try {
            String msg = StringUtil.format(fmt, parameters);
            this.outstr(msg);
            this.outchar('\n');
        }
        catch (IOException ex) {
            Platform.getInstance().log(ex);
        }
    }

    public void exception(Throwable ex) {
        PrintWriter pw = new PrintWriter(this);
        ex.printStackTrace(pw);
        pw.flush();
    }

    private void outstr(CharSequence s) throws IOException {
        int count = s.length();
        int i = 0;
        while (i < count) {
            char c = s.charAt(i);
            this.outchar(c);
            ++i;
        }
    }

    private void outchar(char c) throws IOException {
        if (c == '\n') {
            this.newLine = true;
            this._writestr(this.lineSeparator);
        } else {
            if (this.newLine) {
                if (this.indentLevel > 0) {
                    this._writestr(TextOutputStream.spaces(this.indentLength * this.indentLevel));
                }
                this.newLine = false;
            }
            this.os.write(c);
        }
    }

    private void _writestr(String s) throws IOException {
        int count = s.length();
        int i = 0;
        while (i < count) {
            this.os.write(s.charAt(i));
            ++i;
        }
    }

    public static String spaces(int count) {
        switch (count) {
            case 0: {
                return "";
            }
            case 1: {
                return " ";
            }
            case 2: {
                return "  ";
            }
            case 3: {
                return "   ";
            }
            case 4: {
                return "    ";
            }
            case 5: {
                return "     ";
            }
            case 6: {
                return "      ";
            }
            case 7: {
                return "       ";
            }
            case 8: {
                return "        ";
            }
        }
        return StringUtil.repeat(' ', count);
    }
}

