/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.commons.util.io;

import com.ibm.commons.util.FastStringBuffer;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;

public class StreamUtil {
    public static OutputStream close(OutputStream s) {
        if (s != null) {
            try {
                s.close();
            }
            catch (IOException iOException) {}
        }
        return null;
    }

    public static InputStream close(InputStream s) {
        if (s != null) {
            try {
                s.close();
            }
            catch (IOException iOException) {}
        }
        return null;
    }

    public static Writer close(Writer w) {
        if (w != null) {
            try {
                w.close();
            }
            catch (IOException iOException) {}
        }
        return null;
    }

    public static Reader close(Reader r) {
        if (r != null) {
            try {
                r.close();
            }
            catch (IOException iOException) {}
        }
        return null;
    }

    public static long copyStream(InputStream is, OutputStream os) throws IOException {
        return StreamUtil.copyStream(is, os, 8192);
    }

    public static long copyStream(InputStream is, OutputStream os, int bufferSize) throws IOException {
        int readBytes;
        byte[] buffer = new byte[bufferSize];
        long totalBytes = 0L;
        while ((readBytes = is.read(buffer)) > 0) {
            os.write(buffer, 0, readBytes);
            totalBytes += (long)readBytes;
        }
        return totalBytes;
    }

    public static long copyStream(Reader is, Writer os) throws IOException {
        return StreamUtil.copyStream(is, os, 8192);
    }

    public static long copyStream(Reader is, Writer os, int bufferSize) throws IOException {
        int readBytes;
        char[] buffer = new char[bufferSize];
        long totalBytes = 0L;
        while ((readBytes = is.read(buffer)) > 0) {
            os.write(buffer, 0, readBytes);
            totalBytes += (long)readBytes;
        }
        return totalBytes;
    }

    public static String readUTF(ObjectInput in) throws IOException {
        boolean isnull = in.readBoolean();
        return isnull ? null : in.readUTF();
    }

    public static void writeUTF(ObjectOutput out, String s) throws IOException {
        if (s == null) {
            out.writeBoolean(true);
        } else {
            out.writeBoolean(false);
            out.writeUTF(s);
        }
    }

    public static String readString(Reader reader) throws IOException {
        FastStringBuffer sb = new FastStringBuffer();
        sb.load(reader);
        return sb.toString();
    }

    public static String readString(InputStream is) throws IOException {
        FastStringBuffer sb = new FastStringBuffer();
        sb.load(new InputStreamReader(is));
        return sb.toString();
    }

    public static String readString(InputStream is, String encoding) throws IOException {
        FastStringBuffer sb = new FastStringBuffer();
        sb.load(new InputStreamReader(is, encoding));
        return sb.toString();
    }

    public static int fillBuffer(byte[] buffer, InputStream is) throws IOException {
        int r;
        int pos = 0;
        do {
            if ((r = is.read(buffer, pos, buffer.length - pos)) <= 0) continue;
            pos += r;
        } while (r > 0 && r < buffer.length);
        return pos;
    }
}

