/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.commons.util.io;

import com.ibm.commons.util.StringUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;

public class ReaderInputStream
extends InputStream {
    private Reader _in;
    private String _encoding = System.getProperty("file.encoding");
    private byte[] _slack;
    private int _begin;
    private static final String s_streamClosedMessage = "Stream closed.";

    public ReaderInputStream(Reader reader) {
        this._in = reader;
    }

    public ReaderInputStream(Reader reader, String encoding) {
        this(reader);
        if (StringUtil.isNotEmpty(encoding)) {
            this._encoding = encoding;
        }
    }

    @Override
    public int read() throws IOException {
        int result;
        if (this._in == null) {
            throw new IOException(s_streamClosedMessage);
        }
        if (this._slack != null && this._begin < this._slack.length) {
            result = this._slack[this._begin];
            if (++this._begin == this._slack.length) {
                this._slack = null;
            }
        } else {
            byte[] buf = new byte[1];
            if (this.read(buf, 0, 1) <= 0) {
                result = -1;
            }
            result = buf[0];
        }
        if (result < -1) {
            result = (byte)(result + 256);
        }
        return result;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (this._in != null) ** GOTO lbl10
        throw new IOException("Stream closed.");
lbl-1000:
        // 1 sources

        {
            buf = new char[len];
            n = this._in.read(buf);
            if (n == -1) {
                return -1;
            }
            if (n <= 0) continue;
            this._slack = new String(buf, 0, n).getBytes(this._encoding);
            this._begin = 0;
lbl10:
            // 3 sources

            ** while (this._slack == null)
        }
lbl11:
        // 1 sources

        if (len > this._slack.length - this._begin) {
            len = this._slack.length - this._begin;
        }
        System.arraycopy(this._slack, this._begin, b, off, len);
        if ((this._begin += len) >= this._slack.length) {
            this._slack = null;
        }
        return len;
    }

    @Override
    public void mark(int limit) {
        try {
            this._in.mark(limit);
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe.getMessage());
        }
    }

    @Override
    public int available() throws IOException {
        if (this._in == null) {
            throw new IOException(s_streamClosedMessage);
        }
        if (this._slack != null) {
            return this._slack.length - this._begin;
        }
        if (this._in.ready()) {
            return 1;
        }
        return 0;
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public void reset() throws IOException {
        if (this._in == null) {
            throw new IOException(s_streamClosedMessage);
        }
        this._slack = null;
        this._in.reset();
    }

    @Override
    public void close() throws IOException {
        if (this._in == null) {
            return;
        }
        this._in.close();
        this._slack = null;
        this._in = null;
    }
}

