/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.commons.util.io;

import com.ibm.commons.util.FastStringBuffer;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;

public class LookAheadReader
extends Reader {
    private Reader reader;
    private char[] buffer;
    private int count;
    private int position;
    private boolean eof;
    private int index;

    public LookAheadReader(Reader reader, int bufferLength) {
        this.reader = reader;
        this.buffer = new char[bufferLength];
        this.position = 0;
        this.count = 0;
        this.eof = false;
        this.index = 0;
    }

    public int getBufferLength() {
        return this.buffer.length;
    }

    @Override
    public final int read() throws IOException {
        if (this.count == 0 && !this.readData(1)) {
            return -1;
        }
        --this.count;
        ++this.index;
        return this.buffer[this.position++];
    }

    public final int readCDATABase64() throws IOException {
        if (this.count == 0 && !this.readData(1)) {
            return -1;
        }
        char c = this.buffer[this.position];
        if (c == ']') {
            return -1;
        }
        ++this.position;
        --this.count;
        return c;
    }

    public final int readCDATABase64Bytes(byte[] b) throws IOException {
        return this.readCDATABase64Bytes(b, 0, b.length);
    }

    public final int readCDATABase64Bytes(byte[] b, int off, int len) throws IOException {
        if (this.count == 0 && !this.readData(1)) {
            return -1;
        }
        int max = Math.min(len, this.count);
        int i = 0;
        while (i < max) {
            char c = this.buffer[this.position + i];
            if (c == ']') {
                this.position += i;
                this.count -= i;
                return i;
            }
            b[i + off] = (byte)c;
            ++i;
        }
        this.position += max;
        this.count -= max;
        return max;
    }

    @Override
    public int read(char[] cbuf, int off, int len) throws IOException {
        if (len > 0) {
            if (this.count == 0 && !this.readData(1)) {
                return -1;
            }
            int n = Math.min(len, this.count);
            if (cbuf != null) {
                System.arraycopy(this.buffer, this.position, cbuf, off, n);
            }
            this.position += n;
            this.count -= n;
            this.index += n;
            return n;
        }
        return 0;
    }

    @Override
    public long skip(long len) throws IOException {
        if (len > 0L) {
            if (len == 1L) {
                this.read();
                return 1L;
            }
            return this.read(null, 0, (int)len);
        }
        return 0L;
    }

    @Override
    public void close() throws IOException {
        this.reader.close();
    }

    public int getCurrentIndex() {
        return this.index;
    }

    private boolean readData(int minData) throws IOException {
        if (this.eof) {
            return false;
        }
        if (this.count > 0) {
            System.arraycopy(this.buffer, this.position, this.buffer, 0, this.count);
        }
        this.position = 0;
        while (this.count < minData) {
            int r = this.readBuffer(this.buffer, this.count, this.buffer.length - this.count);
            if (r <= 0) {
                this.eof = true;
                return false;
            }
            this.count += r;
        }
        return true;
    }

    protected int readBuffer(char[] buffer, int position, int count) throws IOException {
        return this.reader.read(buffer, position, count);
    }

    public boolean hasChar() throws IOException {
        return this.count != 0 || this.readData(1);
    }

    public final int getCharAt(int pos) throws IOException {
        if (pos >= this.count && !this.readData(pos + 1)) {
            return -1;
        }
        return this.buffer[this.position + pos];
    }

    public final int getChar() throws IOException {
        if (this.count == 0 && !this.readData(1)) {
            return -1;
        }
        return this.buffer[this.position];
    }

    public String getStringAhead(int maxChars) throws IOException {
        if (maxChars > this.count) {
            this.readData(maxChars);
        }
        char[] c = new char[Math.min(maxChars, this.count)];
        int i = 0;
        while (i < c.length) {
            c[i] = this.buffer[this.position + i];
            ++i;
        }
        return new String(c);
    }

    public boolean startsWith(char c) throws IOException {
        return this.getChar() == c;
    }

    public boolean startsWithIgnoreCase(char c) throws IOException {
        return Character.toLowerCase((char)this.getCharAt(0)) == Character.toLowerCase(c);
    }

    public boolean startsWith(String s) throws IOException {
        int length = s.length();
        if (length > this.count && !this.readData(length)) {
            return false;
        }
        int i = 0;
        while (i < length) {
            if (this.buffer[this.position + i] != s.charAt(i)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean startsWithIgnoreCase(String s) throws IOException {
        int length = s.length();
        if (length > this.count && !this.readData(length)) {
            return false;
        }
        int i = 0;
        while (i < length) {
            if (Character.toLowerCase(this.buffer[this.position + i]) != Character.toLowerCase(s.charAt(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean match(char c) throws IOException {
        if (this.startsWith(c)) {
            --this.count;
            ++this.index;
            ++this.position;
            return true;
        }
        return false;
    }

    public boolean matchIgnoreCase(char c) throws IOException {
        if (this.startsWithIgnoreCase(c)) {
            --this.count;
            ++this.index;
            ++this.position;
            return true;
        }
        return false;
    }

    public boolean match(String s) throws IOException {
        if (this.startsWith(s)) {
            int len = s.length();
            this.count -= len;
            this.index += len;
            this.position += len;
            return true;
        }
        return false;
    }

    public boolean matchIgnoreCase(String s) throws IOException {
        if (this.startsWithIgnoreCase(s)) {
            int len = s.length();
            this.count -= len;
            this.index += len;
            this.position += len;
            return true;
        }
        return false;
    }

    public boolean skipBlanks(FastStringBuffer b) throws IOException {
        int c = this.getChar();
        if (c == 32 || c == 9 || c == 10 || c == 13) {
            b.append((char)c);
            --this.count;
            ++this.index;
            ++this.position;
            while (true) {
                if ((c = this.getChar()) != 32 && c != 9 && c != 10 && c != 13) {
                    return true;
                }
                b.append((char)c);
                --this.count;
                ++this.index;
                ++this.position;
            }
        }
        return false;
    }

    public boolean skipBlanks() throws IOException {
        int c = this.getChar();
        if (c == 32 || c == 9 || c == 10 || c == 13) {
            --this.count;
            ++this.index;
            ++this.position;
            while (true) {
                if ((c = this.getChar()) != 32 && c != 9 && c != 10 && c != 13) {
                    return true;
                }
                --this.count;
                ++this.index;
                ++this.position;
            }
        }
        return false;
    }

    public void skipUpto(char c) throws IOException {
        int cc;
        while ((cc = this.getChar()) >= 0 && cc != c) {
            --this.count;
            ++this.index;
            ++this.position;
        }
        return;
    }

    public void skipUpto(String s) throws IOException {
        while (true) {
            char firstChar = s.charAt(0);
            int cc = this.getChar();
            if (cc < 0 || cc == firstChar && this.startsWith(s)) {
                return;
            }
            --this.count;
            ++this.index;
            ++this.position;
        }
    }

    public void skipUptoEOL() throws IOException {
        int cc;
        while ((cc = this.getChar()) >= 0 && cc != 10 && cc != 13) {
            --this.count;
            ++this.index;
            ++this.position;
        }
        return;
    }

    public String upto(char c) throws IOException {
        StringBuilder b = new StringBuilder();
        int cc;
        while ((cc = this.getChar()) >= 0 && cc != c) {
            b.append((char)cc);
            --this.count;
            ++this.index;
            ++this.position;
        }
        return b.toString();
    }

    public void copy(Writer w) throws IOException {
        int r;
        char[] b = new char[1024];
        while ((r = this.read(b, 0, b.length)) > 0) {
            w.write(b, 0, r);
        }
    }
}

