/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.commons.util.io;

import com.ibm.commons.util.FastStringBuffer;
import java.io.IOException;
import java.io.InputStream;

public class LookAheadInputStream
extends InputStream {
    private InputStream is;
    private byte[] buffer;
    private int count;
    private int position;
    private boolean eof;
    private int index;

    public LookAheadInputStream(InputStream is, int bufferLength) {
        this.is = is;
        this.buffer = new byte[bufferLength];
        this.position = 0;
        this.count = 0;
        this.eof = false;
        this.index = 0;
    }

    public int getBufferLength() {
        return this.buffer.length;
    }

    @Override
    public final int read() throws IOException {
        if (this.count == 0 && !this.readData(1)) {
            return -1;
        }
        --this.count;
        ++this.index;
        return this.buffer[this.position++];
    }

    @Override
    public int read(byte[] cbuf, int off, int len) throws IOException {
        if (len > 0) {
            if (this.count == 0 && !this.readData(1)) {
                return -1;
            }
            int n = Math.min(len, this.count);
            if (cbuf != null) {
                System.arraycopy(this.buffer, this.position, cbuf, off, n);
            }
            this.position += n;
            this.count -= n;
            this.index += n;
            return n;
        }
        return 0;
    }

    @Override
    public long skip(long len) throws IOException {
        if (len > 0L) {
            if (len == 1L) {
                this.read();
                return 1L;
            }
            return this.read(null, 0, (int)len);
        }
        return 0L;
    }

    @Override
    public void close() throws IOException {
        this.is.close();
    }

    public int getCurrentIndex() {
        return this.index;
    }

    private boolean readData(int minData) throws IOException {
        if (this.eof) {
            return false;
        }
        if (this.count > 0) {
            System.arraycopy(this.buffer, this.position, this.buffer, 0, this.count);
        }
        this.position = 0;
        while (this.count < minData) {
            int r = this.readBuffer(this.buffer, this.count, this.buffer.length - this.count);
            if (r <= 0) {
                this.eof = true;
                return false;
            }
            this.count += r;
        }
        return true;
    }

    protected int readBuffer(byte[] buffer, int position, int count) throws IOException {
        return this.is.read(buffer, position, count);
    }

    public boolean hasByte() throws IOException {
        return this.count != 0 || this.readData(1);
    }

    public final int getByteAt(int pos) throws IOException {
        if (pos >= this.count && !this.readData(pos + 1)) {
            return -1;
        }
        return this.buffer[this.position + pos] & 0xFF;
    }

    public final int getByte() throws IOException {
        if (this.count == 0 && !this.readData(1)) {
            return -1;
        }
        return this.buffer[this.position] & 0xFF;
    }

    public byte[] getByteAhead(int maxChars) throws IOException {
        if (maxChars > this.count) {
            this.readData(maxChars);
        }
        byte[] c = new byte[Math.min(maxChars, this.count)];
        int i = 0;
        while (i < c.length) {
            c[i] = this.buffer[this.position + i];
            ++i;
        }
        return c;
    }

    public char getChar() throws IOException {
        return (char)this.getByte();
    }

    public char getCharAt(int index) throws IOException {
        return (char)this.getByteAt(index);
    }

    public boolean startsWith(char c) throws IOException {
        return this.getChar() == c;
    }

    public boolean startsWithIgnoreCase(char c) throws IOException {
        return Character.toLowerCase(this.getCharAt(0)) == Character.toLowerCase(c);
    }

    public boolean startsWith(String s) throws IOException {
        int length = s.length();
        if (length > this.count && !this.readData(length)) {
            return false;
        }
        int i = 0;
        while (i < length) {
            if (this.buffer[this.position + i] != s.charAt(i)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean startsWithIgnoreCase(String s) throws IOException {
        int length = s.length();
        if (length > this.count && !this.readData(length)) {
            return false;
        }
        int i = 0;
        while (i < length) {
            if (Character.toLowerCase((char)this.buffer[this.position + i]) != Character.toLowerCase(s.charAt(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean match(char c) throws IOException {
        if (this.startsWith(c)) {
            --this.count;
            ++this.index;
            ++this.position;
            return true;
        }
        return false;
    }

    public boolean matchIgnoreCase(char c) throws IOException {
        if (this.startsWithIgnoreCase(c)) {
            --this.count;
            ++this.index;
            ++this.position;
            return true;
        }
        return false;
    }

    public boolean match(String s) throws IOException {
        if (this.startsWith(s)) {
            int len = s.length();
            this.count -= len;
            this.index += len;
            this.position += len;
            return true;
        }
        return false;
    }

    public boolean matchIgnoreCase(String s) throws IOException {
        if (this.startsWithIgnoreCase(s)) {
            int len = s.length();
            this.count -= len;
            this.index += len;
            this.position += len;
            return true;
        }
        return false;
    }

    public boolean skipBlanks(FastStringBuffer b) throws IOException {
        char c = this.getChar();
        if (c == ' ' || c == '\t' || c == '\n' || c == '\r') {
            b.append(c);
            --this.count;
            ++this.index;
            ++this.position;
            while (true) {
                if ((c = this.getChar()) != ' ' && c != '\t' && c != '\n' && c != '\r') {
                    return true;
                }
                b.append(c);
                --this.count;
                ++this.index;
                ++this.position;
            }
        }
        return false;
    }

    public boolean skipBlanks() throws IOException {
        char c = this.getChar();
        if (c == ' ' || c == '\t' || c == '\n' || c == '\r') {
            --this.count;
            ++this.index;
            ++this.position;
            while (true) {
                if ((c = this.getChar()) != ' ' && c != '\t' && c != '\n' && c != '\r') {
                    return true;
                }
                --this.count;
                ++this.index;
                ++this.position;
            }
        }
        return false;
    }

    public void skipUpto(char c) throws IOException {
        char cc;
        while ((cc = this.getChar()) >= '\u0000' && cc != c) {
            --this.count;
            ++this.index;
            ++this.position;
        }
        return;
    }

    public String upto(char c) throws IOException {
        FastStringBuffer b = new FastStringBuffer();
        char cc;
        while ((cc = this.getChar()) >= '\u0000' && cc != c) {
            b.append((int)cc);
            --this.count;
            ++this.index;
            ++this.position;
        }
        return b.toString();
    }
}

