/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.commons.util.io;

import java.io.IOException;
import java.io.Reader;

public class FastStringReader
extends Reader {
    private String s;
    private int pos;
    private int length;

    public FastStringReader(String s) {
        this.s = s;
        this.length = s.length();
    }

    @Override
    public int read() throws IOException {
        if (this.pos < this.length) {
            return this.s.charAt(this.pos++);
        }
        return -1;
    }

    @Override
    public int read(char[] cbuf, int off, int len) throws IOException {
        if (this.pos < this.length) {
            int count = Math.min(len, this.length - this.pos);
            this.s.getChars(this.pos, this.pos + count, cbuf, off);
            this.pos += count;
            return count;
        }
        return -1;
    }

    @Override
    public long skip(long n) throws IOException {
        int skip = Math.min(this.pos + (int)n, this.length) - this.pos;
        this.pos += skip;
        return skip;
    }

    @Override
    public boolean ready() throws IOException {
        return true;
    }

    @Override
    public void close() throws IOException {
    }
}

