/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.commons.util.io;

import java.io.IOException;
import java.io.OutputStream;

public class FastBufferedOutputStream
extends OutputStream {
    private static final int DEFAULT_BUFFER_SIZE = 16384;
    private OutputStream os;
    private byte[] buffer;
    private int bufferLength;
    private int pos;

    public static OutputStream get(OutputStream source) {
        return source != null ? new FastBufferedOutputStream(source) : null;
    }

    public FastBufferedOutputStream(OutputStream os, int size) {
        this.os = os;
        this.bufferLength = size;
        this.buffer = new byte[size];
    }

    public FastBufferedOutputStream(OutputStream os) {
        this(os, 16384);
    }

    @Override
    public void write(int b) throws IOException {
        if (this.pos == this.bufferLength) {
            this.os.write(this.buffer, 0, this.bufferLength);
            this.pos = 0;
        }
        this.buffer[this.pos++] = (byte)b;
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        while (len > 0) {
            int avail;
            if (this.pos == this.bufferLength) {
                this.os.write(this.buffer, 0, this.bufferLength);
                this.pos = 0;
            }
            int toWrite = len > (avail = this.bufferLength - this.pos) ? avail : len;
            System.arraycopy(b, off, this.buffer, this.pos, toWrite);
            this.pos += toWrite;
            off += toWrite;
            len -= toWrite;
        }
    }

    @Override
    public void flush() throws IOException {
        if (this.pos > 0) {
            this.os.write(this.buffer, 0, this.pos);
            this.pos = 0;
        }
        this.os.flush();
    }

    @Override
    public void close() throws IOException {
        if (this.pos > 0) {
            this.os.write(this.buffer, 0, this.pos);
            this.pos = 0;
        }
        this.os.close();
    }
}

