/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.commons.util.io;

import java.io.IOException;
import java.io.InputStream;

public class FastBufferedInputStream
extends InputStream {
    private static final int DEFAULT_BUFFER_SIZE = 16384;
    private static final boolean FORCE_READ = false;
    private InputStream is;
    private byte[] buffer;
    private int count;
    private int pos;

    public static InputStream get(InputStream source) {
        return source != null ? new FastBufferedInputStream(source) : null;
    }

    public FastBufferedInputStream(InputStream is, int size) {
        this.is = is;
        this.buffer = new byte[size];
    }

    public FastBufferedInputStream(InputStream is) {
        this(is, 16384);
    }

    public boolean isEOF() throws IOException {
        if (this.pos == this.count) {
            this.count = this.is.read(this.buffer, 0, this.buffer.length);
            this.pos = 0;
            if (this.count < 0) {
                this.count = 0;
                return true;
            }
        }
        return false;
    }

    @Override
    public int read() throws IOException {
        if (this.pos == this.count) {
            this.count = this.is.read(this.buffer, 0, this.buffer.length);
            this.pos = 0;
            if (this.count < 0) {
                this.count = 0;
                return -1;
            }
        }
        return this.buffer[this.pos++] & 0xFF;
    }

    @Override
    public int read(byte[] array) throws IOException {
        return this.read(array, 0, array.length);
    }

    @Override
    public int read(byte[] array, int off, int length) throws IOException {
        return this._read(array, off, length);
    }

    private int _read(byte[] array, int off, int length) throws IOException {
        int avail = this.count - this.pos;
        if (avail == 0) {
            avail = this.count = this.is.read(this.buffer, 0, this.buffer.length);
            this.pos = 0;
            if (this.count < 0) {
                this.count = 0;
                return -1;
            }
        }
        int toRead = length < avail ? length : avail;
        System.arraycopy(this.buffer, this.pos, array, off, toRead);
        this.pos += toRead;
        return toRead;
    }

    @Override
    public long skip(long n) throws IOException {
        return this._skip(n);
    }

    private long _skip(long n) throws IOException {
        int avail = this.count - this.pos;
        if (avail > 0) {
            if (n < (long)avail) {
                this.pos = (int)((long)this.pos + n);
                return n;
            }
            this.pos = this.count;
            return avail;
        }
        return this.is.skip(n);
    }

    @Override
    public int available() throws IOException {
        return this.is.available() + (this.count - this.pos);
    }

    @Override
    public void close() throws IOException {
        this.is.close();
    }

    @Override
    public void mark(int int0) {
    }

    @Override
    public void reset() throws IOException {
    }

    @Override
    public boolean markSupported() {
        return false;
    }
}

