/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.commons.util.io;

import com.ibm.commons.util.io.FastBufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.OutputStream;

public class ByteStreamCache {
    public static final int DEFAULT_BLOCKSIZE = 8192;
    public static final int DEFAULT_THRESHOLD = 32;
    private int blockSize;
    private int threshold;
    private int nBlock;
    private Block firstBlock;
    private Block lastBlock;

    public ByteStreamCache() {
        this.blockSize = 8192;
        this.threshold = 32;
        this.nBlock = 1;
        this.firstBlock = this.lastBlock = new Block(this.blockSize);
    }

    public ByteStreamCache(int blockSize) {
        this.blockSize = blockSize;
        this.threshold = 32;
        this.nBlock = 1;
        this.firstBlock = this.lastBlock = new Block(blockSize);
    }

    public ByteStreamCache(int blockSize, int threshold) {
        this.blockSize = blockSize;
        this.threshold = threshold;
        this.nBlock = 1;
        this.firstBlock = this.lastBlock = new Block(blockSize);
    }

    public boolean isEqual(ByteStreamCache other) {
        long l2;
        long l1;
        if (this.blockSize == other.blockSize && (l1 = this.getLength()) == (l2 = other.getLength())) {
            Block b1 = this.firstBlock;
            Block b2 = other.firstBlock;
            while (b1 != null && b2 != null) {
                int count = b1.count;
                int i = 0;
                while (i < count) {
                    if (b1.data[i] != b2.data[i]) {
                        return false;
                    }
                    ++i;
                }
                b1 = b1.next;
                b2 = b2.next;
            }
            return true;
        }
        return false;
    }

    public long getLength() {
        return (this.nBlock - 1) * this.blockSize + this.lastBlock.count;
    }

    public byte getByte(int pos) {
        Block b = this.firstBlock;
        while (pos > this.blockSize) {
            b = b.next;
            pos -= this.blockSize;
        }
        return b.data[pos];
    }

    public void clear() {
        this.nBlock = 1;
        this.firstBlock = this.lastBlock = new Block(this.blockSize);
    }

    public InputStream getInputStream() {
        return new InternalInputStream();
    }

    public OutputStream getOutputStream() {
        return new InternalOutputStream();
    }

    public void copyFrom(InputStream is) throws IOException {
        while (true) {
            int read;
            if (this.lastBlock.count == this.blockSize) {
                this.addNewBlock();
            }
            if ((read = is.read(this.lastBlock.data, this.lastBlock.count, this.blockSize - this.lastBlock.count)) < 0) {
                return;
            }
            this.lastBlock.count += read;
        }
    }

    public void copyFrom(InputStream is, int maxRead) throws IOException {
        while (maxRead > 0) {
            int toRead;
            int read;
            if (this.lastBlock.count == this.blockSize) {
                this.addNewBlock();
            }
            if ((read = is.read(this.lastBlock.data, this.lastBlock.count, toRead = Math.min(maxRead, this.blockSize - this.lastBlock.count))) < 0) {
                return;
            }
            this.lastBlock.count += read;
            maxRead -= read;
        }
    }

    public void copyFrom(ObjectInput is) throws IOException {
        while (true) {
            int read;
            if (this.lastBlock.count == this.blockSize) {
                this.addNewBlock();
            }
            if ((read = is.read(this.lastBlock.data, this.lastBlock.count, this.blockSize - this.lastBlock.count)) < 0) {
                return;
            }
            this.lastBlock.count += read;
        }
    }

    public void copyFrom(ObjectInput is, int maxRead) throws IOException {
        while (maxRead > 0) {
            int toRead;
            int read;
            if (this.lastBlock.count == this.blockSize) {
                this.addNewBlock();
            }
            if ((read = is.read(this.lastBlock.data, this.lastBlock.count, toRead = Math.min(maxRead, this.blockSize - this.lastBlock.count))) < 0) {
                return;
            }
            this.lastBlock.count += read;
            maxRead -= read;
        }
    }

    public void copyTo(OutputStream os) throws IOException {
        Block b = this.firstBlock;
        while (b != null) {
            os.write(b.data, 0, b.count);
            b = b.next;
        }
    }

    public void copyTo(ObjectOutput os) throws IOException {
        Block b = this.firstBlock;
        while (b != null) {
            os.write(b.data, 0, b.count);
            b = b.next;
        }
    }

    public void copyTo(File f) throws IOException {
        FastBufferedOutputStream os = new FastBufferedOutputStream(new FileOutputStream(f));
        try {
            this.copyTo(os);
        }
        finally {
            ((OutputStream)os).close();
        }
    }

    public byte[] toByteArray() {
        int length = (int)this.getLength();
        byte[] result = new byte[length];
        int pos = 0;
        Block b = this.firstBlock;
        while (b != null) {
            System.arraycopy(b.data, 0, result, pos, b.count);
            pos += b.count;
            b = b.next;
        }
        return result;
    }

    private final void addNewBlock() {
        Block b;
        this.lastBlock.next = b = new Block(this.blockSize);
        this.lastBlock = b;
        ++this.nBlock;
    }

    public final void write(int b) throws IOException {
        if (this.lastBlock.count == this.blockSize) {
            this.addNewBlock();
        }
        this.lastBlock.data[this.lastBlock.count++] = (byte)b;
    }

    public final void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    public final void write(byte[] b, int off, int len) throws IOException {
        while (len > 0) {
            int max = Math.min(len, this.blockSize - this.lastBlock.count);
            if (max == 0) {
                this.addNewBlock();
                max = Math.min(len, this.blockSize);
            }
            System.arraycopy(b, off, this.lastBlock.data, this.lastBlock.count, max);
            this.lastBlock.count += max;
            len -= max;
            off += max;
        }
    }

    private static class Block {
        Block next;
        int count;
        byte[] data;

        Block(int blockSize) {
            this.data = new byte[blockSize];
        }
    }

    protected class InternalInputStream
    extends InputStream {
        private int currentPosition;
        private Block currentBlock;

        protected InternalInputStream() {
            this.currentBlock = ByteStreamCache.this.firstBlock;
        }

        @Override
        public void close() throws IOException {
        }

        @Override
        public int read() throws IOException {
            if (this.currentBlock != null) {
                if (!(this.currentPosition < this.currentBlock.count || this.nextBlock() && this.currentBlock.count != 0)) {
                    return -1;
                }
                return this.currentBlock.data[this.currentPosition++] & 0xFF;
            }
            return -1;
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            if (this.currentBlock != null) {
                if (!(this.currentPosition < this.currentBlock.count || this.nextBlock() && this.currentBlock.count != 0)) {
                    return -1;
                }
                int read = Math.min(len, this.currentBlock.count - this.currentPosition);
                System.arraycopy(this.currentBlock.data, this.currentPosition, b, off, read);
                this.currentPosition += read;
                return read;
            }
            return -1;
        }

        private boolean nextBlock() {
            if (this.currentBlock != null) {
                this.currentBlock = this.currentBlock.next;
                this.currentPosition = 0;
            }
            return this.currentBlock != null;
        }

        @Override
        public long skip(long n) throws IOException {
            if (this.currentBlock != null) {
                if (this.currentPosition >= this.currentBlock.count && !this.nextBlock()) {
                    return -1L;
                }
                int toSkip = Math.min((int)n, this.currentBlock.count - this.currentPosition);
                this.currentPosition += toSkip;
                return toSkip;
            }
            return -1L;
        }

        @Override
        public int available() throws IOException {
            if (this.currentBlock != null) {
                if (this.currentBlock.count - this.currentPosition > 0) {
                    return this.currentBlock.count - this.currentPosition;
                }
                return this.currentBlock.next == null ? 0 : this.currentBlock.count;
            }
            return 0;
        }
    }

    protected class InternalOutputStream
    extends OutputStream {
        protected InternalOutputStream() {
        }

        @Override
        public void write(int b) throws IOException {
            ByteStreamCache.this.write(b);
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            ByteStreamCache.this.write(b, off, len);
        }

        @Override
        public void flush() throws IOException {
        }

        @Override
        public void close() throws IOException {
        }
    }
}

