/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.commons.util;

public class ThreadMap {
    private Item firstItem;

    public boolean hasItems() {
        return this.firstItem != null;
    }

    public synchronized void clear() {
        this.firstItem = null;
    }

    public synchronized void remove(Thread thread) {
        if (this.firstItem != null) {
            if (this.firstItem.thread == thread) {
                this.firstItem = this.firstItem.next;
            } else {
                Item it = this.firstItem;
                while (it.next != null) {
                    if (it.next.thread == thread) {
                        it.next = it.next.next;
                        break;
                    }
                    it = it.next;
                }
            }
            return;
        }
    }

    public Object get(Thread thread) {
        Item it = this.firstItem;
        while (it != null) {
            if (it.thread == thread) {
                return it.object;
            }
            it = it.next;
        }
        return null;
    }

    public synchronized void put(Thread thread, Object object) {
        if (object != null) {
            Item it = this.firstItem;
            while (it != null) {
                if (it.thread == thread) {
                    it.object = object;
                    return;
                }
                it = it.next;
            }
            Item item = new Item(thread, object);
            item.next = this.firstItem;
            this.firstItem = item;
        } else {
            this.remove(thread);
        }
    }

    private static class Item {
        private Item next;
        private Thread thread;
        private Object object;

        Item(Thread thread, Object object) {
            this.thread = thread;
            this.object = object;
        }
    }
}

