/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.commons.util;

import com.ibm.commons.util.ThreadLock;

public class ThreadLockManager {
    protected int activeReaders = 0;
    protected int activeWriters = 0;
    protected int waitingReaders = 0;
    protected int waitingWriters = 0;
    private final RLock rLock = new RLock(null);
    private final WLock wLock = new WLock(null);

    protected boolean allowReader(Object param) {
        return this.waitingWriters == 0 && this.activeWriters == 0;
    }

    protected boolean allowWriter(Object param) {
        return this.activeReaders == 0 && this.activeWriters == 0;
    }

    protected synchronized void beforeRead(Object param) throws InterruptedException {
        ++this.waitingReaders;
        while (!this.allowReader(param)) {
            try {
                this.waitForRead(param);
            }
            catch (InterruptedException e) {
                --this.waitingReaders;
                throw e;
            }
        }
        --this.waitingReaders;
        ++this.activeReaders;
    }

    protected void waitForRead(Object param) throws InterruptedException {
        this.wait();
    }

    protected synchronized boolean tryBeforeRead(Object param) throws InterruptedException {
        ++this.waitingReaders;
        try {
            if (this.allowReader(param)) {
                ++this.activeReaders;
                return true;
            }
        }
        finally {
            --this.waitingReaders;
        }
        return false;
    }

    protected synchronized void afterRead(Object param) {
        --this.activeReaders;
        this.notifyAll();
    }

    protected synchronized void beforeWrite(Object param) throws InterruptedException {
        ++this.waitingWriters;
        while (!this.allowWriter(param)) {
            try {
                this.waitForWrite(param);
            }
            catch (InterruptedException e) {
                --this.waitingWriters;
                throw e;
            }
        }
        --this.waitingWriters;
        ++this.activeWriters;
    }

    protected void waitForWrite(Object param) throws InterruptedException {
        this.wait();
    }

    protected synchronized boolean tryBeforeWrite(Object param) throws InterruptedException {
        ++this.waitingWriters;
        try {
            if (this.allowWriter(param)) {
                ++this.activeWriters;
                return true;
            }
        }
        finally {
            --this.waitingWriters;
        }
        return false;
    }

    protected synchronized void afterWrite(Object param) {
        --this.activeWriters;
        this.notifyAll();
    }

    public void read() throws InterruptedException {
        this.read(null);
    }

    public void read(Object param) throws InterruptedException {
        this.beforeRead(param);
        try {
            this.doRead();
        }
        finally {
            this.afterRead(param);
        }
    }

    public void write() throws InterruptedException {
        this.write(null);
    }

    public void write(Object param) throws InterruptedException {
        this.beforeWrite(param);
        try {
            this.doWrite();
        }
        finally {
            this.afterWrite(param);
        }
    }

    protected void doRead() {
    }

    protected void doWrite() {
    }

    public ThreadLock getReadLock() {
        return this.rLock;
    }

    public ThreadLock getReadLock(Object param) {
        return new RLock(param);
    }

    public ThreadLock getWriteLock() {
        return this.wLock;
    }

    public ThreadLock getWriteLock(Object param) {
        return new WLock(param);
    }

    private class RLock
    implements ThreadLock {
        private Object param;

        private RLock(Object param) {
            this.param = param;
        }

        @Override
        public boolean acquire() throws InterruptedException {
            ThreadLockManager.this.beforeRead(this.param);
            return true;
        }

        @Override
        public boolean tryAcquire() throws InterruptedException {
            return ThreadLockManager.this.tryBeforeRead(this.param);
        }

        @Override
        public void release() {
            ThreadLockManager.this.afterRead(this.param);
        }

        @Override
        public boolean isLocked() {
            return ThreadLockManager.this.allowReader(this.param);
        }
    }

    private class WLock
    implements ThreadLock {
        private Object param;

        private WLock(Object param) {
            this.param = param;
        }

        @Override
        public boolean acquire() throws InterruptedException {
            ThreadLockManager.this.beforeWrite(this.param);
            return true;
        }

        @Override
        public boolean tryAcquire() throws InterruptedException {
            return ThreadLockManager.this.tryBeforeWrite(this.param);
        }

        @Override
        public void release() {
            ThreadLockManager.this.afterWrite(this.param);
        }

        @Override
        public boolean isLocked() {
            return ThreadLockManager.this.allowWriter(this.param);
        }
    }
}

