/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.commons.util;

import com.ibm.commons.util.AbstractRuntimeException;
import com.ibm.commons.util.FastStringBuffer;
import com.ibm.commons.util.StringUtil;

public final class TextUtil {
    public static String indentString(String s, String indent) {
        if (!StringUtil.isEmpty(s) && !StringUtil.isEmpty(indent)) {
            FastStringBuffer buf = new FastStringBuffer();
            int i = 0;
            block0: while (i < s.length()) {
                buf.append(indent);
                while (i < s.length()) {
                    char c = s.charAt(i++);
                    buf.append(c);
                    if (c == '\n' || c == '\r' && (i >= s.length() - 1 || (c = s.charAt(i + 1)) != '\n')) continue block0;
                }
            }
            return buf.toString();
        }
        return s;
    }

    public static String fromJavaString(String s) {
        FastStringBuffer b = new FastStringBuffer();
        int len = s.length();
        int i = 0;
        while (i < len) {
            char c;
            if ((c = s.charAt(i++)) == '\\') {
                if (i >= len) continue;
                c = s.charAt(i++);
                switch (c) {
                    case 'b': {
                        b.append("\b");
                        break;
                    }
                    case 't': {
                        b.append("\t");
                        break;
                    }
                    case 'n': {
                        b.append("\n");
                        break;
                    }
                    case 'f': {
                        b.append("\f");
                        break;
                    }
                    case 'r': {
                        b.append("\r");
                        break;
                    }
                    case '\'': {
                        b.append("'");
                        break;
                    }
                    case '\"': {
                        b.append("\"");
                        break;
                    }
                    case '\\': {
                        b.append("\\");
                        break;
                    }
                    case 'u': {
                        int v = 0;
                        int j = 0;
                        while (j < 4) {
                            if (i < len) {
                                c = s.charAt(i++);
                                v = v * 16 + StringUtil.hexValue(c);
                            }
                            ++j;
                        }
                        b.append((char)v);
                        break;
                    }
                    default: {
                        b.append(c);
                        break;
                    }
                }
                continue;
            }
            b.append(c);
        }
        return b.toString();
    }

    public static String toJavaString(String s, boolean addQuotes) {
        FastStringBuffer b = new FastStringBuffer();
        b.appendJavaString(s, addQuotes);
        return b.toString();
    }

    public static String fromXMLString(String s) {
        FastStringBuffer b;
        block12: {
            if (s == null) {
                return null;
            }
            b = null;
            int pos = 0;
            int length = s.length();
            while (true) {
                int nextEntity;
                if ((nextEntity = s.indexOf(38, pos)) < 0) {
                    nextEntity = length;
                }
                if (nextEntity > pos) {
                    if (b == null) {
                        b = new FastStringBuffer();
                    }
                    b.append(s, pos, nextEntity);
                    pos = nextEntity;
                }
                if (pos >= length) break block12;
                if (b == null) {
                    b = new FastStringBuffer();
                }
                if (s.startsWith("amp;", ++pos)) {
                    b.append('&');
                    pos += 4;
                    continue;
                }
                if (s.startsWith("apos;", pos)) {
                    b.append('\'');
                    pos += 5;
                    continue;
                }
                if (s.startsWith("gt;", pos)) {
                    b.append('>');
                    pos += 3;
                    continue;
                }
                if (s.startsWith("lt;", pos)) {
                    b.append('<');
                    pos += 3;
                    continue;
                }
                if (s.startsWith("quot;", pos)) {
                    b.append('\"');
                    pos += 5;
                    continue;
                }
                if (!s.startsWith("#", pos)) break;
                int val = 0;
                while (true) {
                    int n = ++pos;
                    ++pos;
                    char ch = s.charAt(n);
                    if (ch == ';') break;
                    if (ch < '0' || ch > '9') continue;
                    val = val * 10 + (ch - 48);
                }
                b.append((char)val);
            }
            throw new AbstractRuntimeException(null, "Unknown entity", s);
        }
        return b != null ? b.toString() : s;
    }

    public static String toXMLString(String s) {
        if (s == null) {
            return null;
        }
        FastStringBuffer b = null;
        char[] chars = s.toCharArray();
        int length = chars.length;
        int i = 0;
        while (i < length) {
            char c = chars[i];
            switch (c) {
                case '\"': 
                case '&': 
                case '\'': 
                case '<': 
                case '>': {
                    if (b == null) {
                        b = new FastStringBuffer();
                        b.append(s, 0, i);
                    }
                    if (c == '&') {
                        b.append("&amp;");
                        break;
                    }
                    if (c == '\'') {
                        b.append("&apos;");
                        break;
                    }
                    if (c == '>') {
                        b.append("&gt;");
                        break;
                    }
                    if (c == '<') {
                        b.append("&lt;");
                        break;
                    }
                    if (c != '\"') break;
                    b.append("&quot;");
                    break;
                }
                default: {
                    if (b == null) break;
                    b.append(c);
                }
            }
            ++i;
        }
        return b != null ? b.toString() : s;
    }

    public static String toXMLString(String s, boolean ascii) {
        if (s == null) {
            return null;
        }
        FastStringBuffer b = new FastStringBuffer(s.length() + 256);
        char[] chars = s.toCharArray();
        int length = chars.length;
        int i = 0;
        while (i < length) {
            char c = chars[i];
            switch (c) {
                case '\"': 
                case '&': 
                case '\'': 
                case '<': 
                case '>': {
                    if (c == '&') {
                        b.append("&amp;");
                        break;
                    }
                    if (c == '\'') {
                        b.append("&apos;");
                        break;
                    }
                    if (c == '>') {
                        b.append("&gt;");
                        break;
                    }
                    if (c == '<') {
                        b.append("&lt;");
                        break;
                    }
                    if (c != '\"') break;
                    b.append("&quot;");
                    break;
                }
                default: {
                    if (ascii && c > '\u007f') {
                        b.append("&#" + Integer.toString(c) + ";");
                        break;
                    }
                    b.append(c);
                }
            }
            ++i;
        }
        return b.toString();
    }
}

