/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.commons.util;

import com.ibm.commons.util.StringUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;

public final class TSystem {
    public static final int OS_WINNT = 1;
    public static final int OS_WIN95 = 2;
    public static final int OS_WIN98 = 4;
    public static final int OS_SOLARIS = 8;
    public static final int OS_LINUX = 16;
    public static final int OS_HP = 32;
    public static final int OS_AIX = 64;
    public static final int OS_IRIX = 128;
    public static final int OS_SUNOS = 256;
    public static final int OS_DEC = 512;
    public static final int OS_OS2 = 1024;
    public static final int OS_MAC = 2048;
    public static final int OS_WIN2000 = 4096;
    public static final int OS_WINXP = 8192;
    public static final int OS_WINVISTA = 12288;
    public static final int OS_WIN7 = 13568;
    public static final int OS_AS400 = 16384;
    public static final int OS_OS390 = 32768;
    public static final int OS_OTHERWIN = 65536;
    public static final int OS_OTHER = 0x10000000;
    public static final int OS_WINDOWS_MASK = 77831;
    public static final int OS_WINNT_MASK = 77825;
    public static final int OS_UNIX_MASK = 1016;
    public static final int CPU_I386 = 1;
    public static final int CPU_OTHER = 0x10000000;
    private static int operatingSystem = -1;
    private static int cpu = -1;
    private static int javaVersion = -1;

    public static final String getVMVendor() {
        try {
            return System.getProperty("java.vendor");
        }
        catch (Exception exception) {
            return "";
        }
    }

    public static final int getOperatingSystem() {
        if (operatingSystem == -1) {
            try {
                String osName = System.getProperty("os.name");
                operatingSystem = "Windows NT".equals(osName) ? 1 : ("Windows 95".equals(osName) ? 2 : ("Windows 98".equals(osName) ? 4 : ("Windows 2000".equals(osName) ? 4096 : ("Windows XP".equals(osName) ? 8192 : ("Windows Vista".equals(osName) ? 12288 : ("Windows 7".equals(osName) ? 13568 : (osName.indexOf("Windows") >= 0 ? 65536 : ("Solaris".equals(osName) ? 8 : (osName.startsWith("SunOS") ? 8 : ("Linux".equals(osName) ? 16 : ("HP-UX".equals(osName) ? 32 : ("AIX".equals(osName) ? 64 : ("Irix".equals(osName) ? 128 : ("SunOS".equals(osName) ? 256 : ("Digital UNIX".equals(osName) ? 512 : ("OS/390".equals(osName) ? 32768 : ("AS/400".equals(osName) ? 16384 : ("OS/2".equals(osName) ? 1024 : (osName.startsWith("Mac OS") ? 2048 : (osName.startsWith("Darwin") ? 2048 : 0x10000000))))))))))))))))))));
            }
            catch (Exception exception) {
                operatingSystem = 0x10000000;
            }
        }
        return operatingSystem;
    }

    public static final boolean isWindows() {
        return (TSystem.getOperatingSystem() & 0x13007) != 0;
    }

    public static final boolean isWindowsNT() {
        return (TSystem.getOperatingSystem() & 0x13001) != 0;
    }

    public static final boolean isWindowsXP() {
        return TSystem.getOperatingSystem() == 8192;
    }

    public static final boolean isWindowsVista() {
        return TSystem.getOperatingSystem() == 12288;
    }

    public static final boolean isWindows7() {
        return TSystem.getOperatingSystem() == 13568;
    }

    public static final boolean isUnix() {
        return (TSystem.getOperatingSystem() & 0x3F8) != 0;
    }

    public static final int getCPU() {
        if (cpu == -1) {
            try {
                String cpuName = System.getProperty("os.arch");
                cpu = "i386".equals(cpuName) || "x86".equals(cpuName) ? 1 : 0x10000000;
            }
            catch (Exception exception) {
                cpu = 0x10000000;
            }
        }
        return cpu;
    }

    public static boolean isDevelopment() {
        return false;
    }

    public static void loadWindowsDLL(String libName, int version, String resourceName) throws IOException {
        String libPath = TSystem.installWindowsDLL(libName, version, resourceName);
        System.load(libPath);
    }

    public static String installWindowsDLL(String libName, int version, String resourceName) throws IOException {
        if (!TSystem.isWindows()) {
            throw new IOException(StringUtil.format("Cannot load a Windows DLL on a non Windows operating system", new Object[0]));
        }
        File dllFile = null;
        if (libName.indexOf("/") <= 0 && libName.indexOf("\\") <= 0) {
            File tempDirectory = new File(System.getProperty("java.io.tmpdir"));
            dllFile = new File(tempDirectory, String.valueOf(libName) + "_" + version + ".dll");
        } else {
            dllFile = new File(libName);
        }
        if (TSystem.isDevelopment() && dllFile.exists()) {
            dllFile.delete();
        }
        if (!dllFile.exists()) {
            InputStream dll = TSystem.class.getResourceAsStream(resourceName);
            if (dll == null) {
                throw new IOException(StringUtil.format("Windows DLL {0} not found", resourceName));
            }
            try {
                FileOutputStream dllout = new FileOutputStream(dllFile);
                try {
                    byte[] data = new byte[4096];
                    int read = dll.read(data, 0, data.length);
                    while (read > 0) {
                        dllout.write(data, 0, read);
                        read = dll.read(data, 0, data.length);
                    }
                }
                finally {
                    dllout.close();
                }
            }
            finally {
                dll.close();
            }
        }
        return dllFile.getPath();
    }

    public static final int getJavaVersion() {
        if (javaVersion < 0) {
            try {
                javaVersion = 0;
                String[] v = StringUtil.splitString(System.getProperty("java.version"), '.', true);
                if (v.length >= 1) {
                    int major = TSystem.parseInt(v[0]);
                    int minor = v.length >= 2 ? TSystem.parseInt(v[1]) : 0;
                    int minor2 = v.length >= 3 ? TSystem.parseInt(v[2]) : 0;
                    javaVersion = major * 100 + minor * 10 + minor2;
                }
            }
            catch (Exception exception) {
                javaVersion = 120;
            }
        }
        return javaVersion;
    }

    private static final int parseInt(String s) {
        return s.length() > 0 ? s.charAt(0) - 48 : 0;
    }

    public static final boolean isJava2() {
        return TSystem.getJavaVersion() >= 120;
    }
}

