/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.commons.util;

import com.ibm.commons.util.QuickSort;
import com.ibm.commons.util.StringUtil;
import java.util.ArrayList;

public class TStringVector
extends ArrayList {
    private boolean caseInsensitive;

    public TStringVector(int initialCapacity) {
        super(initialCapacity);
    }

    public TStringVector(boolean caseInsensitive) {
        this.caseInsensitive = caseInsensitive;
    }

    public TStringVector() {
    }

    public boolean isCaseInsensitive() {
        return this.caseInsensitive;
    }

    public void setCaseInsensitive(boolean caseInsensitive) {
        this.caseInsensitive = caseInsensitive;
    }

    public final String elementAt(int index) {
        return (String)this.get(index);
    }

    public final String getString(int index) {
        return (String)this.get(index);
    }

    @Override
    public final boolean contains(Object item) {
        return this.indexOf(item) >= 0;
    }

    @Override
    public final int indexOf(Object item) {
        return this.indexOf(item, 0);
    }

    public final int indexOf(Object item, int index) {
        int size = this.size();
        String s = (String)item;
        if (this.caseInsensitive) {
            int i = index;
            while (i < size) {
                if (StringUtil.equalsIgnoreCase(this.getString(i), s)) {
                    return i;
                }
                ++i;
            }
            return -1;
        }
        int i = index;
        while (i < size) {
            if (StringUtil.equals(this.getString(i), s)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public final void setElementAt(String item, int index) {
        this.set(index, item);
    }

    public final void add(String item) {
        super.add(item);
    }

    public final void addElement(String item) {
        super.add(item);
    }

    public final void addUnique(String item) {
        if (!this.contains(item)) {
            super.add(item);
        }
    }

    public final void addUniqueElement(String item) {
        this.addUnique(item);
    }

    public final void add(String[] items) {
        if (items != null) {
            int i = 0;
            while (i < items.length) {
                this.add(items[i]);
                ++i;
            }
        }
    }

    public final void addElements(String[] items) {
        this.add(items);
    }

    public final void addUnique(String[] items) {
        if (items != null) {
            int i = 0;
            while (i < items.length) {
                this.addUniqueElement(items[i]);
                ++i;
            }
        }
    }

    public final void addUniqueElements(String[] items) {
        this.addUnique(items);
    }

    public final void insertAt(String item, int index) {
        super.add(index, item);
    }

    public final void insertElementAt(String item, int index) {
        super.add(index, item);
    }

    public final void removeAll() {
        this.clear();
    }

    public final void removeAllElements() {
        this.clear();
    }

    public final void remove(String item) {
        int idx = this.indexOf(item);
        if (idx >= 0) {
            super.remove(idx);
        }
    }

    public final void removeElement(String item) {
        this.remove(item);
    }

    public final void removeAt(int index) {
        super.remove(index);
    }

    public final void removeElementAt(int index) {
        super.remove(index);
    }

    public final void removeItems(int index, int length) {
        if (length >= 0 && index >= 0 && index + length <= this.size()) {
            this.removeRange(index, index + length);
        }
    }

    public final synchronized void sort() {
        QuickSort.JavaList qSort = new QuickSort.JavaList(this){

            @Override
            public int compare(Object o1, Object o2) {
                return TStringVector.this.caseInsensitive ? o1.toString().compareToIgnoreCase(o2.toString()) : o1.toString().compareTo(o2.toString());
            }
        };
        qSort.sort();
    }

    public final synchronized void sortIgnoreCase() {
        QuickSort.JavaList qSort = new QuickSort.JavaList(this){

            @Override
            public int compare(Object o1, Object o2) {
                return o1.toString().compareToIgnoreCase(o2.toString());
            }
        };
        qSort.sort();
    }

    public String getAsString() {
        int size = this.size();
        if (size > 0) {
            StringBuffer buffer = new StringBuffer();
            int i = 0;
            while (i < size) {
                if (i > 0) {
                    buffer.append(", ");
                }
                buffer.append('\"');
                String s = this.getString(i);
                int j = 0;
                while (j < s.length()) {
                    char c = s.charAt(j);
                    switch (c) {
                        case '&': {
                            buffer.append("&amp;");
                            break;
                        }
                        case '\"': {
                            buffer.append("&quot;");
                            break;
                        }
                        case '<': {
                            buffer.append("&lt;");
                            break;
                        }
                        case '>': {
                            buffer.append("&gt;");
                            break;
                        }
                        default: {
                            buffer.append(c);
                        }
                    }
                    ++j;
                }
                buffer.append('\"');
                ++i;
            }
            return buffer.toString();
        }
        return null;
    }

    @Override
    public String toString() {
        return this.getAsString();
    }

    @Override
    public Object[] toArray() {
        return super.toArray(new String[this.size()]);
    }

    public String[] getElementArray() {
        return (String[])this.toArray();
    }
}

