/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.commons.util;

import com.ibm.commons.Platform;
import com.ibm.commons.util.StringUtil;

public final class SystemCache {
    private String name;
    private int maxSize;
    private int size;
    private MapEntry listStart;
    private MapEntry listEnd;
    private MapEntry[] entries;
    private long accessed;
    private long incache;
    private long added;
    private long discarded;

    public SystemCache(String name, int maxSize) {
        this.name = name;
        this.maxSize = maxSize;
        this.entries = new MapEntry[211];
    }

    public SystemCache(String name, int maxSize, String propertyName) {
        this.name = name;
        if (StringUtil.isNotEmpty(propertyName)) {
            try {
                int iv;
                String value = Platform.getInstance().getProperty(propertyName);
                if (StringUtil.isNotEmpty(value) && (iv = Integer.parseInt(value)) > 0) {
                    maxSize = iv;
                }
            }
            catch (Throwable throwable) {}
        }
        this.maxSize = maxSize;
        this.entries = new MapEntry[211];
    }

    public String getName() {
        return this.name;
    }

    public long getAccessedTimes() {
        return this.accessed;
    }

    public long getInCacheTimes() {
        return this.incache;
    }

    public long getAddedTimes() {
        return this.added;
    }

    public long getDiscardedTimes() {
        return this.discarded;
    }

    public int size() {
        return this.size;
    }

    public int getCapacity() {
        return this.maxSize;
    }

    public synchronized void clear() {
        this.entries = new MapEntry[211];
        this.listStart = null;
        this.listEnd = null;
        this.size = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(String key) {
        ++this.accessed;
        MapEntry e = this.getEntry(key);
        if (e != null) {
            ++this.incache;
            SystemCache systemCache = this;
            synchronized (systemCache) {
                if (e.inCache) {
                    this.removeEntry(e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object get(String key) {
        ++this.accessed;
        MapEntry e = this.getEntry(key);
        if (e != null) {
            ++this.incache;
            SystemCache systemCache = this;
            synchronized (systemCache) {
                if (e.inCache) {
                    this.moveToStart(e);
                } else {
                    this.put(e);
                }
            }
            return e.value;
        }
        return null;
    }

    public synchronized void put(String key, Object value) {
        if (this.maxSize > 0) {
            MapEntry e = this.getEntry(key);
            if (e != null) {
                e.value = value;
                this.moveToStart(e);
            } else {
                e = new MapEntry(key, value);
                this.put(e);
            }
        }
    }

    private void put(MapEntry e) {
        e.inCache = true;
        if (this.size == this.maxSize) {
            this.removeEntry(this.listEnd);
        }
        int slot = this.getSlot(e.hashCode);
        e.nextHash = this.entries[slot];
        if (e.nextHash != null) {
            e.nextHash.prevHash = e;
        }
        this.entries[slot] = e;
        if (this.listStart != null) {
            this.listStart.prevList = e;
        }
        e.nextList = this.listStart;
        this.listStart = e;
        if (this.listEnd == null) {
            this.listEnd = e;
        }
        ++this.size;
        ++this.added;
    }

    private final int getSlot(int hashCode) {
        return (hashCode & Integer.MAX_VALUE) % this.entries.length;
    }

    private final MapEntry getEntry(String key) {
        int hashCode = key.hashCode();
        MapEntry e = this.entries[this.getSlot(hashCode)];
        while (e != null) {
            if (e.hashCode == hashCode && e.key.equals(key)) {
                return e;
            }
            e = e.nextHash;
        }
        return null;
    }

    private final void moveToStart(MapEntry e) {
        if (e != this.listStart) {
            e.prevList.nextList = e.nextList;
            if (e.nextList != null) {
                e.nextList.prevList = e.prevList;
            } else {
                this.listEnd = e.prevList;
            }
            this.listStart.prevList = e;
            e.nextList = this.listStart;
            this.listStart = e;
        }
    }

    private final void removeEntry(MapEntry e) {
        e.inCache = false;
        if (e.prevHash != null) {
            e.prevHash.nextHash = e.nextHash;
        } else {
            this.entries[this.getSlot((int)e.hashCode)] = e.nextHash;
        }
        if (e.nextHash != null) {
            e.nextHash.prevHash = e.prevHash;
        }
        if (e.prevList != null) {
            e.prevList.nextList = e.nextList;
        } else {
            this.listStart = e.nextList;
        }
        if (e.nextList != null) {
            e.nextList.prevList = e.prevList;
        } else {
            this.listEnd = e.prevList;
        }
        --this.size;
        ++this.discarded;
    }

    private static class MapEntry {
        boolean inCache;
        MapEntry prevHash;
        MapEntry nextHash;
        MapEntry prevList;
        MapEntry nextList;
        int hashCode;
        String key;
        Object value;

        MapEntry(String key, Object value) {
            this.key = key;
            this.value = value;
            this.hashCode = key.hashCode();
        }
    }
}

