/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.commons.util;

import com.ibm.commons.util.FastStringBuffer;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import org.eclipse.core.runtime.Platform;

public class StringUtil {
    public static final String[] EMPTY_STRING_ARRAY = new String[0];
    public static final String SPACE = " ";
    public static final String EMPTY_STRING = "";
    private static int MINPWDLENGTH = 16;
    private static int[] ENCRYPTION;
    private static final String TRUE_STRING = "true";
    private static final String FALSE_STRING = "false";
    private static String[] lineSeparators;
    private static final char A = 'W';

    static {
        int[] nArray = new int[16];
        nArray[0] = 187;
        nArray[1] = 89;
        nArray[2] = 189;
        nArray[3] = 17;
        nArray[4] = 45;
        nArray[5] = 3;
        nArray[7] = 98;
        nArray[8] = 79;
        nArray[9] = 232;
        nArray[10] = 65;
        nArray[11] = 98;
        nArray[12] = 75;
        nArray[13] = 3;
        nArray[14] = 224;
        nArray[15] = 177;
        ENCRYPTION = nArray;
    }

    public static final boolean equalsIgnoreCase(String s1, String s2) {
        if (s1 == null || s2 == null) {
            return StringUtil.isEmpty(s1) == StringUtil.isEmpty(s2);
        }
        return s1.equalsIgnoreCase(s2);
    }

    public static String concatStrings(String[] strings, char sep, boolean trim) {
        int count = strings.length;
        if (count == 0) {
            return EMPTY_STRING;
        }
        if (count == 1) {
            return trim ? StringUtil.trim(strings[0]) : strings[0];
        }
        StringBuilder b = new StringBuilder();
        int i = 0;
        while (i < count) {
            if (i > 0) {
                b.append(sep);
            }
            b.append(trim ? StringUtil.trim(strings[i]) : strings[i]);
            ++i;
        }
        return b.toString();
    }

    public static final String trim(String s) {
        if (s != null) {
            return s.trim();
        }
        return null;
    }

    public static final String trim(char[] array) {
        int count;
        int last = count = array.length;
        int st = 0;
        while (st < last && StringUtil.isSpace(array[st])) {
            ++st;
        }
        while (st < last && StringUtil.isSpace(array[last - 1])) {
            --last;
        }
        if (last > st) {
            return new String(array, st, last - st);
        }
        return EMPTY_STRING;
    }

    public static int compareTo(String s1, String s2) {
        boolean e1 = StringUtil.isEmpty(s1);
        boolean e2 = StringUtil.isEmpty(s2);
        if (e1 || e2) {
            if (e1 && !e2) {
                return -1;
            }
            if (!e1 && e2) {
                return 1;
            }
            return 0;
        }
        return s1.compareTo(s2);
    }

    public static int compareToIgnoreCase(String s1, String s2) {
        boolean e1 = StringUtil.isEmpty(s1);
        boolean e2 = StringUtil.isEmpty(s2);
        if (e1 || e2) {
            if (e1 && !e2) {
                return -1;
            }
            if (!e1 && e2) {
                return 1;
            }
            return 0;
        }
        return s1.compareToIgnoreCase(s2);
    }

    public static final boolean equals(String s1, String s2) {
        if (s1 == null || s2 == null) {
            return StringUtil.isEmpty(s1) == StringUtil.isEmpty(s2);
        }
        return s1.equals(s2);
    }

    public static boolean equals(Object str1, Object str2) {
        if (str1 == null && str2 == null) {
            return true;
        }
        if (str1 != null) {
            return str1.equals(str2);
        }
        if (str2 != null) {
            return str2.equals(str1);
        }
        return false;
    }

    public static boolean isEmpty(String s) {
        return s == null || s.length() == 0;
    }

    public static boolean isNotEmpty(String s) {
        return s != null && s.length() > 0;
    }

    public static String getNonNullString(String string) {
        return string == null ? EMPTY_STRING : string;
    }

    public static final boolean isSpace(String s) {
        if (s != null) {
            int len = s.length();
            int i = 0;
            while (i < len) {
                char c = s.charAt(i);
                if (c != ' ' && c != '\t' && c != '\n' && c != '\r') {
                    return false;
                }
                ++i;
            }
        }
        return true;
    }

    public static final String format(String fmt, Object ... parameters) {
        if (fmt != null) {
            FastStringBuffer buffer = new FastStringBuffer();
            return buffer.appendFormat(fmt, parameters).toString();
        }
        return EMPTY_STRING;
    }

    public static String toString(Object o) {
        return StringUtil.toString(o, 32);
    }

    public static String toString(char ch) {
        char[] array = new char[]{ch};
        return new String(array);
    }

    public static String toString(byte value) {
        return Byte.toString(value);
    }

    public static String toString(short value) {
        return Short.toString(value);
    }

    public static String toString(int value) {
        return Integer.toString(value);
    }

    public static String toString(long value) {
        return Long.toString(value);
    }

    public static String toString(float value) {
        return Float.toString(value);
    }

    public static String toString(double value) {
        return Double.toString(value);
    }

    public static String toString(boolean value) {
        return value ? TRUE_STRING : FALSE_STRING;
    }

    public static final String toString(Object value, int max) {
        if (value != null) {
            if (value.getClass().isArray()) {
                return StringUtil.toStringArray(value, -1, max);
            }
            return value.toString();
        }
        return EMPTY_STRING;
    }

    public static final String toString(int value, int digits, char fill) {
        FastStringBuffer b = new FastStringBuffer();
        String s = Integer.toString(value);
        if (s.length() <= digits) {
            b.repeat(fill, digits - s.length());
            b.append(s);
        } else {
            b.repeat('*', digits);
        }
        return b.toString();
    }

    public static String[] toStringArray(Collection strings) {
        if (strings == null || strings.size() == 0) {
            return EMPTY_STRING_ARRAY;
        }
        return strings.toArray(new String[strings.size()]);
    }

    public static final String toStringArray(Object value, int used, int max) {
        int nItem = -1;
        boolean[] za = null;
        char[] ca = null;
        byte[] ba = null;
        short[] sa = null;
        int[] ia = null;
        long[] la = null;
        float[] fa = null;
        double[] da = null;
        Object[] oa = null;
        if (value instanceof boolean[]) {
            za = (boolean[])value;
            nItem = za.length;
        } else if (value instanceof char[]) {
            ca = (char[])value;
            nItem = ca.length;
        } else if (value instanceof byte[]) {
            ba = (byte[])value;
            nItem = ba.length;
        } else if (value instanceof short[]) {
            sa = (short[])value;
            nItem = sa.length;
        } else if (value instanceof int[]) {
            ia = (int[])value;
            nItem = ia.length;
        } else if (value instanceof long[]) {
            la = (long[])value;
            nItem = la.length;
        } else if (value instanceof float[]) {
            fa = (float[])value;
            nItem = fa.length;
        } else if (value instanceof double[]) {
            da = (double[])value;
            nItem = da.length;
        } else if (value instanceof Object[]) {
            oa = (Object[])value;
            nItem = oa.length;
        }
        if (used >= 0) {
            nItem = used;
        }
        if (nItem >= 0) {
            StringBuilder buf = new StringBuilder(512);
            buf.append(Integer.toString(nItem));
            buf.append(" {");
            int count = max < nItem ? max : nItem;
            int i = 0;
            while (i < count) {
                if (i != 0) {
                    buf.append(", ");
                }
                if (za != null) {
                    buf.append(StringUtil.toString(za[i]));
                } else if (ca != null) {
                    buf.append('\'');
                    buf.append(ca[i]);
                    buf.append('\'');
                } else if (ba != null) {
                    buf.append(StringUtil.toString(ba[i]));
                } else if (sa != null) {
                    buf.append(StringUtil.toString(sa[i]));
                } else if (ia != null) {
                    buf.append(StringUtil.toString(ia[i]));
                } else if (la != null) {
                    buf.append(StringUtil.toString(la[i]));
                } else if (fa != null) {
                    buf.append(StringUtil.toString(fa[i]));
                } else if (da != null) {
                    buf.append(StringUtil.toString(da[i]));
                } else if (oa != null) {
                    buf.append(StringUtil.toString(oa[i]));
                }
                ++i;
            }
            if (max < nItem) {
                buf.append(", ...");
            }
            buf.append("}");
            return buf.toString();
        }
        return StringUtil.format("Unknown java array type {0}", value.getClass().toString());
    }

    public static final String repeat(char toRepeat, int count) {
        StringBuilder b = new StringBuilder(count);
        int i = 0;
        while (i < count) {
            b.append(toRepeat);
            ++i;
        }
        return b.toString();
    }

    public static final String repeat(String toRepeat, int count) {
        StringBuilder b = new StringBuilder(count * toRepeat.length());
        int i = 0;
        while (i < count) {
            b.append(toRepeat);
            ++i;
        }
        return b.toString();
    }

    public static final String replaceFirst(String source, String value, String replace) {
        int idx;
        if (StringUtil.isEmpty(source) || StringUtil.isEmpty(value)) {
            return EMPTY_STRING;
        }
        if (replace == null) {
            replace = EMPTY_STRING;
        }
        if ((idx = source.indexOf(value)) >= 0) {
            FastStringBuffer buffer = new FastStringBuffer();
            buffer.append(source, 0, idx);
            buffer.append(replace);
            int next = idx + value.length();
            buffer.append(source, next, source.length());
            return buffer.toString();
        }
        return source;
    }

    public static final String replace(String source, String value, String replace) {
        int idx;
        if (StringUtil.isEmpty(source) || StringUtil.isEmpty(value)) {
            return EMPTY_STRING;
        }
        if (replace == null) {
            replace = EMPTY_STRING;
        }
        if ((idx = source.indexOf(value)) >= 0) {
            FastStringBuffer buffer = new FastStringBuffer();
            buffer.append(source, 0, idx);
            do {
                buffer.append(replace);
                int next = idx + value.length();
                idx = source.indexOf(value, next);
                buffer.append(source, next, idx >= 0 ? idx : source.length());
            } while (idx >= 0);
            return buffer.toString();
        }
        return source;
    }

    public static final String replace(String string, char value, char replace) {
        int idx = string.indexOf(value);
        if (idx >= 0) {
            FastStringBuffer buffer = new FastStringBuffer();
            buffer.append(string, 0, idx);
            do {
                int next;
                if (replace != '\u0000') {
                    buffer.append(replace);
                }
                buffer.append(string, next, (idx = string.indexOf(value, next = idx + 1)) >= 0 ? idx : string.length());
            } while (idx >= 0);
            return buffer.toString();
        }
        return string;
    }

    public static final String toUnsignedHex(int value, int nChars) {
        FastStringBuffer b = new FastStringBuffer();
        int i = 7;
        while (i >= 0) {
            int v = value >>> i * 4 & 0xF;
            if (b.length() > 0 || v != 0 || i < nChars || i == 0) {
                b.append(StringUtil.hexChar(v));
            }
            --i;
        }
        if (nChars > 0 && b.length() > nChars) {
            throw new NumberFormatException(StringUtil.format("Hexadecimal number {0} too big to fit in '{1}' characters", StringUtil.toString(value), StringUtil.toString(nChars)));
        }
        return b.toString();
    }

    public static final char hexChar(int v) {
        return (char)(v >= 10 ? v - 10 + 65 : v + 48);
    }

    public static final int hexValue(char c) {
        if (c >= '0' && c <= '9') {
            return c - 48;
        }
        if (c >= 'A' && c <= 'F') {
            return c - 65 + 10;
        }
        if (c >= 'a' && c <= 'f') {
            return c - 97 + 10;
        }
        return -1;
    }

    public static String[] splitString(String s, char sep, boolean trim) {
        if (s == null) {
            return EMPTY_STRING_ARRAY;
        }
        return StringUtil.splitString(null, 0, s, 0, sep, trim);
    }

    private static String[] splitString(String[] result, int count, String s, int pos, char sep, boolean trim) {
        int newPos = s.indexOf(sep, pos);
        if (newPos >= 0) {
            result = StringUtil.splitString(null, count + 1, s, newPos + 1, sep, trim);
            result[count] = s.substring(pos, newPos);
        } else {
            result = new String[count + 1];
            result[count] = s.substring(pos);
        }
        if (trim) {
            result[count] = result[count].trim();
        }
        return result;
    }

    public static String[] splitString(String s, String sep, boolean trim) {
        if (s == null) {
            return EMPTY_STRING_ARRAY;
        }
        if (StringUtil.isEmpty(sep)) {
            return new String[]{s};
        }
        return StringUtil.splitString(null, 0, s, 0, sep, trim);
    }

    private static String[] splitString(String[] result, int count, String s, int pos, String sep, boolean trim) {
        int newPos = s.indexOf(sep, pos);
        if (newPos >= 0) {
            result = StringUtil.splitString(null, count + 1, s, newPos + sep.length(), sep, trim);
            result[count] = s.substring(pos, newPos);
        } else {
            result = new String[count + 1];
            result[count] = s.substring(pos);
        }
        if (trim) {
            result[count] = result[count].trim();
        }
        return result;
    }

    public static final String[] splitString(String s, char sep) {
        return StringUtil.splitString(s, sep, false);
    }

    public static final String ltrim(String s) {
        int count = s.length();
        int st = 0;
        while (st < count && StringUtil.isSpace(s.charAt(st))) {
            ++st;
        }
        return st > 0 ? s.substring(st, count) : s;
    }

    private static boolean isSpace(char c) {
        return c <= ' ';
    }

    public static final String rtrim(String s) {
        int count;
        int len = count = s.length();
        while (len > 0 && StringUtil.isSpace(s.charAt(len - 1))) {
            --len;
        }
        return len < count ? s.substring(0, len) : s;
    }

    public static int indexOfIgnoreCase(String source, String str, int fromIndex) {
        int count = source.length();
        int strCount = str.length();
        int max = count - strCount;
        if (fromIndex >= count) {
            if (count == 0 && fromIndex == 0 && strCount == 0) {
                return 0;
            }
            return -1;
        }
        if (fromIndex < 0) {
            fromIndex = 0;
        }
        if (str.length() == 0) {
            return fromIndex;
        }
        char first = Character.toLowerCase(str.charAt(0));
        int i = fromIndex;
        block0: while (true) {
            if (i <= max && Character.toLowerCase(source.charAt(i)) != first) {
                ++i;
                continue;
            }
            if (i > max) {
                return -1;
            }
            int j = i + 1;
            int end = j + strCount - 1;
            int k = 1;
            while (j < end) {
                if (Character.toLowerCase(source.charAt(j++)) == Character.toLowerCase(str.charAt(k++))) continue;
                ++i;
                continue block0;
            }
            break;
        }
        return i;
    }

    public static int indexOfIgnoreCase(String source, String str) {
        return StringUtil.indexOfIgnoreCase(source, str, 0);
    }

    public static int lastIndexOfIgnoreCase(String source, String str, int fromIndex) {
        int start;
        int count = source.length();
        int strCount = str.length();
        int rightIndex = count - strCount;
        if (fromIndex < 0) {
            return -1;
        }
        if (fromIndex > rightIndex) {
            fromIndex = rightIndex;
        }
        if (strCount == 0) {
            return fromIndex;
        }
        int strLastIndex = strCount - 1;
        char strLastChar = Character.toLowerCase(str.charAt(strLastIndex));
        int min = strCount - 1;
        int i = min + fromIndex;
        block0: while (true) {
            if (i >= min && Character.toLowerCase(source.charAt(i)) != strLastChar) {
                --i;
                continue;
            }
            if (i < min) {
                return -1;
            }
            int j = i - 1;
            start = j - (strCount - 1);
            int k = strLastIndex - 1;
            while (j > start) {
                if (Character.toLowerCase(source.charAt(j--)) == Character.toLowerCase(str.charAt(k--))) continue;
                --i;
                continue block0;
            }
            break;
        }
        return start + 1;
    }

    public static int lastIndexOfIgnoreCase(String source, String str) {
        return StringUtil.lastIndexOfIgnoreCase(source, str, source.length());
    }

    public static boolean startsWithIgnoreCase(String s, String prefix) {
        return StringUtil.startsWithIgnoreCase(s, prefix, 0);
    }

    public static boolean startsWithIgnoreCase(String s, String prefix, int start) {
        return s.regionMatches(true, start, prefix, 0, prefix.length());
    }

    public static boolean endsWithIgnoreCase(String s, String suffix) {
        return s.regionMatches(true, s.length() - suffix.length(), suffix, 0, suffix.length());
    }

    public static boolean isEncrypted(String pwd) {
        if (pwd == null) {
            return false;
        }
        return pwd.startsWith("[") && pwd.endsWith("]");
    }

    public static String encrypt(String pwd) {
        return StringUtil.encrypt(pwd, null);
    }

    public static String encrypt(String pwd, String ctx) {
        int offset;
        if (pwd == null) {
            return null;
        }
        if (StringUtil.isNotEmpty(ctx)) {
            int acc = Math.abs(ctx.hashCode() % ENCRYPTION.length);
            offset = Math.min(ENCRYPTION.length, acc);
        } else {
            offset = Math.min(ENCRYPTION.length, (int)(Math.random() * (double)ENCRYPTION.length));
        }
        FastStringBuffer b = new FastStringBuffer();
        b.append('[');
        StringUtil.encryptChar(b, 0, (char)offset);
        StringUtil.encryptChar(b, offset++, (char)pwd.length());
        int i = 0;
        while (i < Math.max(MINPWDLENGTH, pwd.length())) {
            char c;
            if (i < pwd.length()) {
                c = pwd.charAt(i);
            } else if (StringUtil.isNotEmpty(ctx)) {
                int pwdlen = pwd.length();
                c = ctx.charAt((i - pwdlen) % ctx.length());
            } else {
                c = (char)(Math.random() * 64.0 + 32.0);
            }
            StringUtil.encryptChar(b, offset++, c);
            ++i;
        }
        b.append(']');
        return b.toString();
    }

    public static String decrypt(String pwd) {
        if (StringUtil.isEncrypted(pwd)) {
            FastStringBuffer b = new FastStringBuffer();
            int offset = StringUtil.decryptChar(pwd, 0, 1);
            int pwdlength = StringUtil.decryptChar(pwd, offset++, 3);
            int i = 0;
            while (i < pwdlength) {
                b.append(StringUtil.decryptChar(pwd, offset++, 5 + i * 2));
                ++i;
            }
            return b.toString();
        }
        return pwd;
    }

    private static void encryptChar(FastStringBuffer b, int offset, char c) {
        int xor = ENCRYPTION[offset % ENCRYPTION.length];
        int val = c ^ xor;
        char c1 = (char)((val & 0xF0) / 16 + 65);
        char c2 = (char)((val & 0xF) + 65);
        b.append(c1);
        b.append(c2);
    }

    private static char decryptChar(String pwd, int offset, int pos) {
        int xor = ENCRYPTION[offset % ENCRYPTION.length];
        char c1 = pwd.charAt(pos);
        char c2 = pwd.charAt(pos + 1);
        char c = (char)((c1 - 65) * 16 + (c2 - 65) ^ xor);
        return c;
    }

    public static String fromXmlInputString(String s) {
        if (StringUtil.isEmpty(s)) {
            return s;
        }
        int l = s.length();
        FastStringBuffer b = null;
        try {
            int firstChar;
            int start = 0;
            while ((firstChar = s.indexOf("&#", start)) != -1) {
                int lastChar;
                boolean ok = false;
                for (lastChar = firstChar + 2; lastChar < l; ++lastChar) {
                    char c = s.charAt(lastChar);
                    if (c == ';') {
                        ok = true;
                        break;
                    }
                    if (c < '0' || c > '9') break;
                }
                if (ok) {
                    int n = Integer.parseInt(s.substring(firstChar + 2, lastChar));
                    if (b == null) {
                        b = new FastStringBuffer();
                        b.append(s, 0, firstChar);
                    } else {
                        b.append(s, start, firstChar);
                    }
                    b.append((char)n);
                    start = lastChar + 1;
                    continue;
                }
                start = firstChar + 2;
            }
            if (b != null && start < l) {
                b.append(s, start, l);
            }
            String string = b != null ? b.toString() : s;
            return string;
        }
        finally {
            b = null;
        }
    }

    public static boolean isTrueValue(String stringToTest) {
        return TRUE_STRING.equalsIgnoreCase(stringToTest);
    }

    public static boolean isFalseValue(String stringToTest) {
        return FALSE_STRING.equalsIgnoreCase(stringToTest);
    }

    public static String getProperCaseString(String sample) {
        if (sample == null) {
            return null;
        }
        char[] chars = sample.toCharArray();
        StringBuffer buffer = new StringBuffer(sample.length());
        if (chars != null && chars.length > 0) {
            buffer.append(Character.toUpperCase(chars[0]));
            int i = 1;
            while (i < chars.length) {
                if (Character.isUpperCase(chars[i])) {
                    buffer.append(SPACE);
                    chars[i] = Character.toLowerCase(chars[i]);
                }
                buffer.append(chars[i]);
                ++i;
            }
        }
        return buffer.toString();
    }

    public static String[] getLineSeparators() {
        Map separators = Platform.knownPlatformLineSeparators();
        ArrayList sepList = new ArrayList(separators.values());
        Collections.sort(sepList, new Comparator(){

            public int compare(Object o1, Object o2) {
                int s2L;
                String s1 = (String)o1;
                String s2 = (String)o2;
                int s1L = s1.length();
                if (s1L > (s2L = s2.length())) {
                    return -1;
                }
                if (s1L < s2L) {
                    return 1;
                }
                return 0;
            }
        });
        return sepList.toArray(new String[sepList.size()]);
    }

    public static String removeLineBreaks(String s) {
        if (lineSeparators == null) {
            lineSeparators = StringUtil.getLineSeparators();
        }
        int i = 0;
        while (i < lineSeparators.length) {
            s = StringUtil.replace(s, lineSeparators[i], SPACE);
            ++i;
        }
        return s;
    }

    public static String parseHtml(String s) {
        if (StringUtil.isNotEmpty(s)) {
            StringBuilder b = new StringBuilder();
            boolean space = true;
            int len = s.length();
            int i = 0;
            while (i < len) {
                char c = s.charAt(i);
                if (c == ' ' || c == '\t') {
                    if (!space) {
                        b.append(' ');
                        space = true;
                    }
                } else if (c == '<') {
                    while (i < len && c != '>') {
                        ++i;
                    }
                } else {
                    b.append(c);
                    space = c == '\n' || c == '\r';
                }
                ++i;
            }
            return b.toString();
        }
        return s;
    }

    public static String getAutoGenNameFromJavaName(String javaName) {
        if (javaName == null) {
            return null;
        }
        int len = javaName.length();
        StringBuffer returnString = new StringBuffer(len);
        char[] chars = javaName.toCharArray();
        boolean leadingDigit = false;
        int i = 0;
        while (i < len) {
            char c = chars[i];
            if (c >= 'A' && c <= 'z' || c >= '0' && c <= '9' || c == '_') {
                if (i == 0) {
                    if (Character.isLetter(c)) {
                        returnString.append(Character.toUpperCase(c));
                    } else {
                        leadingDigit = true;
                    }
                } else if (leadingDigit) {
                    if (Character.isLetter(c)) {
                        leadingDigit = false;
                        returnString.append(Character.toUpperCase(c));
                    }
                } else {
                    returnString.append(c);
                }
            } else {
                leadingDigit = i == 0;
            }
            ++i;
        }
        return returnString.toString();
    }

    public static char getMnemonicCharacter(String text) {
        int index;
        char ret = '\uffff';
        if (text != null && (index = text.indexOf("&")) != -1 && index < text.length() - 1) {
            ret = text.charAt(index + 1);
        }
        return ret;
    }

    public static String generateCopyName(String sourceName, String[] listOfNames) {
        StringBuffer buffer = new StringBuffer(sourceName);
        String copyString = "copy";
        String separator = "_";
        StringBuffer copySeparator = new StringBuffer(separator);
        copySeparator.append(copyString);
        copySeparator.append(separator);
        String copySep = copySeparator.toString();
        int index = sourceName.indexOf(copySep);
        long num = 1L;
        if (index != -1) {
            String substring = sourceName.substring(index + copySep.length());
            if (StringUtil.isNotEmpty(substring)) {
                try {
                    num = Long.parseLong(substring);
                    buffer.delete(index + copySep.length(), buffer.length());
                }
                catch (NumberFormatException numberFormatException) {
                    buffer.append(copySep);
                }
            }
        } else {
            buffer.append(copySep);
        }
        return StringUtil.getNextUniqueValue(buffer.toString(), num, listOfNames);
    }

    public static String getNextUniqueValue(String name, long startingNum, String[] listOfNames) {
        boolean valid = true;
        int i = 0;
        while ((long)i < Long.MAX_VALUE) {
            StringBuffer newBuffer = new StringBuffer(name);
            newBuffer.append(startingNum);
            String test = newBuffer.toString();
            if (listOfNames != null) {
                int x = 0;
                while (x < listOfNames.length) {
                    String currName = listOfNames[x];
                    if (StringUtil.equals(currName, test)) {
                        valid = false;
                    }
                    ++x;
                }
            }
            if (!valid) {
                valid = true;
                ++startingNum;
            } else {
                return test;
            }
            ++i;
        }
        return name;
    }

    public static String removeMnemonics(String string) {
        if (string == null || string.indexOf(38) == -1) {
            return string;
        }
        int strLen = string.length();
        StringBuffer sb = new StringBuffer(strLen);
        int lastIndex = 0;
        int iIndex = string.indexOf(38);
        while (iIndex != -1) {
            if (iIndex == strLen - 1) break;
            int modifier = 1;
            if (iIndex - 1 >= 0 && iIndex + 2 < string.length() && string.charAt(iIndex - 1) == '(' && string.charAt(iIndex + 2) == ')') {
                --iIndex;
                modifier = 4;
            } else if (string.charAt(iIndex + 1) == '&') {
                ++iIndex;
            }
            sb.append(string.substring(lastIndex, iIndex));
            lastIndex = iIndex += modifier;
            iIndex = string.indexOf(38, iIndex);
        }
        if (lastIndex < strLen) {
            sb.append(string.substring(lastIndex, strLen));
        }
        return sb.toString();
    }

    public static String removeMnemonics(String string, boolean remove) {
        return remove ? StringUtil.removeMnemonics(string) : string;
    }

    public static String getDigest(String str) {
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            md.update(str.getBytes("UTF-8"));
            byte[] digest = md.digest();
            return StringUtil.toHexValue(digest);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static String toHexValue(byte[] barr) {
        FastStringBuffer sb = new FastStringBuffer(barr.length * 2);
        int i = 0;
        while (i < barr.length) {
            int unsigned = barr[i] & 0xFF;
            sb.append(StringUtil.getUpperDigitAsHex(unsigned));
            sb.append(StringUtil.getLowerDigitAsHex(unsigned));
            ++i;
        }
        return sb.toString();
    }

    private static char getUpperDigitAsHex(int b) {
        int val = b / 16;
        return StringUtil.toHex(val);
    }

    private static char getLowerDigitAsHex(int b) {
        int val = b % 16;
        return StringUtil.toHex(val);
    }

    private static char toHex(int n) {
        if (n >= 0 && n <= 9) {
            return (char)(48 + n);
        }
        if (10 <= n && n <= 15) {
            return (char)(87 + n);
        }
        throw new IllegalArgumentException(EMPTY_STRING + n);
    }

    public static boolean contains(Object[] objects, Object toTest) {
        if (objects != null) {
            int i = 0;
            while (i < objects.length) {
                if (StringUtil.equals(objects[i], toTest)) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public static boolean isLineSeparator(String s) {
        if (StringUtil.isNotEmpty(s)) {
            String[] separators = StringUtil.getLineSeparators();
            return StringUtil.isContainedWithin(s, separators);
        }
        return false;
    }

    public static boolean isEmpty(String[] arr) {
        return arr == null || arr.length < 1;
    }

    public static boolean isNotEmpty(String[] arr) {
        return arr != null && arr.length > 0;
    }

    public static boolean isContainedWithin(String s, String[] container) {
        if (StringUtil.isNotEmpty(s) && StringUtil.isNotEmpty(container)) {
            int i = 0;
            while (i < container.length) {
                if (StringUtil.equals(s, container[i])) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public static String expandProperties(String s) {
        if (StringUtil.isEmpty(s)) {
            return s;
        }
        int index = s.indexOf("${", 0);
        if (index < 0) {
            return s;
        }
        StringBuilder b = new StringBuilder();
        if (index > 0) {
            b.append(s, 0, index);
        }
        int end;
        while ((end = s.indexOf(125, index)) >= 0) {
            int pos;
            String propName = s.substring(index + 2, end);
            String propValue = System.getProperty(propName);
            if (StringUtil.isNotEmpty(propValue)) {
                b.append(propValue);
            }
            if ((pos = s.indexOf("${", index = end + 1)) < 0) {
                b.append(s, index, s.length());
                return b.toString();
            }
            if (pos > index) {
                b.append(s, index, pos);
            }
            index = pos;
        }
        return b.toString();
    }

    public static int countMatch(String source, char match) {
        int count = 0;
        if (StringUtil.isNotEmpty(source)) {
            int i = 0;
            while (i < source.length()) {
                if (StringUtil.equals(Character.valueOf(source.charAt(i)), Character.valueOf(match))) {
                    ++count;
                }
                ++i;
            }
        }
        return count;
    }
}

