/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.commons.util;

public class Semaphore {
    private long _permits;

    public Semaphore(long initialPermits) {
        this._permits = initialPermits;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void acquire() throws InterruptedException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        Semaphore semaphore = this;
        synchronized (semaphore) {
            try {
                while (this._permits <= 0L) {
                    this.wait();
                }
                --this._permits;
            }
            catch (InterruptedException ex) {
                this.notify();
                throw ex;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean acquire(long msecs) throws InterruptedException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        Semaphore semaphore = this;
        synchronized (semaphore) {
            if (this._permits > 0L) {
                --this._permits;
                return true;
            }
            if (msecs <= 0L) {
                return false;
            }
            try {
                long startTime = System.currentTimeMillis();
                long waitTime = msecs;
                do {
                    this.wait(waitTime);
                    if (this._permits <= 0L) continue;
                    --this._permits;
                    return true;
                } while ((waitTime = msecs - (System.currentTimeMillis() - startTime)) > 0L);
                return false;
            }
            catch (InterruptedException ex) {
                this.notify();
                throw ex;
            }
        }
    }

    public synchronized void release() {
        ++this._permits;
        this.notify();
    }

    public synchronized void release(long n) {
        if (n < 0L) {
            throw new IllegalArgumentException("Negative argument");
        }
        this._permits += n;
        long i = 0L;
        while (i < n) {
            this.notify();
            ++i;
        }
    }

    public synchronized long permits() {
        return this._permits;
    }
}

