/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.commons.util;

import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.Locale;
import java.util.ResourceBundle;

public class ResourceBundleHelper {
    private ResourceBundle _bundle;
    private MessageFormat _formatter;
    private String _bundleName = "NULL";
    private static final int ERROR_CODE_LENGTH = 10;
    private static StackCrawler crawler = new StackCrawler();

    public ResourceBundleHelper(String bundleName) {
        ResourceBundle bundle = null;
        try {
            Class[] cls = crawler.getClassContext();
            Locale locale = Locale.getDefault();
            Throwable th = null;
            int i = 0;
            while (i < cls.length) {
                try {
                    bundle = ResourceBundle.getBundle(bundleName, locale, cls[i].getClassLoader());
                    break;
                }
                catch (Throwable t) {
                    th = t;
                    ++i;
                }
            }
            this._bundleName = bundleName;
            if (bundle == null) {
                throw th;
            }
        }
        catch (Throwable t) {
            System.out.println("Unable to load bundle " + bundleName);
            System.out.println("Continuing with bundle=null");
            System.out.println("Printing StackTrace from ResourceBundleHelper(String bundleName)");
            t.printStackTrace();
        }
        this.init(bundle);
    }

    public ResourceBundleHelper(String bundleName, Locale locale) {
        ResourceBundle bundle = null;
        try {
            ClassLoader cl = crawler.getCallingLoader();
            bundle = ResourceBundle.getBundle(bundleName, locale, cl);
            this._bundleName = bundleName;
        }
        catch (Throwable t) {
            System.out.println("Unable to load bundle " + bundleName);
            System.out.println("Continuing with bundle=null");
            System.out.println("Printing StackTrace from ResourceBundleHelper(String bundleName, Locale locale)");
            t.printStackTrace();
        }
        this._bundleName = bundleName;
        this.init(bundle);
    }

    public ResourceBundleHelper(String bundleName, Locale locale, ClassLoader cl) {
        ResourceBundle bundle = ResourceBundle.getBundle(bundleName, locale, cl);
        this._bundleName = bundleName;
        this.init(bundle);
    }

    public ResourceBundleHelper(String bundleName, Locale[] locales, ClassLoader cl) {
        ResourceBundle bundle;
        int i = 0;
        while (!locales[i].equals((bundle = ResourceBundle.getBundle(bundleName, locales[i], cl)).getLocale()) && locales[++i] != null) {
        }
        this._bundleName = bundleName;
        this.init(bundle);
    }

    public ResourceBundleHelper(String bundleName, Locale[] locales) {
        ClassLoader cl;
        ResourceBundle bundle;
        int i = 0;
        while (!locales[i].equals((bundle = ResourceBundle.getBundle(bundleName, locales[i], cl = crawler.getCallingLoader())).getLocale()) && locales[++i] != null) {
        }
        this._bundleName = bundleName;
        this.init(bundle);
    }

    public ResourceBundleHelper(String bundleName, ClassLoader cl) {
        ResourceBundle bundle = ResourceBundle.getBundle(bundleName, Locale.getDefault(), cl);
        this._bundleName = bundleName;
        this.init(bundle);
    }

    public ResourceBundleHelper(ResourceBundle bundle) {
        this.init(bundle);
        this._bundleName = bundle.getClass().getName();
    }

    private void init(ResourceBundle bundle) {
        if (bundle != null) {
            this._bundle = bundle;
            this._formatter = new MessageFormat("");
            this._formatter.setLocale(this._bundle.getLocale());
        } else {
            this._bundle = null;
            this._formatter = new MessageFormat("");
        }
    }

    private ResourceBundleHelper() {
    }

    public String getBundleName() {
        return this._bundleName;
    }

    public void setBundleName(String bn) {
        if (this._bundleName == null) {
            this._bundleName = bn;
        }
    }

    public Locale getLocale() {
        return this._bundle.getLocale();
    }

    public Enumeration getKeys() {
        return this._bundle.getKeys();
    }

    public String getErrorCode(String key) {
        String msg = this._bundle.getString(key);
        int startPos = msg.indexOf("=") + 1;
        int endPos = startPos + 10;
        return msg.substring(startPos, endPos);
    }

    public String getString(String key) {
        try {
            return this._bundle.getString(key);
        }
        catch (Throwable t) {
            System.err.println(t.getLocalizedMessage());
            return key;
        }
    }

    public String getString(String key, Object[] params) {
        return MessageFormat.format(this._bundle.getString(key), params);
    }

    public String getString(String key, String param1) {
        Object[] params = new String[]{param1};
        return this.getString(key, params);
    }

    public String getString(String key, String param1, String param2) {
        Object[] params = new String[]{param1, param2};
        return this.getString(key, params);
    }

    public String getString(String key, String param1, String param2, String param3) {
        Object[] params = new String[]{param1, param2, param3};
        return this.getString(key, params);
    }

    public String getString(String key, String param1, String param2, String param3, String param4) {
        Object[] params = new String[]{param1, param2, param3, param4};
        return this.getString(key, params);
    }

    public String getString(String key, String[] params) {
        return this.getString(key, (Object[])params);
    }

    private static class StackCrawler
    extends SecurityManager {
        private StackCrawler() {
        }

        public Class[] getClassContext() {
            return super.getClassContext();
        }

        public ClassLoader getCallingLoader() {
            return this.getClassContext()[3].getClassLoader();
        }
    }
}

