/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.commons.util;

import java.util.List;
import java.util.Vector;

public abstract class QuickSort {
    public void sort() {
        this.qSortHelp(0, this.getCount());
    }

    public void sort(int first, int length) {
        this.qSortHelp(first, length);
    }

    public abstract int getCount();

    public abstract int compare(int var1, int var2);

    public abstract void exchange(int var1, int var2);

    private final void qSortHelp(int pivotP, int nElem) {
        while (true) {
            int pivotEnd;
            int rightP;
            if (nElem <= 7) {
                if (nElem == 2) {
                    rightP = 1 + pivotP;
                    if (this.compare(pivotP, rightP) > 0) {
                        this.exchange(pivotP, rightP);
                    }
                    return;
                }
                int i = 0;
                while (i < nElem) {
                    int j = i + 1;
                    while (j < nElem) {
                        if (this.compare(i + pivotP, j + pivotP) > 0) {
                            this.exchange(i + pivotP, j + pivotP);
                        }
                        ++j;
                    }
                    ++i;
                }
                return;
            }
            int leftP = (nElem >> 1) + pivotP;
            rightP = nElem - 1 + pivotP;
            if (this.compare(leftP, rightP) > 0) {
                this.exchange(leftP, rightP);
            }
            if (this.compare(leftP, pivotP) > 0) {
                this.exchange(leftP, pivotP);
            } else if (this.compare(pivotP, rightP) > 0) {
                this.exchange(pivotP, rightP);
            }
            if (nElem == 3) {
                this.exchange(pivotP, leftP);
                return;
            }
            leftP = pivotEnd = pivotP + 1;
            while (true) {
                int retval;
                if ((retval = this.compare(leftP, pivotP)) <= 0) {
                    if (retval == 0) {
                        this.exchange(leftP, pivotEnd);
                        ++pivotEnd;
                    }
                    if (leftP >= rightP) break;
                    ++leftP;
                    continue;
                }
                while (leftP < rightP) {
                    retval = this.compare(pivotP, rightP);
                    if (retval < 0) {
                        --rightP;
                        continue;
                    }
                    this.exchange(leftP, rightP);
                    if (retval == 0) break;
                    ++leftP;
                    --rightP;
                    break;
                }
                if (leftP >= rightP) break;
            }
            if (this.compare(leftP, pivotP) <= 0) {
                ++leftP;
            }
            int leftTemp = leftP - 1;
            int pivotTemp = pivotP;
            while (pivotTemp < pivotEnd && leftTemp >= pivotEnd) {
                this.exchange(pivotTemp, leftTemp);
                ++pivotTemp;
                --leftTemp;
            }
            int lNum = leftP - pivotEnd;
            if ((nElem = nElem + pivotP - leftP) < lNum) {
                this.qSortHelp(leftP, nElem);
                nElem = lNum;
                continue;
            }
            this.qSortHelp(pivotP, lNum);
            pivotP = leftP;
        }
    }

    public static class IntArray
    extends QuickSort {
        private int[] array;
        private int first;
        private int count;

        public IntArray(int[] array, int first, int count) {
            this.array = array;
            this.first = first;
            this.count = count;
        }

        public IntArray(int[] array) {
            this(array, 0, array.length);
        }

        @Override
        public int getCount() {
            return this.count;
        }

        @Override
        public int compare(int idx1, int idx2) {
            return this.array[this.first + idx1] - this.array[this.first + idx2];
        }

        @Override
        public void exchange(int idx1, int idx2) {
            int tmp = this.array[this.first + idx1];
            this.array[this.first + idx1] = this.array[this.first + idx2];
            this.array[this.first + idx2] = tmp;
        }
    }

    public static class JavaList
    extends QuickSort {
        private List list;

        public JavaList(List list) {
            this.list = list;
        }

        @Override
        public int getCount() {
            return this.list.size();
        }

        @Override
        public int compare(int idx1, int idx2) {
            Object o1 = this.list.get(idx1);
            Object o2 = this.list.get(idx2);
            return this.compare(o1, o2);
        }

        public int compare(Object o1, Object o2) {
            String s1 = o1 != null ? o1.toString() : "";
            String s2 = o2 != null ? o2.toString() : "";
            return s1.compareToIgnoreCase(s2.toString());
        }

        @Override
        public void exchange(int idx1, int idx2) {
            Object tmp = this.list.get(idx1);
            this.list.set(idx1, this.list.get(idx2));
            this.list.set(idx2, tmp);
        }
    }

    public static class JavaVector
    extends QuickSort {
        private Vector vector;

        public JavaVector(Vector vector) {
            this.vector = vector;
        }

        @Override
        public int getCount() {
            return this.vector.size();
        }

        @Override
        public int compare(int idx1, int idx2) {
            Object o1 = this.vector.elementAt(idx1);
            Object o2 = this.vector.elementAt(idx2);
            return this.compare(o1, o2);
        }

        public int compare(Object o1, Object o2) {
            return o1.toString().compareToIgnoreCase(o2.toString());
        }

        @Override
        public void exchange(int idx1, int idx2) {
            Object tmp = this.vector.elementAt(idx1);
            this.vector.setElementAt(this.vector.elementAt(idx2), idx1);
            this.vector.setElementAt(tmp, idx2);
        }
    }

    public static class ObjectArray
    extends QuickSort {
        private Object[] array;
        private int first;
        private int count;

        public ObjectArray(Object[] array, int first, int count) {
            this.array = array;
            this.first = first;
            this.count = count;
        }

        public ObjectArray(Object[] array) {
            this(array, 0, array != null ? array.length : 0);
        }

        @Override
        public int getCount() {
            return this.count;
        }

        @Override
        public void exchange(int idx1, int idx2) {
            Object tmp = this.array[this.first + idx1];
            this.array[this.first + idx1] = this.array[this.first + idx2];
            this.array[this.first + idx2] = tmp;
        }

        public Object getObject(int index) {
            return this.array[index];
        }

        @Override
        public int compare(int idx1, int idx2) {
            return this.compare(this.array[idx1], this.array[idx2]);
        }

        public int compare(Object o1, Object o2) {
            if (o1 == null && o2 == null) {
                return 0;
            }
            if (o2 == null) {
                return 1;
            }
            if (o1 == null) {
                return -1;
            }
            return o1.toString().compareTo(o2.toString());
        }
    }

    public static class StringArray
    extends QuickSort {
        private String[] array;
        private int first;
        private int count;
        private boolean ignoreCase;

        public StringArray(String[] array, int first, int count, boolean ignoreCase) {
            this.array = array;
            this.first = first;
            this.count = count;
            this.ignoreCase = ignoreCase;
        }

        public StringArray(String[] array, boolean ignoreCase) {
            this(array, 0, array != null ? array.length : 0, ignoreCase);
        }

        public StringArray(String[] array) {
            this(array, false);
        }

        @Override
        public int getCount() {
            return this.count;
        }

        @Override
        public int compare(int idx1, int idx2) {
            return this.compare(this.array[this.first + idx1], this.array[this.first + idx2]);
        }

        public int compare(String s1, String s2) {
            if (s1 == null && s2 == null) {
                return 0;
            }
            if (s2 == null) {
                return 1;
            }
            if (s1 == null) {
                return -1;
            }
            if (this.ignoreCase) {
                return s1.compareToIgnoreCase(s2);
            }
            return s1.compareTo(s2);
        }

        @Override
        public void exchange(int idx1, int idx2) {
            String tmp = this.array[this.first + idx1];
            this.array[this.first + idx1] = this.array[this.first + idx2];
            this.array[this.first + idx2] = tmp;
        }
    }
}

